/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *  Task.c -- code related to task management
 * Although urgent and immediate mode are supported here, we recommend that they
 * not be used.  Really, we do.  It wouldn't be a good idea.  Nope.  Not at all.
 */

# include <stdio.h>
# include <string.h>

# include "pr.h"

/* On some machine setjmp and longjmp work fine for ISIS */ 
#ifdef  GOULD 
#    define    isis_setjmp      _setjmp 
#    define    isis_longjmp     _longjmp
#endif
#ifdef NEXT
#    define    isis_setjmp      _setjmp 
#    define    isis_longjmp     _longjmp 
#endif
#ifdef APOLLO
#    define    isis_setjmp      _setjmp 
#    define    isis_longjmp     _longjmp 
#endif
#ifdef HPUX
#ifdef hp9000s800
#    define    isis_setjmp      _setjmp
#    define    isis_longjmp     _longjmp
#endif hp9000s800
#endif

adesc           st_ad ={ TASKLEN, 0, 8 };

# define        st_alloc()      ((task*)mallocate(&st_ad))
# define        st_free(x)      mdeallocate((char*)x, &st_ad)

task    scheduler;              /* Task descriptor for system task */
task    *ctp = &scheduler;      /* Scheduler is running initially */

static  swtch();

# define        NULLROUTINE     (int(*)())      0
# define        NULLARG         (char*)         0
# define        NULLTASK        (task*)         0
address         NULLADDRESS;

static  message *task_msg_arg;

#define task_enqueue(cp, tp, discipline)                        \
  {                                                             \
        if(tp)                                                  \
        {                                                       \
            register queue *qp;                                 \
            if((qp = *cp) == 0)                                 \
            {                                                   \
                qu_tnull(qp);                                   \
                *cp = qp;                                       \
            }                                                   \
            if(discipline == SU)                                \
                qu_add_tp(qp->qu_next, TA_ISTASK, tp);          \
            else                                                \
                qu_add_tp(qp, TA_ISTASK, tp);                   \
            tp->task_queue = cp;                                \
        }                                                       \
  }

task *
do_task_dequeue(cp)
  register condition *cp;
  {
        register queue *qp, *np;
        register task *tp;
        qp = *cp;
        np = qu_head(qp);
        tp = np->qu_task;
        tp->task_queue = 0;
        qu_free(np);
        if(qp->qu_next == qp)
        {
            qu_free(qp);
            *cp = 0;
        }
        return(tp);
  }      
 
run_tasks()
  {
        register task *tp;

        scheduler.task_routine = run_tasks;
        while((tp = task_dequeue(&runqueue)) != &scheduler)
            swtch(tp, NULLROUTINE, NULLARG);
  }

int     inhibit_swtch;

t_fork_urgent(routine, arg0, mp)
  int (*routine)();
  char *arg0;
  message *mp;
  {
        if(inhibit_swtch)
            panic("t_fork_urgent with inhibit_swtch set");
        if(task_msg_arg = mp)
            msg_increfcount(mp);
        task_enqueue(&runqueue, ctp, SU);
        swtch(NULLTASK, routine, arg0);
  }

static  task *urgent_task;
static  fork_mode;

t_fork_immed(routine, arg0, mp)
  int (*routine)();
  char *arg0;
  message *mp;
  {
        if(task_msg_arg = mp)
            msg_increfcount(mp);
        urgent_task = ctp;
        fork_mode = SU;
        swtch(NULLTASK, routine, arg0);
  }

t_fork(routine, arg0, mp)
  int (*routine)();
  char *arg0;
  message *mp;
  {
        if(task_msg_arg = mp)
            msg_increfcount(mp);
        urgent_task = ctp;
        fork_mode = SD;
        swtch(NULLTASK, routine, arg0);
  }

static delayedcall(routine, arg0)
  int (*routine)();
  char *arg0;
  {
        register task *tp = urgent_task;
        urgent_task = 0;
        task_enqueue(&runqueue, ctp, fork_mode);
        swtch(tp, nullroutine, (char*)0);
        (*routine)(arg0);
  }

static  char *stackp;

static swtch(tp, routine, arg0)
  register task *tp;
  register int (*routine)();
  register char *arg0;
  {
        static task *free_tp = 0;
        t_scheck();
        /* Save entry information */
        if(isis_setjmp(ctp->task_env))
        {
            if(free_tp)
            {
                st_free(free_tp);
                free_tp = 0;    
            }
            return;
        }

        /* Allocate a stack for the new task if needed */
        if(tp == 0)
        {
            ctp = st_alloc();
            ctp->task_queue = 0;
            ctp->task_msgid = 0;
            ctp->task_cond = 0;
            ctp->task_iwait = 0;
            ctp->task_mwant = 0;
            ctp->task_msg = 0;
            bclr(ctp->task_watching);
            ctp->task_msgs = qu_null();
            ctp->task_active = qu_add_tp(tasks, TA_ISTASK, ctp);
            ctp->task_routine = routine;
            ctp->task_arg0 = arg0;
            ctp->task_addr = my_address;
            ctp->task_addr.entry = my_entry;
            ctp->task_msg_arg = task_msg_arg;
            task_msg_arg = 0;
            /* Change stack pointers.  Alignment is important for many machines */
#           if(VAX)
            {
                stackp = &ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movl  _stackp,sp");
            }
#           endif
#           if(GOULD)
            {
                stackp = &ctp->task_data[STACKLEN-(24 words)];
                stackp = (char*)((int)stackp & ~0x7);
                asm("movw  _stackp,b2");
            }
#           endif
#           if(SUN3)
            {
                stackp = &ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movl  _stackp,sp");
            }
#           endif
#           if(NEXT)
            {
                stackp = &ctp->task_data[STACKLEN-(16 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movel _stackp,sp");
            }
#           endif
#           if(SUN4)
            {
#               include <sun4/asm_linkage.h>
                stackp = &ctp->task_data[STACKLEN-(32 words)];
                stackp = (char*)((int)stackp & ~(STACK_ALIGN-1));
                asm("sethi   %hi(_stackp),%o0");
                asm("ld      [%o0+%lo(_stackp)],%sp");
            }
#           endif
#           if(HPUX)
            {
#ifdef          hp9000s300
                    stackp = &ctp->task_data[STACKLEN-(2 words)];
                    stackp = (char*)((int)stackp & ~0x3);
                    asm("mov.l  _stackp,%sp");
#endif          hp9000s300
#ifdef          hp9000s800
                    stackp = &ctp->task_data[0];
                    stackp = (char*)((((int)stackp+7) & ~0x7)+ 48);
                    set_sp(stackp);
#endif          hp9000s800

            }
#           endif
#           if(APOLLO)
            {
                jmp_buf tmp_buf;
                stackp = &ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                if(_setjmp(tmp_buf) == 0)
                {
                     /* Ghastly hack */
                     tmp_buf[sizeof(tmp_buf)/sizeof(long)-1] = stackp;
                     _longjmp(tmp_buf);
                }
            }
#           endif
            /* Initial invocation of a routine */
            ++ntasks;
            EVENT(S_NFORK);
            if(urgent_task)
                delayedcall(routine, arg0);
            else
                (*routine)(arg0);
            /* Done, deallocate the stack */
            --ntasks;
            ctp->task_routine = 0;
            tp = task_dequeue(&runqueue);
            qu_free(ctp->task_active);
            qu_freeall(ctp->task_msgs);
            if(ctp->task_msg_arg)
                msg_delete(ctp->task_msg_arg);
            free_tp = ctp;
        }

        EVENT(S_NSWTCH);
        ctp = tp;
        isis_longjmp(tp->task_env, 1);
  }

t_scheck()
  {
        char stackp;
        if(ctp != &scheduler && &stackp <= ctp->task_data)
            panic("Stack violation");
  }

t_sdump()
  {
        register *sp;
        register n = 0;
        t_scheck();
        sp = (int*)stackp;
        while(sp <= (int*)&ctp->task_data[STACKLEN])
        {
            print("%8.8x  ", *sp++);
            if((++n&3) == 0)
                print("\n");
        }
        if(n&3)
            print("\n");
  }

/****************************************************************/
/*                                                              */
/*                 Basic monitor support                        */
/*                                                              */
/****************************************************************/
t_sig_all(cp, rval)
  register condition *cp;
  {
        while(*cp)
            t_sig(cp, rval);
  }

t_sig(cp, rval)
  register condition *cp;
  {
        register queue *qp = *cp;
        if(qu_head(qp))
        {
            register task *tp = task_dequeue(cp);
            task_enqueue(&runqueue, tp, SD);
            tp->task_rval = rval;
        }
  }

t_sig_urgent(cp, rval)
  register condition *cp;
  {
        register queue *qp;

        if(qp = qu_head(*cp))
        {
            qp->qu_task->task_rval = rval;
            task_enqueue(&runqueue, ctp, SU);
            swtch(task_dequeue(cp), NULLROUTINE, NULLARG);
        }
  }

t_sig_immed(cp, rval)
  register condition *cp;
  {
        register queue *qp = *cp;

        if(qu_head(qp))
        {
            register task *tp = task_dequeue(cp);
            task_enqueue(&runqueue, tp, SU);
            tp->task_rval = rval;
        }
  }

t_wait(cp, why)
  condition *cp;
  char *why;
  {
        register task *tp;
        if(inhibit_swtch)
            panic("t_wait with inhibit_swtch set");
        ctp->task_waitingfor = why;
        task_enqueue(cp, ctp, SD);
        tp = task_dequeue(&runqueue);
        swtch(tp, NULLROUTINE, NULLARG);
        return(ctp->task_rval);
  }

t_suspend(why)
  char *why;
  {
        register task *tp;
        if(inhibit_swtch)
            panic("t_wait with inhibit_swtch set");
        ctp->task_waitingfor = why;
        tp = task_dequeue(&runqueue);
        swtch(tp, NULLROUTINE, NULLARG);
        return(ctp->task_rval);
  }
