/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 *
 * This is a modified version of _setjmp.s for use in ISIS
 * It lacks most of the "botch" testing, which fails in ISIS
 * due to non-standard stack frame allocation scheme
 *
 * Setjmp: store frame into jmp buffer
 * Longjmp: restore frame and then return to the
 * caller who called 'setjmp' in the first place
 *
 * Unlike the standard versions, setjmp may assume that the
 * caller will have saved all registers that might need to be saved.
 * This is important because if these registers are not saved,
 * the caller could see his register variables get trashed.
 */
#ifdef  VAX
        .text
        .globl  _isis_setjmp
        .align  2
_isis_setjmp:
        .word   0
        movl    4(ap),r0
        movl    r2,(r0)+
        movl    r3,(r0)+
        movl    r4,(r0)+
        movl    r5,(r0)+
        movl    r6,(r0)+
        movl    r7,(r0)+
        movl    r8,(r0)+
        movl    r9,(r0)+
        movl    r10,(r0)+
        movl    r11,(r0)+
        movl    12(fp),(r0)+            # save frame pointer of caller
        movl    16(fp),(r0)+            # save pc of caller
        clrl    r0
        ret

        .globl  _isis_longjmp
        .align  2
_isis_longjmp:
        .word   0
        movl    8(ap),r0                # return(v)
        movl    4(ap),r1                # fetch buffer
        movl    (r1)+,r2
        movl    (r1)+,r3
        movl    (r1)+,r4
        movl    (r1)+,r5
        movl    (r1)+,r6
        movl    (r1)+,r7
        movl    (r1)+,r8
        movl    (r1)+,r9
        movl    (r1)+,r10
        movl    (r1)+,r11
        movl    (r1)+,fp
        jmp     *(r1)
#endif  VAX

#ifdef  SUN4
        .text
!       .seg    "data"
!       .asciz  "@(#)_setjmp.s 1.6 87/06/14 Copyr 1987 Sun Micro"
        .seg    "text"

#include <sun4/asm_linkage.h>
#include <sun4/trap.h>

/*
 * isis_setjmp(buf_ptr)
 * buf_ptr points to a five word array (jmp_buf). In the first is our
 * return address, the second, is the callers SP.
 * The rest is cleared by _setjmp
 *
 *              +----------------+
 *   %i0->      |      pc        |
 *              +----------------+
 *              |      sp        |
 *              +----------------+
 *              |    sigmask     |
 *              +----------------+
 *              |   stagstack    |
 *              |   structure    |
 *              +----------------+
 *
 *
 * We flush the register file to the stack by doing a kernel call.
 * This is necessary to ensure that the registers we want to save
 * are stored on the stack.
 */
 
        PCVAL   =       0       ! offsets in buf structure
        SPVAL   =       4
        SIGMASK =       8
        SIGSTACK =      12
 
        SS_SP      =    0       ! offset in sigstack structure
        SS_ONSTACK =    4
 
        ENTRY(isis_setjmp)
        t       ST_FLUSH_WINDOWS        ! flush all reg windows to the stack.
        st      %o7, [%o0 + PCVAL]      ! return pc
        st      %sp, [%o0 + SPVAL]      ! save caller's sp
        clr     [%o0 + SIGMASK]         ! clear the remainder of the jmp_buf
        clr     [%o0 + SIGSTACK + SS_SP]
        clr     [%o0 + SIGSTACK + SS_ONSTACK]
        retl
        clr     %o0                     ! return zero
 
/*
 * isis_longjmp(buf_ptr, val)
 * buf_ptr points to an array which has been initialized by isis_setjmp.
 * val is the value we wish to return to isis_setjmp's caller
 *
 * First, we set fp from the saved fp and make a stack frame.  The restore
 * causes the window pointed to by the saved fp to be restored.
 */
        ENTRY(isis_longjmp)
        sub     %sp, WINDOWSIZE, %sp    ! establish new save area (paranoid)
        ld      [%o0 + SPVAL], %fp      ! build new stack frame
        ld      [%o0 + PCVAL], %o7      ! get new return pc
        retl
        restore %o1, 0, %o0             ! return (val)
#endif

#ifdef  SUN3
#define PARAMX( n )     sp@(4+n)
#define PARAM0          PARAMX(-4)
#define PARAM           PARAMX(0)
#define PARAM2          PARAMX(4)

.globl  _isis_setjmp; _isis_setjmp:
        movl    PARAM,a0        /* pointer to jmp_buf */
        movl    PARAM0,a0@      /* pc */
        clrl    a0@(4)
        clrl    a0@(8)
        moveml  #0xFCFC,a0@(12) /* d2-d7, a2-a7 */
        clrl    d0              /* return 0 */
        rts

.globl  _isis_longjmp; _isis_longjmp:
        movl    PARAM,a0        /* pointer to jmp_buf */
        movl    PARAM2,d0       /* value returned */
        bne     1$
        moveq   #1,d0
1$:
        moveml  a0@(12),#0xFCFC /* restore d2-d7, a2-a7 */
        movl    a0@,sp@         /* restore pc of call to setjmp to stack */
        rts
#endif


#ifdef  NEXT
flarb:
#endif

#ifdef  GOULD
flarb:
#endif

#ifdef  HPUX
#ifdef hp9000s300
        global   _isis_setjmp,_isis_longjmp
        text    
                
_isis_setjmp:
        mov.l   4(%a7),%a0
        mov.l   %d0,0x34(%a0)
        mov.l   (%a7),(%a0)
        movm.l  %d2-%d7/%a0-%a7,4(%a0)
        clr.l   %d0
        rts     
                
_isis_longjmp:
        mov.l   4(%a7),%a0
        mov.l   8(%a7),%d0
        movm.l  4(%a0),%d2-%d7/%a0-%a7
        mov.l   (%a0),(%a7)
        tst.l   %d0
        bne     XX
        movq    &1,%d0
XX:     rts     
#endif hp9000s300
#ifdef hp9000s800

        .CODE
        .EXPORT get_sp
        .EXPORT set_sp

get_sp
        .PROC
        .CALLINFO 

        .ENTER
        BV      0(%rp)
        COPY    %sp,%ret0
        .LEAVE
        .PROCEND


set_sp
        .PROC
        .CALLINFO 

        .ENTER
        BV      0(%rp)
        COPY    %arg0,%sp
        .LEAVE
        .PROCEND

        .END

#endif hp9000s800
#endif
