/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Queue manipulation routines
 */

#include "pr.h"

adesc    qu_adesc ={ sizeof(queue), 0, 16 };

queue *
qu_alloc(name, data, routine)
  char *data;
  ifunc *routine;
  {
        register queue *qp;
        qu_alloc1(qp, name, data, routine);
        return(qp);
  }

/* add a node to qp, returns np */
queue *
qu_add(qp, name, data, routine)
  register queue *qp;
  char *data;
  ifunc *routine;
  {
        register queue *np;
        qu_alloc3(np, name, data, 0, 0, routine);
        qu_append(qp, np);
        return(np);
  }

queue *
qu_add_pg(qp, name, paddr)
  register queue *qp;
  address paddr;
  {
        register queue *np;
        qu_alloc3(np, 0, 0, 0, 0, 0);
        np->qu_address = paddr;
        qu_append(qp, np);
        return(np);
  }

queue *
qu_add_cb(qp, proc, arg0, arg1)
  register queue *qp;
  int (*proc)();
  char *arg0, *arg1;
  {
        register queue *np;
        qu_alloc3(np, (int)proc, arg0, arg1, 0, nullroutine);
        qu_append(qp, np);
        return(np);
  }

queue *
qu_add_sid(qp, name, sid)
  register queue *qp;
  site_id sid;
  {
        register queue *np;
        qu_alloc3(np, name, 0, 0, 0, nullroutine);
        np->qu_sid = sid;
        qu_append(qp, np);
        return(np);
  }

queue *
qu_add_bits(qp, name)
  register queue *qp;
  {
        register queue *np;
        qu_alloc1(np, name, 0, nullroutine);
        bclr(np->qu_bitvec);
        qu_append(qp, np);
        return(np);
  }

/* Resort queue qp when name of node np has changed */
qu_resort(qp, np)
  register queue *qp, *np;
  {
        register queue *op;
        qu_remove(np);
        op = qp->qu_next;
        while(op != qp)
        {
            if(op->qu_name > np->qu_name)
                break;
            op = op->qu_next;
        }
        op->qu_last->qu_next = np;
        np->qu_last = op->qu_last;
        op->qu_last = np;
        np->qu_next = op;
  }

/* Free a queue */
qu_freeall(qp)
  register queue *qp;
  {
        register queue *np, *nnp;

        if(qp == 0)
            return;
        nnp = qp->qu_next;
        do
        {
            np = nnp;
            nnp = np->qu_next;
            qu_free(np);
        }
        while(np != qp);
  }

queue *
qu_find(qp, item)
  register queue *qp;
  {
        register queue *np;

        if(qp == 0)
            return(0);
        np = qp;
        while(np->qu_name != item && (np = np->qu_next) != qp) ;
        if(np->qu_name != item)
            return((queue*)0);
        return(np);
  }

/* Create a new node or a new queue.  */
queue *
pg_alloc(pname, data, routine)
  address pname;
  char *data;
  ifunc *routine;
  {
        register queue *qp;
        pname.entry = 0;
        qu_allocpg(qp, pname, data, routine);
        return(qp);
  }

/* add a node to qp, returns np */
queue *
pg_add(qp, pname, data, routine)
  address pname;
  register queue *qp;
  char *data;
  ifunc *routine;
  {
        register queue *np;
        pname.entry = 0;
        qu_allocpg(np, pname, data, routine);
        qu_append(qp, np);
        return(np);
  }

queue *
pg_find(qp, pname)
  address pname;
  register queue *qp;
  {
        register queue *np;

        np = qp;
        while(addr_cmp(np->qu_pname, pname)  && (np = np->qu_next) != qp)
            continue;
        if(addr_cmp(np->qu_pname, pname))
            return((queue*)0);
        return(np);
  }
