/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* A message tank is a bounded queue of pending messages. The bound is
   on the total bytes of message storage. */

#define tankstats 1

#define TANK_EMPTY      0
#define TANK_ATEONE     1
#define TANK_OTHER      2
#define TANK_FULL       3

typedef struct msg_tank{
  queue *head;                  /* Queue (FIFO) of pending messages. */
  long max_size;                /* Bound on number of bytes of stored messages. */
  long size;                    /* Current number of bytes of stored messages. */
#ifdef tankstats
  long max_bytes_used;                /* Maximum bytes ever used. */
  long nr_msgs1;
  long nr_msgs2;
#endif tankstats
} msg_tank;

int     tankcount[MAX_SITES];   /* Number from each sender */

#define default_max_size 50000 /* bytes. */

msg_tank *msg_tank_create();
extern int msg_tank_enqueue();
message *msg_tank_dequeue();
extern int msg_tank_set_max();
extern int msg_tank_print();
