/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include "pr.h"

#define NETLIM          2               /* Take 66% of load from network */

#define NORMAL          1               /* Normal termination */
#define HALTED          2               /* Halt() of a site */
#define PANIC           -1              /* Panic termination */

int     staged_xmit, ISIS_TIME;
static  running;
static  coredump;
static  nsites, append_to_log;
static  cid[MAX_SITES];
static  struct  timeval sel_wait ={ 0,  250 }, no_wait = { 0, 0 };
static  struct timeval time_0;
static  char logfile[20];
static  char *sname;
static  long cur_t;


static restartchk()
  {
        if(proposed_viewid == 0 && my_site_incarn == RECOVERY_INCARN)
             panic("site-restart sequence failure");
  }

main(argc, argv)
  char **argv;
  {
        register i;

        for(i = 0; i < MAXBITS; i++)
            bis(ones, i);
        gethostname(my_host, 64);
        for (i = 0; i < MAX_SITES; i++)
            current_view.sv_incarn[i] = DOWN_INCARN;
        my_process_id = PROTOCOLS;
        my_site_incarn = RECOVERY_INCARN;
        sname = "./sites";
        isis_dir = "/usr/spool/isis";
        while(--argc)
        {
            register char *arg;
            register code;

            arg = *++argv;
            code = *arg++;
            if(code != '-')
            {
              bum_arg:
                print("Bad argument to <protos>: %s (ignored)\n", --arg);
                continue;
            }
            while(code = *arg++)
                switch(code)
                {
                    extern crash_self;

                  default:
                    arg = (*argv)+1;
                    goto bum_arg;

                  case 'a':
                    ++append_to_log;
                    continue;

                  case 'C':
                    ++crash_self;
                    continue;

                  case 'u':
                    ++msg_usagestats;
                    continue;

                  case 'm':
                    ++msg_tracemsgs;
                    continue;

                  case 't':
                    ++msg_tracecaller;
                    continue;
 
                 case 'f':
                    ++fail_msgno;
                    continue;

                  case 's':
                    ++staged_xmit;
                    continue;

                  case 'N':
                    NSITES = atoi(arg);
                    goto next;

                  case 'd':
                    if(*arg == 0)
                    {
                        --argv;
                        arg = *++argv;
                    }
                    isis_dir = arg;
                    goto next;

                  case 'S':
                    if(*arg == 0)
                    {
                        --argv;
                        arg = *++argv;
                    }
                    sname = arg;
                    goto next;

                  case 'H':
                    if(*arg == 0)
                    {
                        --argv;
                        arg = *++argv;
                    }
                    my_site_no = atoi(arg);
                    goto next;
                }
          next:
            continue;
        }

        scan_sfile();

        /* Initialize entry points */
        isis_entries();


        if (fail_msgno)
        {
            FILE    *failfile;
            int     msg_no, site_no;
            char    failname[16];

            sprintf (failname, "%d.fail", my_site_no);
            if ((failfile = fopen (failname, "r")) == (FILE *) NULL)
                fail_msgno = fail_sender = 0;
            else
            {
                fscanf (failfile, "%d %d", &fail_msgno, &fail_sender);
                fclose (failfile);
            }
        }

        begin
        {
            register old, new;
	    struct timeval rtime;
            close(old = fileno(stdout));
            sprintf(logfile, "%d.log", my_site_no);
            new = open(logfile, append_to_log? (O_WRONLY|O_CREAT|O_APPEND): (O_WRONLY|O_CREAT|O_TRUNC), 0666);
            if(new != old)
                dup2(new, old);
	    gettimeofday(&rtime, (struct timezone*)0);
	    print(ctime(&rtime.tv_sec));
        }
        main_loop();
  }

/* rescan the sites file */
pr_rescansfile(mp)
  message *mp;
  {
        message *msg = msg_newmsg();
        BCAST_V(&current_view, PROTOCOLS, PR_DOSCANSITES, msg, 0, 0, 0, 0);
        msg_delete(msg);
        reply(mp, &nsites, FTYPE_LONG, sizeof(long));
  }

pr_doscansfile(mp)
  message *mp;
  {
        scan_sfile();
  }

static  queue *scope_queue;

/* Set bit in scope variable */
set_scope(scope, bno)
  char *scope;
  {
        register queue *qp;
        register len;
        if(*scope == 0)
            return;
        for(qp = scope_queue->qu_next; qp != scope_queue; qp = qp->qu_next)
            if(strcmp(qp->qu_sname, scope) == 0)
            {
                bis(qp->qu_bitvec, bno);
                return;
            }
        len = strlen(scope)+1;
        qp = qu_add_bits(scope_queue, malloc(len));
        bcopy(scope, qp->qu_sname, len);
        bis(qp->qu_bitvec, bno);
  }

/* Set slist from scope */
sl_scope(scope, slist)
  register site_id *slist;
  register char *scope;
  {
        register flag = 0;
        register queue *qp;
        register site_id *sp;
        bitvec search_scope;
        if(scope == 0)
            scope = "";
        *slist = 0;
        bclr(search_scope);
        for(qp = scope_queue->qu_next; qp != scope_queue; qp = qp->qu_next)
            if(strcmp(qp->qu_sname, scope) == 0)
                break;
        if(qp != scope_queue)
        {
            bisv(search_scope, qp->qu_bitvec);
        }
        else switch(*scope)
        {
          case '*':
            bset(search_scope);
            break;
          default:
            return(0);
          case 0:
            for(qp = scope_queue->qu_next; qp != scope_queue; qp = qp->qu_next)
                if(bit(qp->qu_bitvec, my_site_no))
                    bisv(search_scope, qp->qu_bitvec);
            if(btst(search_scope))
                bis(search_scope, my_site_no);
            else
                bset(search_scope);
            break;
        }
        for(sp = current_view.sv_slist; *sp; sp++)
            if(bit(search_scope, SITE_NO(*sp)))
            {
                if(SITE_NO(*sp) == my_site_no)
                    ++flag;
                *slist++ = *sp;
            }
        *slist = 0;
        return(flag);
  }

dump_scopes()
  {
        register queue *qp;
        if(scope_queue)
            for(qp = scope_queue->qu_next; qp != scope_queue; qp = qp->qu_next)
            {
                register s;
                printf("Scope <%s> = ", qp->qu_sname);
                dump_bitv(qp->qu_bitvec);
                printf("\n");
            }
  }

scan_sfile()
  {
        FILE *sfile;
        char str[64], scope[64];
        int port, cport, rport, sid;
        register ns = 0;
        static first_time;
        register queue *qp;
    
        if(scope_queue == 0)
            scope_queue = qu_null();
        while(qp = qu_head(scope_queue))
        {
            free(qp->qu_sname);
            qu_free(qp);
        }
        if((sfile = fopen(sname, "r")) == (FILE*)NULL)
            panic("%s: cannot open", sname);
        nsites = 0;
        forever
        {
            register isup = fgetc(sfile);
            register c;
            if(fscanf(sfile, "%d:%d,%d,%d %s", &sid, &port, &cport, &rport, str) < 5)
                break;
            else if(sid < 0 || sid >= MAX_SITES)
                print("Site number %d out of bounds, ignored!\n", sid);
            else if(isup == '+')
            {
                if(*site_names[sid] && strcmp(site_names[sid], str))
                    print("Warning: site number %d <%s>: redeclared as <%s>!\n", sid, site_names[sid], str);
                strcpy(site_names[sid], str);

                /* Scan scope information */
                c = fgetc(sfile);
                while(c > 0 && c != '\n')
                {
                    register char *sp;
                    while(c == ',' || c == ' ')
                        c = fgetc(sfile);
                    sp = scope;
                    while(c > 0 && c != ',' && c != ' ' && c != '\n')
                    {
                        *sp++ = c;
                        c = fgetc(sfile);
                    }
                    *sp = 0;
                    if(*scope)
                        set_scope(scope, sid);
                }
                udp_port[sid] = port;
                connect_port[sid] = cport;
                if(sid > nsites)
                    nsites = sid;
                if(my_site_no == 0)
                {
                    register i = 0;
                    while((my_host[i] == site_names[sid][i]) && my_host[i])
                        ++i;
                    if(my_host[i] == 0)
                        my_site_no = sid;
                }
                continue;
            }
            else
                while((c = fgetc(sfile)) > 0 && c != '\n')
                    continue;
        }
        if(my_site_no == 0)
            panic("%s: not found in site-file \"%s\"", my_host, sname);
        fclose(sfile);
        if(first_time++)
        {
            message *mp = msg_genmsg(CL_NEW_SNAMES, site_names, FTYPE_CHAR, nsites * sizeof(*site_names), 0);
            cl_send_all(GENERIC_NEW_SNAMES, mp);
            msg_delete(mp);
        }
  }

/* Causes a site to abort and dump core */
dump()
  {
        register int *ip;
        pr_dump(DUMP_ALL, "signal DUMP");
  }

#define must_wait()     (runqueue == 0 && tank_status() == TANK_EMPTY)
extern FILE *statfile;

main_loop()
  {
        int exit(), max;
        char logfile[20];
        bitvec in_mask;
        register s;
        int n_net_inputs = 0;

        gettimeofday(&time_0, (struct timezone*)0);
        my_site_id = MAKE_SITE_ID(my_site_no, my_site_incarn);
        my_address = ADDRESS(my_site_no, my_site_incarn, PROTOCOLS, GENERIC_RCV_REPLY);
        pr_initialize();
        signal(SIGHUP, dump);
        signal(SIGPIPE, SIG_IGN);
        signal(SIGINT, exit);
        ++running;
        print("isis <%s> is now coming up, site %d\n", my_host, my_site_no);
        net_init();
        client_init();

        bclr(in_mask);
        max = 32;
        if(NSITES)
        {
            char statname[20];
            int save_stats();
            sprintf(statname, "%d.stats", my_site_no);
            statfile = fopen(statname, "w");
            timeout(5000, save_stats, 0, 0);
        }
        timeout(10000, restartchk, 0, 0);
        forever
        {
            static cl_congested;
            register rv, dt;
            int memuse = memalloc-memfree, msgmem = msg_memused-msg_memfree;
            extern net_xmits;

            /* First run tasks for a while */
            run_tasks();

            /* Now deliver input for a while */
            n_net_inputs = 0;
            while(n_net_inputs < NETLIM)
            {
                switch(net_deliver())
                {
                  case TANK_EMPTY:
                        break;
                  case TANK_ATEONE:
                        ++n_net_inputs;
                  case TANK_OTHER:
                        continue;
                }
                break;
            }

            if(cl_congested == 0 && (memuse > MEM_HI || msgmem > MSGMEM_HI || ntasks > TASK_HI || intersite_congested > INTERSITE_HI))
            {
                ++cl_congested;
                cl_send_all(GENERIC_CONGESTED, 0);
            }
            else if(cl_congested && (memuse < MEM_LO && msgmem < MSGMEM_LO && ntasks < TASK_LO && intersite_congested < INTERSITE_LO))
            {
                --cl_congested;
                cl_send_all(GENERIC_DECONGESTED, 0);
            }
            /* Check for input */
            if(btst(in_mask) == 0)
            {
                bitvec out_mask;
                register mw;
                out_mask = congested;
                in_mask = input_mask;
            again:
                if(runqueue == 0)
                {
                    register queue *qp;
                    if(qp = qu_head(time_queue))
                    {
                        register time = qp->qu_time-Gettime();
                        if(time < 250)
                            time = 250;
                        sel_wait.tv_sec = time/1000;
                        sel_wait.tv_usec = (time % 1000)*1000;
                    }
                    else
                        panic("net_sweep not listed in timeout queue!");
                }
                if(tank_status() == TANK_FULL)
                    bic(in_mask, net_socket);
                mw = must_wait();
                if((rv = select(max, &in_mask, &out_mask, (int*)0, mw? &sel_wait: &no_wait)) == -1)
                {
                    if(errno == EINTR)
                        goto again;
                    if(errno == EBADF)
                    {
                        register b;
                        /* Some client died violently */
                        for(b = 0; b < max; b++)
                        {
                            if(bit(input_mask, b) == 0)
                                continue;
                            bclr(in_mask);
                            bis(in_mask, b);
                            if(select(max, &in_mask, (int*)0, (int*)0, &no_wait) == -1 && errno == EBADF)
                                if(b == net_socket)
                                    panic("select -- bad net_sock");
                                else
                                    client_failed(b, TRUE);
                        }
                        goto again;
                    }
                    perror("select");
                    panic("select");
                }
                if(mw)
                    Gettime();
                if(rv == 0)
                    bclr(in_mask);
                if(btst(out_mask))
                    cl_restart_io(out_mask);
            }
            net_xmits = 0;
            if(bit(in_mask, net_socket))
            {
                /* Tank all pending network input. */
                net_drain_input();
                bic(in_mask, net_socket);
            }
            if(runqueue == 0 && btst(in_mask))
            {
                register b, i = 0;
                if(bit(in_mask, connect_bit))
                {
                    bic(in_mask, connect_bit);
                    client_accept();
                    while(max <= max_cl)
                        max += 32;
                }
                for(b = 0; b <= max_cl; b++)
                {
                    if(bit(in_mask, b))
                    {
                        pr_local_rcv(i);
                        bic(in_mask, b);
                        break;
                    }
                    ++i;
                }
            }
            cur_t = ISIS_TIME;
            begin
            {
                register queue *qp;
                while((qp = qu_head(time_queue)) && qp->qu_time <= cur_t)
                {
                    qu_remove(qp);
                    qu_free(qp);
                    continue;
                }
            }
        }
  }


/* Specifies a timeout in milliseconds */
int     TIMEOUT_ID;

timeout(time, routine, arg0, arg1)
  int (*routine)();
  char *arg0, *arg1;
  {
        return(timeout_reschedule(0, time, routine, arg0, arg1));
  }

timeout_reschedule(oldtid, time, routine, arg0, arg1)
  register time, oldtid;
  int (*routine)();
  char *arg0, *arg1;
  {
        register queue *qp;
        extern net_sweep();

        time += ISIS_TIME;
        if(routine == net_sweep)
        {
            /* Round up to next second */
            time += 999;
            time -= time%1000;
        }
        if(oldtid)
            for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
                if(qp->qu_timeargs[2] == (char*)oldtid)
                {
                    if(qp->qu_time <= time)
                        return(oldtid);
                    qp->qu_freeroutine = nullroutine;
                    qu_free(qp);
                    break;
                }
        for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
            if(qp->qu_time >= time)
                break;
        qp = qu_add(qp, time, (char*)0, routine);
        qp->qu_timeargs[0] = arg0;
        qp->qu_timeargs[1] = arg1;
        qp->qu_timeargs[2] = (char*)++TIMEOUT_ID;
        return (TIMEOUT_ID);
  }

tsleep(secs) 
  { 
        int t_sig();
        condition sleeping = 0; 
        timeout(secs*1000, t_sig, &sleeping, 0); 
        (void)t_wait(&sleeping, "tsleep"); 
  } 

timeout_cancel(timeout_id)
  register int   timeout_id;
  {
        register queue *qp;

        for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
            if(qp->qu_timeargs[2] == (char*)timeout_id)
            {
                qp->qu_freeroutine = nullroutine;
                qu_free(qp);
                return(1);
            }
        return(0);
   }


panic(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac, ad, ae)
  char *fmt;
  {
        if(NSITES && statfile)
            fflush(statfile);
        if(my_site_no)
        {
            if(running)
            {
                fprintf(stderr, "%s (%d/%d): -- panic --\n", my_host, my_site_no, my_site_incarn);
                fprintf(stderr, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac, ad, ae);
                fprintf(stderr, "\n");
            }
            print("%s (%d/%d): -- panic --\n", my_host, my_site_no, my_site_incarn);
        }
        print(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab, ac, ad, ae);
        print("\n");
        pr_dump(DUMP_ALL, "aborting in panic...");
        if(coredump < 0 || coredump == my_site_no)
            abort(0);
        exit(PANIC);
  }

/* Compute elapsed time since startup but convert to milliseconds */
Gettime()
  {
        static PREV_TIME;
        struct timeval tp;
        register time, delta;
        gettimeofday(&tp, (struct timezone*)0);
        time = (tp.tv_sec-time_0.tv_sec)*1000 + tp.tv_usec/1000;
	PREV_TIME = ISIS_TIME;
        ISIS_TIME = time;
	delta = time-PREV_TIME;
	if(delta < 0 || delta > 180000)
	{
            register queue *qp;
	    print("Time warp!  Adjusting timers by %d.%.3d secs\n", delta/1000, delta%1000);
	    for(qp = time_queue->qu_next; qp != time_queue; qp = qp->qu_next)
	        qp->qu_time += delta;
	    net_timewarp(delta);
	}
        return(time);
  }


_btst(vec)
  bitvec vec;
  {
        register n;
        for(n = 0; n < BVL; n++)
            if(vec.bv_data[n])
                return(1);
        return(0);
  }

_bitv(vec1, vec2)
  bitvec vec1, vec2;
  {
        register n;
        for(n = 0; n < BVL; n++)
            if(vec1.bv_data[n] & vec2.bv_data[n])
                return(1);
        return(0);
  }
