/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#define  GENERIC_ENTRIES

#include "pr.h"

static  (*entries[MAXENTRIES])();
int     inhibit_swtch;

/* Do local deliveries of a message with some dests at this site */
pr_local_delivery_urgent(msg, plist)
  register message *msg;
  register int *plist;
  {
        int t_fork_urgent();
        do_local_delivery(t_fork_urgent, msg, plist);
  }

pr_local_delivery_immed(msg, plist)
  register message *msg;
  register int *plist;
  {
        int t_fork_immed();
        do_local_delivery(t_fork_immed, msg, plist);
  }

pr_local_delivery(msg, plist)
  register message *msg;
  register int *plist;
  {
        int t_fork();
        ++inhibit_swtch;
        do_local_delivery(t_fork, msg, plist);
        --inhibit_swtch;
  }

do_local_delivery(forker, msg, plist)
  int (*forker)();
  register message *msg;
  register int *plist;
  {
        register cnt = 0;
        register address *alist, *ap, *bp;
        int internal_invoke;
        register *pp;
        alist = msg_getdests(msg);
        if(pp = plist)
        {
            internal_invoke = 0;
            while(*pp)
                if(*pp == my_process_id)
                {
                    ++pp;
                    ++internal_invoke;
                }
                else
                {
                    ++cnt;
                    pr_local_send(*pp++, msg);
                }
        }
        else
        {
            internal_invoke = 1;
            if(alist == 0) 
                return; 
            for(ap = alist; !addr_isnull(*ap); ap++)
                if(ap->site == my_site_no && (ap->incarn == RECOVERY_INCARN || ap->incarn == my_site_incarn || my_site_incarn == RECOVERY_INCARN) && ap->process != my_process_id)
                 {
                    for(bp = alist; bp != ap; bp++)
                        if(bp->process == ap->process && bp->site == ap->site)
                            break;
                    if(bp == ap)
                    {
                        ++cnt;
                        pr_local_send(ap->process, msg);
                    }
                 }
        }
        /* Loop to do internal invocations, if any */
        if(internal_invoke)
            while(alist && !addr_isnull(*alist))
            {
                if(alist->site == my_site_no && (alist->incarn == my_site_incarn || alist->incarn == RECOVERY_INCARN || my_site_incarn == RECOVERY_INCARN))
                {
                    if(alist->process == PROTOCOLS)
                    {
                        register e = alist->entry;
                        ++cnt;
                        if(e >= 0 && e < MAXENTRIES && entries[e])
                        {
                            if(0 && e == GENERIC_RCV_REPLY)
                                rcv_reply(msg);
                            else
                            {
                                my_entry = e;
                                (*forker)(entries[e], (char*)msg, msg);
                                my_entry = 0;
                            }
                        }
                        else
                        {
                            print("Address ");
                            paddr(*alist);
                            print(" unknown\n");
                        }
                    }
                }
                ++alist;
            }
        if(cnt == 0)
        {
            print("Site %d/%d found no local dests for ", my_site_no, my_site_incarn);
            pmsg(msg);
        }
  }

/* Define mapping from entry codes to routines */
isis_entry(code, routine, rname)
  register code, (*routine)();
  char *rname;
  {
        if(code < 0 || code >= MAXENTRIES)
            panic("entry code %d", code);
        if(entries[code] && entries[code] != routine)
        {
            print("WARNING: Refinition of entry %d as %s, was ", code, rname);
            print_rname(entries[code]);
            print("\n");
        }
        entries[code] = routine;
        isis_rname(routine, rname);
  }

pentry(who, code)
  {
        if(code >= SYS_BASE && code <= MAXENTRIES)
            print(generic_entries[code-SYS_BASE]);
        else if(who == PROTOCOLS)
            print_rname(entries[code]);
        else
            print("%d", code);
  }
