/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include "pr.h"

/*
 * pr_splitdests:  Split the destination list of a given message into
 *   a list of local process names and a list of external site-id's,
 *   without duplicates on either list.
 */
pr_splitdests (msg, localprocs, ext_dests)
  message   *msg;
  int       *localprocs;
  site_id   *ext_dests;
  {
        register address *dests;
        register int i, j, n_procs, n_dests;
        register site_id dest_id;

        dests = msg_getdests(msg);
        for(i = n_procs = n_dests = 0; dests[i].site != 0; i++)
        {
            if(dests[i].site == my_site_no && dests[i].incarn == my_site_incarn)
            {
                for(j = 0; j < n_procs && localprocs[j] != dests[i].process; j++)
                    continue;
                if(j == n_procs)
                   localprocs[n_procs++] = dests[i].process;
            }
            else
            {
                dest_id = MAKE_SITE_ID(dests[i].site, dests[i].incarn);
                for(j = 0; j < n_dests && ext_dests[j] != dest_id; j++);
                if(j == n_dests)
                   ext_dests[n_dests++] = dest_id;
            }
        }
        localprocs[n_procs] = 0;
        ext_dests[n_dests] = 0;
  }

/*
 * Convert dlist into a non-local slist terminated by 0
 * and return number of local entries
 */
dltosl(ap, pp, sp)
  register address *ap;
  register int *pp;
  register site_id *sp;
  {
        site_id *slist = sp;
        register site_id *sl = sp;
        register lcount = 0;

        *pp = 0;
        while(ap && !addr_isnull(*ap))
        {
            if(ap->site == my_site_no)
            {
                if(ap->incarn == my_site_incarn || ap->incarn == RECOVERY_INCARN)
                {
                    register int *xp;
                    ++lcount;
                    for(xp = pp; *xp; xp++)
                        if(*xp == ap->process)
                            break;
                    if(*xp == 0)
                    {
                        *xp++ = ap->process;
                        *xp = 0;
                    }
                }
            }
            else
            {
                *sp = MAKE_SITE_ID(ap->site, ap->incarn);
                if(*sl == *sp && sl != sp)
                    continue;
                sl = slist;
                while(*sl != *sp)
                    ++sl;
                if(sl == sp)
                    ++sp;
            }
            ++ap;
        }
        *sp = (site_id)0;
        return(lcount);
  }
