/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Client info data structure */

#include "pr_fdect.h"
#include "pr_address.h"
#include "pr_msgfields.h"

#ifndef CINFO
#define CINFO

typedef struct cinfo cinfo;

struct  cinfo
{
        int     ci_my_site_no;
        int     ci_my_site_incarn;
        int     ci_my_site_id;
        int     ci_genid;
        sview   ci_cur_sview;
        char    ci_isisdir[128];
        char    ci_site_names[MAX_SITES][64];
};

#define SIG_OVERFLOW    SIGUSR1

/* Codes used in new_gview */
#define PG_GROW         1
#define PG_LEAVE        2
#define PG_MIGRATE      3

/* Up to 128 local ``id generators'' */
#define GEN_MSGID(n)        (((pr_lastmsg++ & 0xffff) << 15) | (n << 8) | (my_site_no & 0xff))
#define GEN_BCASTID(n)      (((pr_lastbcast++ & 0xffff) << 15) | (n << 8) | (my_site_no & 0xff))

/* my_genid is always 0 in protos, non-zero in local clients */
#define GENMSGID            GEN_MSGID(my_genid)
#define GENBCASTID          GEN_BCASTID(my_genid)

 
#define LOCALFLAG           0x80000000
 
#endif
