/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 ******************************************************
 *        General purpose memory allocator/deallocator
 *        In PARANOID mode will check vaguely for errors
 ******************************************************
 */

# include "pr.h"
# define  PARANOID

#ifdef PARANOID
# define  ASIZE(n)  (n + 2*sizeof(int))
#else PARANOID
# define  ASIZE(n)  (n)
#endif PARANOID

long    INUSE[]
={
        0x00000000,
        /* I'th entry has bits 0..I-1 cleared */
        ~0x00000001, ~0x00000003, ~0x00000007, ~0x0000000F,
        ~0x0000001F, ~0x0000003F, ~0x0000007F, ~0x000000FF,
        ~0x000001FF, ~0x000003FF, ~0x000007FF, ~0x00000FFF,
        ~0x00001FFF, ~0x00003FFF, ~0x00007FFF, ~0x0000FFFF,
        ~0x0001FFFF, ~0x0003FFFF, ~0x0007FFFF, ~0x000FFFFF,
        ~0x001FFFFF, ~0x003FFFFF, ~0x007FFFFF, ~0x00FFFFFF,
        ~0x01FFFFFF, ~0x03FFFFFF, ~0x07FFFFFF, ~0x0FFFFFFF,
        ~0x1FFFFFFF, ~0x3FFFFFFF, ~0x7FFFFFFF, ~0xFFFFFFFF,
};

adesc   *alist[20], **alp = alist;

malloc_dump()
  {
        register adesc **app;
        register tot = 0;
        print("Memory management statistics:\n");
        for(app = alist; app != alp; app++)
        {
            register adesc *ap = *app;
            register nb;
            if(ap->a_nmalloc)
            {
                nb = ap->a_nmalloc*ASIZE(ap->a_isize)*ap->a_nalloc;
                print("  [%.5x] %d*%d/%d pending mallocs %d (%d bytes)\n", ap, ap->a_isize, ap->a_nalloc, ap->a_izero, ap->a_nmalloc, nb);
                tot += nb;
            }
        }
        print("... total bytes allocated %d\n", tot);
  }

char *
mallocate(ap)
  register adesc *ap;
  {
        register chunk *cp;
        register char *pt;
        if((ap->a_flags&A_INIT) == 0)
        {
            ap->a_isize = (ap->a_isize+3) & ~3;
            ap->a_flags |= A_INIT;
            *alp++ = ap;
        }
        if(cp = ap->a_notfull)
            ap->a_notfull = 0;
        else
        {
            cp = ap->a_chunks;
            while(cp && cp->c_inuse == -1)
                cp = cp->c_next;
        }
        if(cp)
        {
            register i, n;
            n = 1;
            i = cp->c_inuse;
            pt = cp->c_first;
            while(n & i)
            {
                n <<= 1;
                pt += ASIZE(ap->a_isize);
            }
            if((cp->c_inuse |= n) != -1)
                ap->a_notfull = cp;
        }
        else
        {
            register n = ASIZE(ap->a_isize) * ap->a_nalloc;
            cp = (chunk*)malloc(sizeof(chunk) + n);
            pt = (char*)(cp+1);
            ++ap->a_nmalloc;
            cp->c_first = pt;
            cp->c_last = pt+n;
            cp->c_inuse = INUSE[ap->a_nalloc] | 1;
            cp->c_next = ap->a_chunks;
            ap->a_chunks = cp;
            if(cp->c_inuse != -1)
                ap->a_notfull = cp;
        }
#ifdef  PARANOID
        pt = pt+sizeof(int);
        pt[-1] = (char)0xF1;
        pt[ap->a_isize] = (char)0x1F;
#endif
        if(ap->a_izero)
            bzero(pt, ap->a_izero);
        ++nalloc;
        memalloc += ap->a_isize;
        return(pt);
  }

/* Deallocate an instance of the designated item */
mdeallocate(pt, ap)
  register adesc *ap;
  register char *pt;
  {
        register chunk *cp, *ocp = 0;
#ifdef  PARANOID
        mcheck(pt, ap, "mdeallocate");
        pt[-1] = (char)0xF2;
        pt -= sizeof(int);
#endif  PARANOID
        for(cp = ap->a_chunks; cp; cp = cp->c_next)
            if(cp->c_first <= pt && cp->c_last > pt)
            {
                register n = ASIZE(ap->a_isize);
                /* optimization to avoid subr. call on divide */
                if(n < 32768)
                    n = 1<<(pt-cp->c_first)/(short)n;
                else
                    n = 1<<(pt-cp->c_first)/n;
                if((cp->c_inuse &= ~n) == INUSE[ap->a_nalloc] && ocp)
                {
                    ocp->c_next = cp->c_next;
                    free(cp);
                    --ap->a_nmalloc;
                    if(cp == ap->a_notfull)
                    {
                        if(ocp->c_inuse != -1)
                            ap->a_notfull = ocp;
                        else
                            ap->a_notfull = 0;
                    }
                }
                break;
            }
            else
                ocp = cp;
        ++nfree;
        memfree += ap->a_isize;
  }

#ifdef  PARANOID
mcheck(pt, ap, where)
  register char *pt;
  adesc *ap;
  char *where;
  {
        if(pt[-1] == (char)0xF2)
            panic("Deallocated the same thing twice <%s>: pt %x ap %x", where, pt, ap);
        if(pt[-1] != (char)0xF1)
            panic("MEMORY SMASH: <%s> front of pt %x ap %x", where, pt, ap);
        if(pt[ap->a_isize] != (char)0x1F)
            panic("MEMORY SMASH: <%s> overran pt %x ap %x", where, pt, ap);
  }
#endif  PARANOID
