/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Routines providing addressing support of various kinds
 *      Macros are used to avoid having lots of nearly identical code
 *
 *      SENDMSG loops if an iterated delivery fails and must be retried
 *      The address expansion routines return a negative count in cases
 *      where iterated delivery must be done.
 */

#include "pr.h"

sys_groupview  *view_get(), *cache_get();

#define         AD_GBGROW       0x1
#define         AD_GBCAST       0x2
#define         AD_ITER         0x4

#define         DIRECT          0
#define         INDIRECT        1
#define         STARTEV         2
#define         ENDEV           3

int     pr_fbcast(), pr_cbcast(), pr_abcast(), pr_gbcast(), pr_bcast();
int     direct_cbcast(), direct_fbcast(), direct_abcast(), direct_gbcast(), direct_bcast();
int     collect_answ();

/* Routines to use in normal (direct) and iterated (indirect) deliveries */
int     (*using_cbcast[])() ={ direct_cbcast, pr_cbcast, (ifunc*)S_CBSTART, (ifunc*)S_CBDONE };
int     (*using_fbcast[])() ={ direct_fbcast, pr_fbcast, (ifunc*)S_CBSTART, (ifunc*)S_CBDONE };
int     (*using_abcast[])() ={ direct_abcast, pr_abcast, (ifunc*)S_ABSTART, (ifunc*)S_ABDONE };
int     (*using_gbcast[])() ={ direct_gbcast, pr_gbcast, (ifunc*)S_GBSTART, (ifunc*)S_GBDONE };
int     (*using_bcast[])()  ={ direct_bcast, pr_bcast, (ifunc*)S_BBSTART, (ifunc*)S_BBDONE };

#define ITERATED        0x10000

DO_DIRECT(tp, routine)
  register task *tp;
  int (*routine)();
  {
        register status;
        status = (*routine)(tp->task_msg);
        t_sig(&tp->task_iwait, status);
  }

#define NONINTERATED(name,routine)                                      \
name(tp)                                                                \
  register task *tp;                                                    \
  {                                                                     \
        DO_DIRECT(tp, routine);                                         \
  }

/* Direct ones */
NONINTERATED(direct_cbcast,pr_cbcast)
NONINTERATED(direct_fbcast,pr_fbcast)
NONINTERATED(direct_abcast,pr_abcast)
NONINTERATED(direct_gbcast,pr_gbcast)
NONINTERATED(direct_bcast,pr_bcast)

/*
 * This code is quite tricky due to the handling of iterated deliveries.
 * The iterated delivery routine signals the sending task to tell it
 * if it can safely run or not.  Meanwhile, messages can pile up
 * for it, but this shouldn't pose any problems
 */
SENDMSG(msg, alist, ndests, routine, died, nwanted, collect, answ, alen)
  register ndests;
  register message *msg;
  address *alist;
  char *answ;
  char *died;
  register (*routine[])();
  int (*collect)();
  {
        int iflag;
        if(died)
            bzero(died, MAX_PROCS);
        if(ndests < 0)
            return(ndests);
        iflag = ndests & ITERATED;
        switch(ndests &= ~ITERATED)
        {
          case 0:
            return(0);

          case 1:
            if(routine == using_abcast)
                routine = using_fbcast;
        }
        if(routine == using_cbcast || routine == using_fbcast)
        {
            register bitvec *scope;
            register address *ap;
            register sno = 0;
            if((scope = (bitvec*)msg_getfield(msg, SYSFLD_SCOPE, 1, 0)) == (bitvec*)0)
            {
                static nullscope;
                scope = (bitvec*)msg_insertfield(msg, SYSFLD_SCOPE, &nullscope, FTYPE_BITVEC, sizeof(nullscope));
            }

            for(ap = alist; !addr_isnull(*ap); ap++)
            {
                if(ap->site != my_site_no)
                    if(sno && sno != ap->site)
                        sno = -1;
                    else
                        sno = ap->site;
                bis(*scope, ap->site);
            }

            /* Optimizations: to one remote site and/or my_site */
            switch(sno)
            {
              case 0:
                /* To my_site */
                bclr(*scope);
                bis(*scope, my_site_no);
                break;

              default:
                /* To one remote and/or my_site, no need to set my_site_no in this case(!) */
                bclr(*scope);
                bis(*scope, sno);
                break;

              case -1:
                /* Default, use costly algorithm */
                bis(*scope, my_site_no);
            }
        }
        EVENTV(S_FANOUT, ndests);
        msg_setreplyto(msg, my_address);
        if(iflag == 0)
        {
            int msgid = (CONJURE += 2);
            if(nwanted)
            {
                ++msgid;
                msg_replacefield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
            }
            msg_setdests(msg, alist);
            if(msg_tracemsgs)
            {
                int pno;
                if(routine == using_bcast) pno = PN_BCAST;
                else if(routine == using_cbcast) pno = PN_CBCAST;
                else if(routine == using_fbcast) pno = PN_FBCAST;
                else if(routine == using_abcast) pno = PN_ABCAST;
                else if(routine == using_gbcast) pno = PN_GBCAST;
                msg_replacefield(msg, SYSFLD_PROTO, (char*)&pno, FTYPE_LONG, sizeof(int));
            }
            ctp->task_msg = msg;
            ctp->task_msgid = msgid;
            EVENT((int)routine[STARTEV]);
            if(nwanted)
            {
                t_fork(routine[DIRECT], (char*)ctp, msg);
                if(t_wait(&ctp->task_iwait, "direct") == -1)
                {
                    EVENT((int)routine[ENDEV]);
                    return(IE_AGAIN);
                }
                ndests = collect_replies(msgid, alist, nwanted, collect, answ, alen, died);
            }
            else
            {
                /* Make a valiant effort to avoid blocking... */
                if((*routine[INDIRECT])(msg) == -1)
                {
                    EVENT((int)routine[ENDEV]);
                    return(IE_AGAIN);
                }
                ndests = 0;
            }
            EVENT((int)routine[ENDEV]);
        }
        else
        {
            int msgid = (CONJURE += 2);
            if(nwanted)
                ++msgid;
            msg_replacefield(msg, SYSFLD_MSGID, (char*)&msgid, FTYPE_LONG, sizeof(int));
            msg_setdests(msg, alist);
            if(msg_tracemsgs)
            {
                int pno;
                if(routine == using_bcast) pno = PN_IBCAST;
                else if(routine == using_cbcast) pno = PN_ICBCAST;
                else if(routine == using_fbcast) pno = PN_IFBCAST;
                else if(routine == using_abcast) pno = PN_IABCAST;
                else if(routine == using_gbcast) pno = PN_IGBCAST;
                msg_replacefield(msg, SYSFLD_PROTO, (char*)&pno, FTYPE_LONG, sizeof(int));
            }
            ctp->task_msg = msg;
            ctp->task_msgid = msgid;
            EVENT((int)routine[STARTEV]);
            t_fork_urgent(routine[INDIRECT], (char*)msg, msg);
            if(nwanted == 0)
                /* Must wait to know if it got through or not! */
                ++nwanted;
            ndests = collect_replies(msgid, alist, nwanted, collect, answ, alen, died);
            cache_refresh(msg, ndests);
            EVENT((int)routine[ENDEV]);
        }
        return(ndests);
  }

#define SEND_MSG(proc)       (n = SENDMSG(msg, alist, n, proc, died, nwanted, collect, answ, alen))

#define GENERIC(name, routine, fv)                                      \
name(aexpr, msg, nwanted, collect, answ, alen)                          \
  address *aexpr;                                                       \
  message *msg;                                                         \
  int (*collect)();                                                     \
  char *answ;                                                           \
  {                                                                     \
        register n = 0, firsttime = 0, is_a_copy = 0, f = fv;           \
        address sender, alist[ADDR_LEN];                                \
        char died[MAX_PROCS];                                           \
        sender = msg_getsender(msg);                                    \
        alist[0] = NULLADDRESS;                                         \
        do                                                              \
        {                                                               \
            if(firsttime++ && (f&AD_GBCAST))                            \
                EVENT (S_GBABORTS);                                     \
            if(n == IE_AGAIN)                                           \
            {                                                           \
                register message *cmsg = msg_copy(msg);                 \
                if(is_a_copy++)                                         \
                    msg_delete(msg);                                    \
                msg = cmsg;                                             \
            }                                                           \
            n = aexpr_expand(sender, aexpr, alist, msg, f);             \
            f |= AD_ITER;                                               \
        }                                                               \
        while(SEND_MSG(routine) == IE_AGAIN);                           \
        if(is_a_copy)                                                   \
            msg_delete(msg);                                            \
        pg_wait(sender, alist, died);                                   \
        return(n);                                                      \
  }

#define GENERIC_GROW(name, routine, fv)                                 \
name(aexpr, msg, nwanted, collect, answ, alen)                          \
  address *aexpr;                                                       \
  message *msg;                                                         \
  int (*collect)();                                                     \
  char *answ;                                                           \
  {                                                                     \
        register n = 0, firsttime = 0, is_a_copy = 0, f = fv;           \
        address sender, alist[ADDR_LEN];                                \
        char died[MAX_PROCS];                                           \
        sender = msg_getsender(msg);                                    \
        alist[0] = NULLADDRESS;                                         \
        do                                                              \
        {                                                               \
            if(firsttime++ && (f&AD_GBCAST))                            \
                EVENT (S_GBABORTS);                                     \
            if(n == IE_AGAIN)                                           \
            {                                                           \
                register message *cmsg = msg_copy(msg);                 \
                if(is_a_copy++)                                         \
                    msg_delete(msg);                                    \
                msg = cmsg;                                             \
            }                                                           \
            n = aexpr_expand(sender, aexpr, alist, msg, f|AD_GBGROW);     \
            f |= AD_ITER;                                               \
        }                                                               \
        while(SEND_MSG(routine) == IE_AGAIN);                           \
        if(is_a_copy)                                                   \
            msg_delete(msg);                                            \
        pg_wait(sender, alist, died);                                   \
        return(n);                                                      \
  }

#define GENERIC_EX(name, routine, fv)                                   \
name(aexpr, msg, nwanted, collect, answ, alen)                          \
  address *aexpr;                                                       \
  message *msg;                                                         \
  int (*collect)();                                                     \
  char *answ;                                                           \
  {                                                                     \
        register n = 0, firsttime = 0, is_a_copy = 0, f = fv;           \
        address sender, alist[ADDR_LEN];                                \
        char died[MAX_PROCS];                                           \
        sender = msg_getsender(msg);                                    \
        alist[0] = NULLADDRESS;                                         \
        do                                                              \
        {                                                               \
            if(firsttime++ && (f&AD_GBCAST))                            \
                EVENT (S_GBABORTS);                                     \
            if(n == IE_AGAIN)                                           \
            {                                                           \
                register message *cmsg = msg_copy(msg);                 \
                if(is_a_copy++)                                         \
                    msg_delete(msg);                                    \
                msg = cmsg;                                             \
            }                                                           \
            n = aexpr_expand_ex(sender, aexpr, alist, msg, f);          \
            f |= AD_ITER;                                               \
        }                                                               \
        while(SEND_MSG(routine) == IE_AGAIN);                           \
        if(is_a_copy)                                                   \
            msg_delete(msg);                                            \
        pg_wait(sender, alist, died);                                   \
        return(n);                                                      \
  }

#define GENERIC_V(name, routine)                                        \
name(v, pid, ent, msg, nwanted, collect, answ, alen)                    \
  sview *v;                                                             \
  message *msg;                                                         \
  int (*collect)();                                                     \
  char *answ;                                                           \
  {                                                                     \
        register n = 0, is_a_copy = 0;                                  \
        address alist[ADDR_LEN];                                        \
        static long *died;                                              \
                                                                        \
        do                                                              \
        {                                                               \
            n = v_expand(v, pid, ent, alist);                           \
            if(n == IE_AGAIN)                                           \
            {                                                           \
                register message *cmsg = msg_copy(msg);                 \
                if(is_a_copy++)                                         \
                    msg_delete(msg);                                    \
                msg = cmsg;                                             \
            }                                                           \
        }                                                               \
        while(SEND_MSG(routine) == IE_AGAIN);                           \
        if(is_a_copy)                                                   \
            msg_delete(msg);                                            \
        return(n);                                                      \
  }

/*****************************************************************************/
                GENERIC (GBCAST, using_gbcast, AD_GBCAST)
                GENERIC (ABCAST, using_abcast, 0)
                GENERIC (CBCAST, using_cbcast, 0)
                GENERIC (FBCAST, using_fbcast, 0)
                GENERIC (BCAST, using_bcast, 0)
                GENERIC_EX (GBCAST_EX, using_gbcast, AD_GBCAST)
                GENERIC_EX (ABCAST_EX, using_abcast, 0)
                GENERIC_EX (CBCAST_EX, using_cbcast, 0)
                GENERIC_EX (FBCAST_EX, using_fbcast, 0)
                GENERIC_EX (BCAST_EX, using_bcast, 0)
                GENERIC_V (GBCAST_V, using_gbcast)
                GENERIC_V (ABCAST_V, using_abcast)
                GENERIC_V (CBCAST_V, using_cbcast)
                GENERIC_V (BCAST_V, using_bcast)
                GENERIC_GROW (GBCAST_GROW, using_gbcast, AD_GBCAST)
/*****************************************************************************/

/* Special for Tommy */
BCAST_SL(slist, pid, ent, msg, nwanted, collect, answ, alen)       
  site_id *slist;
  message *msg;
  char *answ;
  int (*collect)();
  {
        address alist[ADDR_LEN];
        register cnt = 0;
        register address *ap;
        register site_id *sp;

        ap = alist;
        for(sp = slist; *sp; sp++)
            *ap++ = ADDRESS(SITE_NO(*sp), SITE_INCARN(*sp), pid, ent);
        *ap = NULLADDRESS;
        cnt = ap-alist;
        cnt = SENDMSG(msg, alist, cnt, using_bcast, (char*)0, nwanted, collect, answ, alen);
        return(cnt);
  }

/* Expand an address expression, exclude sender from result */
aexpr_expand_ex(sender, aexpr, alist, msg, f)
  address sender, *aexpr;
  register address *alist;
  message *msg;
  {
        register n, iflag;
        register a, b;
        int      *msg_idp;

        n = aexpr_expand(sender, aexpr, alist, msg, f);
        if(n <= 0 || sender.site == 0)
            return(n);
        a = n & ITERATED;
        n &= ~ITERATED;
        for(b = 0; b < n; b++)
            if(addr_cmp(alist[b], sender) != 0)
                alist[a++] = alist[b];
        alist[a] = NULLADDRESS;
        if(a == 0 && pg_readsview(msg))
        {
            if ((msg_idp = (int*)msg_getfield(msg, SYSFLD_PROTID, 1, (int*)0)) == 0)
                panic("aexpr_expand_ex: no msg_id");
            shr_gunlock(*msg_idp, sender.process);
            msg_deletefield(msg, SYSFLD_VREAD, 1);
        }
        return(a);
  }

#define add_ent(ap, bp, e)                                      \
  {                                                             \
        if(ap == &alist[ADDR_LEN-1])                            \
        {                                                       \
            ap = &alist[dl_compact(alist, ap-alist)];           \
            if(ap == &alist[ADDR_LEN-1])                        \
                return(IE_TOOLONG);                             \
        }                                                       \
        *ap = *bp;                                              \
        ap->entry = e;                                          \
        ++ap;                                                   \
  }

aexpr_expand(sender, aexpr, alist, msg, flag)
  address sender, *aexpr, *alist;
  message *msg;
  {
        register address *ep, *ap = alist;
        register queue *cl_root = 0, *cp;
        register sys_groupview *pg;
        int agcount = 0, used_cache = 0, used_view = 0, n, msg_id;
        
        if(aexpr->site == 0)
        {
            /* Special case -- a null list */
            alist[0] = NULLADDRESS;
            return(0);
        }
        /* Otherwise, always get the lock, but unlock it if we didn't use the view */
        begin
        {
            register *msg_idp;
            if((flag&AD_ITER) || (msg_idp = (int*)msg_getfield(msg, SYSFLD_PROTID, 1, (int*)0)) == 0)
            {
                msg_id = GENMSGID;
                msg_replacefield(msg, SYSFLD_PROTID, (char*)&msg_id, FTYPE_LONG, sizeof(int));
            }
            else
                msg_id = *msg_idp;
        }
        shr_glock(msg_id, sender.process);
        msg_deleteall(msg, SYSFLD_VERIFY);
        sender.entry = 0;
        for(ep = aexpr; !addr_isnull(*ep); ep++)
        {
            if(used_cache)
                goto restrict;
            if(ep->type == ISAGID)
            {
                if(cl_root == 0 && (cl_root = pg_find(pg_root, sender)) == 0)
                    ++used_cache;
                else if(pg = view_get(cl_root->qu_queue, *ep))
                {
                    register address *mp;
                    ++used_view;
                    for(mp = pg->pg_alist; !addr_isnull(*mp); mp++)
                        add_ent(ap, mp, ep->entry);
                    if(pg_changesview(msg))
                        for(++mp; !addr_isnull(*mp); mp++)
                            add_ent(ap, mp, ep->entry);
                    if(flag&AD_GBGROW)
                    {
                        if(agcount++)
                            goto toolong;
                        /* Piggyback current sys_groupview view */
                        msg_replacefield(msg, SYSFLD_PGVIEW, (char*)pg, FTYPE_PGROUP, pglength(pg));
                    }
                    if(flag&AD_GBCAST)
                    {
                        verify vi;
                        vi.vi_gid = *ep;
                        vi.vi_viewid = pg->pg_viewid;
                        bclr(vi.vi_sites);
                        for(mp = pg->pg_alist; !addr_isnull(*mp); mp++)
                            bis(vi.vi_sites, mp->site);
                        msg_insertfield(msg, SYSFLD_VERIFY, (char*)&vi, FTYPE_VERIFY, sizeof(vi));
                    }
                }
                else
                    ++used_cache;
            }
            else
                /* Unrestricted address */
                add_ent(ap, ep, ep->entry);
        }
        if(used_cache)
        {
            register address *mp;
            if((flag&AD_GBGROW) || ap != alist)
                goto restrict;
            if((pg = cache_get(sender, *aexpr, msg)) == 0)
            {
                shr_gunlock(msg_id, sender.process);
                return(IE_UNKNOWN);
            }
            for(mp = pg->pg_alist; !addr_isnull(*mp); mp++)
                add_ent(ap, mp, aexpr->entry);
            if((pg->pg_flag&PG_CACHED) == 0)
            {
                ++used_view;
                used_cache = 0;
            }
        }
        *ap = NULLADDRESS;
        n = dl_compact(alist, ap-alist);

        if(used_cache)
        {
            if(pg_changesview(msg))
            {
                --pg->pg_ccount;
                goto restrict;
            }
            shr_gunlock(msg_id, sender.process);
            msg_deletefield(msg, SYSFLD_VREAD, 1);
            return(n|ITERATED);
        }
        if(flag&AD_GBCAST)
        {
            shr_gunlock(msg_id, sender.process);
            msg_deletefield(msg, SYSFLD_VREAD, 1);
        }
        else if(used_view)
        {
            msg_deletefield(msg, SYSFLD_VREAD, 1);
            shr_gunlock(msg_id, sender.process);
        }
        else if(msg_getfield(msg, SYSFLD_VREAD, 1, 0) == 0)
            msg_insertfield(msg, SYSFLD_VREAD, (char*)0, FTYPE_CHAR, 0);
        return(n);

  restrict:
        /* Error cases: always unlock the process */
        shr_gunlock(msg_id, sender.process);
        return(IE_RESTRICTED);

  toolong:
        shr_gunlock(msg_id, sender.process);
        return(IE_TOOLONG);
  }

pg_isgrow(mp)
  register message *mp;
  {
        return(msg_getfield(mp, SYSFLD_PGVIEW, 1, (int*)0) != 0);
  }

pg_changesview(mp)
  register message *mp;
  {
        return(msg_getfield(mp, SYSFLD_VCHANGE, 1, (int*)0) != 0);
  }

pg_readsview(mp)
  register message *mp;
  {
        return(msg_getfield(mp, SYSFLD_VREAD, 1, (int*)0) != 0);
  }

v_expand(v, pid, ent, alist)
  sview *v;
  address *alist;
  {
        register address *ap = alist;
        register site_id *sp;
        register n;

        for(sp = v->sv_slist; *sp; sp++)
        {
            if(ap == &alist[ADDR_LEN])
                return(IE_TOOLONG);
            *ap++ = ADDRESS(SITE_NO(*sp), SITE_INCARN(*sp), pid, ent);
        }
        *ap = NULLADDRESS;
        n = dl_compact(alist, ap-alist);
        return(n);
  }

/*****************************************************************************/
/*            Compaction routine, other useful stuff                         */
/*****************************************************************************/

cmp_addr(a0, a1)
  register address *a0, *a1;
  {
        return(addr_cmp(*a0, *a1));
  }

dl_compact(alist, dl)
  register address *alist;
  {
        register address *ap, *aap;

        if(dl <= 1)
            return(dl);
        qsort((char*)alist, dl, sizeof(address), cmp_addr);
        aap = alist;
        for(ap = &alist[1]; !addr_isnull(*ap); ap++)
            if(addr_cmp(*ap, *aap))
                *++aap = *ap;
        *++aap = NULLADDRESS;
        return(aap-alist);
  }

address
ADDRESS(s, i, p, e)
  site_id s;
  {
        address d;
        d.type = ISAPID;
        d.site = s;
        d.incarn = i;
        d.process = p;
        d.entry = e;
        d.cluster = 0;
        d.portno = 0;
        return(d);
  }

addr_cmp(a, b)
  address a, b;
  {
        if(a.site != b.site)
            return(a.site-b.site);
        if(a.type != b.type)
            return(a.type - b.type);
        if(a.type == ISAGID)
        {
            if(a.groupid != b.groupid)
                return(a.groupid-b.groupid);
        }
        else
            if(a.process != b.process)
                return(a.process-b.process);
        if(a.incarn != b.incarn)
            return(a.incarn-b.incarn);
        if(a.entry == 0 || b.entry == 0)
            return(0);
        return(a.entry-b.entry);
  }

cmp_sid(s1, s2)
  register site_id *s1, *s2;
  {
        return(*s1 - *s2);
  }

msg_deleteall(msg, fn)
  register message *msg;
  {
        char *fptrs[64];
        register n = 0, nf;

        nf = msg_getfields(msg, fn, fptrs, (int*)0, 64);
        while(nf--)
            msg_deletefield(msg, fn, ++n);
  }
