/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#ifndef MAXBITS
# define        MAXBITS         128
#endif

typedef struct bitvec   bitvec;

#define BS      32
#define BO      31
#define BVL     ((MAXBITS+BS-1)/BS)

struct  bitvec
{
        long    bv_data[BVL];
};

bitvec  NULLBITVEC;

#if     (MAXBITS>32)

#  define bis(vec,b)      ((vec).bv_data[(b)/BS] |= 1<<((b) & BO))
#  define bic(vec,b)      ((vec).bv_data[(b)/BS] &= ~(1<<((b) & BO)))
#  define bit(vec,b)      ((vec).bv_data[(b)/BS] & (1<<((b) & BO)))
#  define bisv(vec,bv)    {                                             \
        register _n;                                                    \
        for(_n = 0; _n < BVL; _n++)                                     \
            (vec).bv_data[_n] |= (bv).bv_data[_n];                      \
}
#  define bandv(vec,bv)   {                                             \
        register _n;                                                    \
        for(_n = 0; _n < BVL; _n++)                                     \
            (vec).bv_data[_n] &= (bv).bv_data[_n];                      \
}
#  define bicv(vec,bv)    {                                             \
        register _n;                                                    \
        for(_n = 0; _n < BVL; _n++)                                     \
            (vec).bv_data[_n] &= ~(bv).bv_data[_n];                     \
}
#  define btst(vec)       _btst(vec)
#  define bitv(vec,bv)    _bitv(vec,bv)
#  define bclr(vec)       { bzero((char*)&vec,sizeof(vec)); }
#  define bset(vec)       bisv(vec,ones)

#else

#  define bis(vec,b)      { (vec).bv_data[0] |= 1<<(b); }
#  define bic(vec,b)      { (vec).bv_data[0] &= ~(1<<(b)); }
#  define bit(vec,b)      ( (vec).bv_data[0] & (1<<(b)) )
#  define bisv(vec,bv)    { (vec).bv_data[0] |= (bv).bv_data[0]; }
#  define bandv(vec,bv)   { (vec).bv_data[0] &= (bv).bv_data[0]; }
#  define bicv(vec,bv)    { (vec).bv_data[0] &= ~(bv).bv_data[0]; }
#  define bitv(vec,bv)    ( (vec).bv_data[0] & (bv).bv_data[0] )
#  define bclr(vec)       { bzero((char*)&vec,sizeof(vec)); }
#  define btst(vec)       ( (vec).bv_data[0] )
#  define bclr(vec)       { bzero((char*)&vec,sizeof(vec)); }
#  define bset(vec)       bisv(vec,ones)

#endif


