/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include    "isis.h"
#define     begin

queue       *msg_traceq;

/* msg_setdest :  Set the destination field to the given destination    */
address *
msg_setdest (msg, dest)
  register message  *msg;
  address           dest;

{
    address     alist[2];

    alist[0] = dest;
    bzero ((char *) &alist[1], sizeof (*alist));
    return((address*)msg_replacefield (msg, SYSFLD_DESTS, (char *) alist, FTYPE_ADDRESS,
                                                             sizeof (alist)));
}



/* msg_setdests :  Set the destination field to the given null-terminated */
/*                 list of destinations                                   */
address *
msg_setdests (msg, alist)
  register message  *msg;
  register address  *alist;

{
    register address    *dst;

    for (dst = alist; !addr_isnull(*dst); dst++)
        continue;
    return((address*)msg_replacefield (msg, SYSFLD_DESTS, (char *) alist, FTYPE_ADDRESS,
                                (int) ((char *) (++dst) - (char *) alist)));
}



/* msg_getdests: Return a pointer to a null-terminated list of the       */
/*               destinations of a given message (null pointer, if none) */

address *
msg_getdests (msg)
  register message  *msg;

{
    return ((address *) msg_getfield (msg, SYSFLD_DESTS, 1, (int*)0));
}



/* msg_getreplyto:  Get the address to send a reply to.  If SYSFLD_REPLYTO */
/*                  exists, this is the address, else it's the sender      */

address
msg_getreplyto (msg)
  register message  *msg;

{
    register address    *rep;

    if (rep = (address *) msg_getfield (msg, SYSFLD_REPLYTO, 1, (int *) 0))
        return (*rep);
    return (msg_getsender(msg));
}


/* msg_getsender:    Get the original sender of a message                   */
address
msg_getsender (msg)
  register message *msg;

{
    register address *fp;

    if(fp = (address*)msg_getfield(msg, SYSFLD_FORWARD, 1, (int*)0))
        return(fp[FWI_SENDER]);
    return(*(address*)msg_getfield(msg, SYSFLD_SENDER, 1, (int*)0));
}


/* msg_gettruesender:    Get the most recent sender of a message            */
address
msg_gettruesender (msg)
  register message *msg;

{
    return(*(address*)msg_getfield(msg, SYSFLD_SENDER, 1, (int*)0));
}


/* msg_increfcount : Increment the reference count of a given message */

msg_increfcount (msg)
  register message  *msg;

{
    register int        i;
    register block_desc **blk_descpp;

    if (msg_tracecaller)
        msg_callertrace ("inc", msg, callername (1));
    msg->iov_desc->refcount++;
    msg->body_info->refcount++;
    for (blk_descpp = (block_desc **) msg->body_info->addr, i = 0;
                                          i < msg->iovcnt; blk_descpp++, i++)
        (*blk_descpp)->refcount++;
    msg->avail_desc->refcount++;
    msg->access_desc->refcount++;
    msg->ftab_desc->refcount++;
}



msg_ismsg (msg)
  message   *msg;

{
    register int    i, len;

    if(msg == (message*)0)
        return(FALSE);
    len = msg_getlen (msg);
    for (i = 0; i < msg->iovcnt && len >= 0; i++)
        len -= ((struct iovec *) msg->iov_desc->addr)[i].iov_len;
    if (len != 0)
        return (FALSE);
    return (TRUE);
}



msg_makelazy (msg, howlazy)
  register message  *msg;
  int               howlazy;

{
    msg_replacefield (msg, SYSFLD_LAZY, &howlazy, FTYPE_LONG, sizeof(howlazy));
}




/* msg_gettype : Return the type of the given instance of a field  */

msg_gettype (msg, field, inst)
  register message  *msg;
  u_char            field;
  int               inst;

{
    register field_desc     *f_desc;
    register int            i;
    register header         *hdr;

    if (field == 0 || field == SYSFLD_DELETED)
    {
        printf ("msg_gettype: invalid field name %d\n", field);
        fflush (stdout);
        return (0);
    }

    hdr = (header *) msg_getiovec(msg)->iov_base;
    for (f_desc = hdr->fld_desc, i = 0; i < hdr->n_fields; f_desc++, i++)
        if (f_desc->name == field)
            if (--inst == 0)
                break;
    if (inst)
        return (0);
    if (f_desc->type == FTYPE_BROKENMSG)
        return (FTYPE_MESSAGE);
    return (f_desc->type);
}



/* msg_printaccess  : Print out access strucutre of given messsage */

msg_printaccess (msg)
 register message   *msg;

{
    register int        i;
    register ftab_entry *entry;

    printf ("Access structure for message %x:\n", msg);
    printf ("   iovcnt = %d\n", msg->iovcnt);
    begin
    {
        register struct iovec   *iovarray;

        printf ("   iov_desc = ");
        msg_printblkdesc (msg->iov_desc);
        printf ("\n   iovarray =");
        iovarray = (struct iovec *) msg->iov_desc->addr;
        for (i = 0; i < msg->iovcnt; i++)
        {
            if (i && (i % 6 == 0))
                printf ("\n             ");
            printf (" %x/%d", iovarray[i].iov_base, iovarray[i].iov_len);
        }
    }
    begin
    {
        register block_desc **b_descp;

        printf ("\n   body_info = ");
        msg_printblkdesc (msg->body_info);
        printf ("\n   body_descs =");
        b_descp = (block_desc **) msg->body_info->addr;
        for (i = 0; i < msg->iovcnt; i++)
        {
            if (i && (i % 2 == 0))
                printf ("\n               ");
            printf (" ");
            msg_printblkdesc (b_descp[i]);
        }
    }
    begin
    {
        register long   *availp;

        printf ("\n   avail_desc = ");
        msg_printblkdesc (msg->avail_desc);
        printf ("\n   avail =");
        availp = (long *) msg->avail_desc->addr;
        for (i = 0; i < msg->iovcnt; i++)
            printf (" %d", availp[i]);
    }
    printf ("\n   access_desc = ");
    msg_printblkdesc (msg->access_desc);
    printf ("\n   ftab_size = %d", msg->ftab_size);
    printf ("\n   ftab_desc = ");
    msg_printblkdesc (msg->ftab_desc);
    printf ("\n   field_table =");
    for (i = 0; i < msg->ftab_size; i++)
    {
        if (i && (i % 3 == 0))
            printf ("\n                ");
        entry = &(((ftab_entry *) msg->ftab_desc->addr)[i]);
        printf (" %d/%s/%d/%d/%x", entry->name, (entry->flag == FLAG_MSG ?
              "message" : (entry->flag == FLAG_BROKENMSG ? "bmsg" :
                   (entry->flag == FLAG_DATA ? "data" : "???"))),
                       entry->block_index, entry->len, entry->start);
    }
    printf ("\n");
}



/* msg_printheader  : Print out the header of the given message */

msg_printheader (msg)
  register message  *msg;

{
    register int        i;
    register header     *hdr;
    register field_desc *desc;

    printf ("Header for message %x:\n", msg);

    hdr = (header *) ((struct iovec *) msg->iov_desc->addr)->iov_base;
    printf ("   len = %d\n", ntohl (hdr->len));
    printf ("   n_fields = %d\n", hdr->n_fields);
    printf ("   fld_desc =");
    for (i = 0; i < hdr->n_fields; i++)
    {
        if (i && (i % 3 == 0))
            printf ("\n             ");
        desc = &(hdr->fld_desc[i]);
        printf (" %d/%s/%x/%x/%d", desc->name, msg_typename (desc->type),
                                   desc->shortcode, desc->longcode, desc->len);
    }
    printf ("\n");
}




/* msg_printfield  : Print the given instance of a field */

msg_printfield (msg, field, inst)
  register message  *msg;
  u_char            field;
  int               inst;

{
    int                 len, type;
    register int        i;
    register char       *fp;

    if (fp = msg_getfield (msg, field, inst, &len))
    {
        type = msg_gettype (msg, field, inst);
        printf ("Message %x, field %d[%d] (start:%x len:%d type:%s):", msg,
                                   field, inst, fp, len, msg_typename (type));
        switch (type)
        {
          case FTYPE_SHORT:
            begin
            {
                register short  *sp;

                sp = (short *) fp;
                for (i = 0; i < len; i += 2, sp++)
                {
                    if (i % 16 == 0)
                        printf ("\n");
                    printf ("%8d", *sp);
                }
            }
            break;

          case FTYPE_LONG:
            begin
            {
                register long   *lp;

                lp = (long *) fp;
                for (i = 0; i < len; i += 4, lp++)
                {
                    if (i % 32 == 0)
                        printf ("\n");
                    printf ("%8d", *lp);
                }
            }
            break;

          case FTYPE_ADDRESS:
            begin
            {
                register address    *ap;

                ap = (address *) fp;
                for (i = 0; i < len; i += sizeof (address), ap++)
                {
                    if (i % (3 * sizeof (address)) == 0)
                        printf ("\n   ");
                    else
                        printf (" ");
                    paddr (ap);
                }
            }
            break;

          case FTYPE_MESSAGE:
            begin
            {
                register message   *mp;

                mp = msg_getmsg (msg, field, inst);
                printf ("\n");
                pmsg (mp);
                msg_printheader (mp);
                msg_delete (mp);
                break;
            }

          default:
            for (i = 0; i < len; i++, fp++)
            {
                if (i % 16 == 0)
                    printf ("\n");
                printf ("%3x", *fp);
            }
            break;
        }
        printf ("\n");
    }
    else
        printf ("Message %x, field %d[%d] not found\n", msg, field, inst);
}



msg_recordmsgalloc (msg)
  register message  *msg;

{
    register int    i, slot = MSG_TRACESIZE;

    for(i = 0; i < MSG_TRACESIZE; i++)
    {
        if (slot == MSG_TRACESIZE && alloc_msg[i] == 0)
            slot = i;
        if (alloc_msg[i] == msg)
        {
            printf ("msg_recordmsgalloc: message %x already allocated!\n",
                                                                         msg);
            fflush (stdout);
            return;
        }
    }
    if(slot == MSG_TRACESIZE)
    {
        printf ("msg_recordmsgalloc: alloc_msg overflow.  %s\n",
                                                "Turning off message trace.");
        fflush (stdout);
        msg_tracemsgs = FALSE;
        return;
    }
    alloc_msg[slot] = msg;
}


msg_recordmsgfree (msg)
  register message  *msg;

{
    register int    i;
    register queue  *qp;

    for(i = 0; alloc_msg[i] != msg && i < MSG_TRACESIZE; i++)
        continue;
    if (i == MSG_TRACESIZE)
    {
        printf ("msg_recordmsgfree: message %x not allocated!\n", msg);
        fflush (stdout);
    }
    else
    {
        alloc_msg[i] = (message *) 0;
        if (msg_tracecaller)
            if ((qp = qu_find (msg_traceq, (int) msg)) == 0)
            {
                printf ("msg_recordmsgfree: message %x not on msg_traceq\n",
                                                                         msg);
                fflush (stdout);
            }
            else
                qu_free (qp);
    }
}


msg_dumpmsgs (level)
  int   level;

{
    register int    i;
    register queue  *qp, *qqp;

    if(msg_tracemsgs)
        print("Allocated messages:\n");
    for (i = 0; i < MSG_TRACESIZE; i++)
        if (alloc_msg[i])
        {
            pmsg(alloc_msg[i]);
            if (msg_tracecaller)
                if (qp = qu_find (msg_traceq, (int) alloc_msg[i]))
                {
                    qp = qp->qu_queue;
                    for (qqp = qp->qu_next; qqp != qp; qqp = qqp->qu_next)
                        print (" %s:%x", (char *) qqp->qu_name, qqp->qu_data);
                    print ("\n");
                }
            if (level & MSG_DUMPACCESS)
                msg_printaccess (alloc_msg[i]);
            if (level & MSG_DUMPHEADER)
                msg_printheader (alloc_msg[i]);
        }
}


msg_dumpblocks()

{
    register int    i;

    if(msg_usagestats)
        print("Blocks of active message memory:");
    for(i = 0; i < MSG_TRACESIZE; i++)
            if(alloc_blk[i])
            {
                print("\n   ");
                msg_printblkdesc (alloc_blk[i]);
            }
        print("\n");
}
    

msg_msgcheck (msg)
  message   *msg;

{
    register ftab_entry     *ft_ent;
    register struct iovec   *vector;
    register block_desc     *blk_desc, **blk_descpp;
    register int            i, pass;
    register char           *end;
    static message          *check_msg;

    if (msg == check_msg)
        return;
    check_msg = msg;
    pass = TRUE;
    if (msg->iov_desc->refcount < msg->access_desc->refcount)
        pass = FALSE;
    for (blk_descpp = (block_desc **) msg->body_info->addr, i = 0;
                                 pass && i < msg->iovcnt; i++, blk_descpp++)
            if ((*blk_descpp)->refcount < msg->access_desc->refcount)
                pass = FALSE;
    if (msg->body_info->refcount < msg->access_desc->refcount)
        pass = FALSE;
    if (msg->avail_desc->refcount < msg->access_desc->refcount)
        pass = FALSE;
    if (msg->ftab_desc->refcount < msg->access_desc->refcount)
        pass = FALSE;
    for (ft_ent = (ftab_entry *) msg->ftab_desc->addr;
                                              pass && ft_ent->name; ft_ent++)
    {
        vector = &((struct iovec *) msg->iov_desc->addr)[ft_ent->block_index];
        blk_desc = ((block_desc **) msg->body_info->addr)[ft_ent->block_index];
        
        if (ft_ent->start < vector->iov_base || ft_ent->start < blk_desc->addr)
            pass = FALSE;
        if (ft_ent->flag != FLAG_BROKENMSG)
            end = ft_ent->start + PADDED_LEN (ft_ent->len);
        else
            end = 0;
        if (end && (end > vector->iov_base + vector->iov_len ||
                                         end > blk_desc->addr + blk_desc->len))
            pass = FALSE;
    }
    if (pass && ft_ent - (ftab_entry *) msg->ftab_desc->addr != msg->ftab_size)
        pass = FALSE;
    if (!pass)
    {
        print ("Inconsistency: ");
        msg_printaccess (msg);
        pmsg (msg);
        print ("callertrace: %x %x %x %x %x\n", callername (1), callername (2),
                               callername (3), callername (4), callername (5));
        panic ("Inconsistency in message %x", msg);
    }
}


msg_callertrace (routine, msg, caller)
  char      *routine;
  message   *msg;
  char      *caller;

{
    register queue  *qp;

    if (!msg_tracecaller)
        return;
    if (!msg_traceq)
        msg_traceq = qu_null();
    if ((qp = qu_find (msg_traceq, (int) msg)) == 0)
    {
        qp = qu_null ();
        qu_add_qu (msg_traceq, (int) msg, qp);
    }
    else
        qp = qp->qu_queue;
    qu_add (qp, (int) routine, caller, NULLROUTINE);
}
