/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#define     ISIS_SYS
#include    "isis.h"

u_short     msg_shortmask = 0x1;
u_long      msg_longmask  = 0x10203;
char        msg_shortkey[2];
char        msg_longkey[4];
#define     MSG_KEY(i,x)        (((u_char) ((x) & (0x3 << (6 - 2 * (i))))) >> \
                                                                 (6 - 2 * (i)))

typedef     struct msg_tdesc    msg_tdesc;
struct msg_tdesc
{
    u_char  type;
    u_short size;
    int     (*converter)();
    char    *name;
};

extern      msg_tdesc   msg_typetable[];
#define     MSG_MAXTYPES    15


msg_convertfield (start, f_desc)
  register char         *start;
  register field_desc   *f_desc;

{
    register msg_tdesc  *t_desc;
    char                *end;

    if (f_desc->type == FTYPE_CHAR || (f_desc->shortcode == MSG_SHORTCODE &&
                                           f_desc->longcode == MSG_LONGCODE))
        return;

    for (t_desc = msg_typetable; t_desc->type && t_desc->type != f_desc->type;
                                                                      t_desc++)
        continue;
    if (t_desc->type == 0)
    {
        print ("msg_convertfield: Warning! Unknown type %d\n", f_desc->type);
        return;
    }

    if (t_desc->converter == 0)
        return;

    msg_makekey (f_desc->shortcode, f_desc->longcode);

    if (t_desc->size == 0) /* For FTYPE_PGROUP, which has variable size */
        (*(t_desc->converter))(start);
    else
        for (end = start + f_desc->len; start + t_desc->size <= end;
                                                        start += t_desc->size)
            (*(t_desc->converter))(start);

    f_desc->shortcode = MSG_SHORTCODE;
    f_desc->longcode = MSG_LONGCODE;
}
        
    

msg_makekey (shortcode, longcode)
  u_char    shortcode, longcode;

{
    register int    i, j;

    if (MSG_KEY (0, shortcode) == ((char *) (&msg_shortmask))[0])
    {
        msg_shortkey[0] = 0;
        msg_shortkey[1] = 1;
    }
    else
    {
        msg_shortkey[0] = 1;
        msg_shortkey[1] = 0;
    }
    for (i = 0; i < 4; i++)
        for (j = 0; j < 4; j++)
            if (MSG_KEY(i, longcode) == ((char *) &msg_longmask)[j])
                msg_longkey[i] = j;
}


msg_convertshort (shortp)
  register short    *shortp;

{
    short   temp;

    temp = *shortp;
    ((char *) shortp)[msg_shortkey[0]] = ((char *) &temp)[0];
    ((char *) shortp)[msg_shortkey[1]] = ((char *) &temp)[1];
}



msg_convertlong (longp)
  register long     *longp;

{
    long    temp;

    temp = *longp;
    ((char *) longp)[msg_longkey[0]] = ((char *) &temp)[0];
    ((char *) longp)[msg_longkey[1]] = ((char *) &temp)[1];
    ((char *) longp)[msg_longkey[2]] = ((char *) &temp)[2];
    ((char *) longp)[msg_longkey[3]] = ((char *) &temp)[3];
}



msg_convertaddress (addrp)
  register address  *addrp;

{
    msg_convertshort (&addrp->process);
    msg_convertshort (&addrp->portno);
}



msg_convertbitvec (bp)
  register bitvec    *bp;

{
    register int    i;

    for (i = 0; i < BVL; i++)
        msg_convertlong (&bp->bv_data[i]);
}



msg_convertpgroup (pg)
  register sys_groupview    *pg;

{
    register address    *ap;
    register int        n_addr;

    msg_convertlong (&pg->pg_viewid);
    msg_convertlong (&pg->pg_incarn);
    msg_convertaddress (&pg->pg_gid);
    msg_convertshort (&pg->pg_nmemb);
    msg_convertshort (&pg->pg_nclient);
    for (ap = pg->pg_alist, n_addr = 0;
                      !addr_isnull (*ap) && n_addr < PG_ALEN; ap++, n_addr++)
        msg_convertaddress (ap);
    ap++;
    n_addr++;
    while (!addr_isnull (*ap) && n_addr < PG_ALEN)
    {
        msg_convertaddress (ap++);
        n_addr++;
    }
    if (n_addr < PG_ALEN)
        msg_convertaddress (ap);
}


msg_convertverify (vi)
  register verify    *vi;

{
    msg_convertaddress (&vi->vi_gid);
    msg_convertlong (&vi->vi_viewid);
    msg_convertbitvec (&vi->vi_sites);
}



msg_convertgroupview (gv)
  register struct groupview    *gv;

{
    register address    *ap;
    register int        n_addr;

    msg_convertlong (&gv->gv_viewid);
    msg_convertlong (&gv->gv_incarn);
    msg_convertlong (&gv->gv_flag);
    msg_convertaddress (&gv->gv_gaddr);
    msg_convertshort (&gv->gv_nmemb);
    msg_convertshort (&gv->gv_nclient);
    for (ap = gv->gv_members, n_addr = 0;
                        !addr_isnull (*ap) && n_addr < PG_ALEN; ap++, n_addr++)
        msg_convertaddress (ap);
    for (ap = gv->gv_clients, n_addr = 0;
                        !addr_isnull (*ap) && n_addr < PG_ALEN; ap++, n_addr++)
        msg_convertaddress (ap);
    msg_convertaddress (&gv->gv_joined);
    msg_convertaddress (&gv->gv_departed);
}


msg_convertgldesc (gl)
  register gl_desc *gl;

{
    msg_convertlong (&gl->gl_viewid);
    msg_convertlong (&gl->gl_nmembers);
    msg_convertlong (&gl->gl_nclients);
    msg_convertbitvec (&gl->gl_sites);
    msg_convertaddress (&gl->gl_addr);
}


msg_convertevent (eid)
  register event_id *eid;
{
    msg_convertlong (&eid->e_msgid);
    msg_convertlong (&eid->e_op);
    msg_convertaddress (&eid->e_pname);
}

typedef struct intersite intersite;

#include    "pr_intersite.h"

msg_convertintersite (is)
  register intersite    *is;

{
    msg_convertshort (&is->is_from);
    msg_convertshort (&is->is_dest);
    msg_convertshort (&is->is_seqn);
    msg_convertshort (&is->is_aseqn);
    msg_convertshort (&is->is_viewid);
    msg_convertlong (&is->is_abits);
    msg_convertlong (&is->is_abprio);
}


msg_convertinterclient (ic)
  register interclient  *ic;

{
    msg_convertaddress (&ic->ic_from);
    msg_convertaddress (&ic->ic_dest);
    msg_convertshort (&ic->ic_seqn);
    msg_convertshort (&ic->ic_aseqn);
    msg_convertlong (&ic->ic_abits);
}


msg_convertheader (hdr)
  register header   *hdr;

{
    register field_desc *f_desc;
    register int        i;

    if (hdr->shortcode == MSG_SHORTCODE && hdr->longcode == MSG_LONGCODE)
        return;

    msg_makekey (hdr->shortcode, hdr->longcode);
    msg_convertshort (&hdr->n_fields);
    for (i = 0, f_desc = hdr->fld_desc; i < hdr->n_fields; i++, f_desc++)
        msg_convertlong (&f_desc->len);
    hdr->shortcode = MSG_SHORTCODE;
    hdr->longcode = MSG_LONGCODE;
}

        
    


msg_definetype (type, size, converter, string)
  u_char    type;
  int       size;
  int       (*converter)();
  char      *string;

{
    register msg_tdesc  *t_desc;
    char                *malloc();

    if (type == 0 || type > FTYPE_USERLIMIT)
    {
        printf ("msg_definetype: invalid type name %d\n", type);
        fflush (stdout);
        return;
    }

    for (t_desc = msg_typetable; t_desc->type; t_desc++)
        if (t_desc->type == type)
        {
            printf ("msg_definetype: attempt to redifine type %d\n");
            fflush (stdout);
            return;
        }

    if (t_desc == msg_typetable + MSG_MAXTYPES)
    {
        printf ("msg_definetype: too many types, type %d not defined\n",
                                                                       type);
        fflush (stdout);
        return;
    }

    t_desc->type = type;
    t_desc->size = size;
    t_desc->converter = converter;
    if (string == 0)
    {
        string = malloc (8);
        sprintf (string, "type%d", type);
    }
    t_desc->name = string;
    (++t_desc)->type = 0;
}


char *
msg_typename (type)
  register u_char   type;

{
    register msg_tdesc  *t_desc;

    if (type == FTYPE_MESSAGE)
        return ("message");
    if (type == FTYPE_BROKENMSG)
        return ("bmsg");

    for (t_desc = msg_typetable; t_desc->type && t_desc->type != type;
                                                                    t_desc++)
        continue;
    if (t_desc->type)
        return (t_desc->name);

    return ("unknown");
}


msg_tdesc   msg_typetable[MSG_MAXTYPES + 1] =
{   FTYPE_CHAR,     1,                  0,                      "char",
    FTYPE_SHORT,    2,                  msg_convertshort,       "short",
    FTYPE_LONG,     4,                  msg_convertlong,        "long",
    FTYPE_ADDRESS,  sizeof (address),   msg_convertaddress,     "address",
    FTYPE_SITEID,   2,                  msg_convertshort,       "siteid",
    FTYPE_PGROUP,   0,                  msg_convertpgroup,      "pgroup",
    FTYPE_VERIFY,   0,                  msg_convertverify,      "verify",
    FTYPE_INTERSITE, sizeof (intersite), msg_convertintersite,  "intersite",
    FTYPE_INTERCLIENT, sizeof (interclient), msg_convertinterclient,  "interclient",
    FTYPE_BITVEC,   4,                  msg_convertlong,        "bitvec",
    FTYPE_GROUPVIEW, sizeof (struct groupview),
                                        msg_convertgroupview,   "groupview",
    FTYPE_EVENT,    sizeof (event_id),  msg_convertevent,       "event_id",
    FTYPE_GLDESC,   sizeof (gl_desc),   msg_convertgldesc,      "gldesc",
    0
};
