/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include    "msg.h"
/* msg_newmsg: Create an empty new message */

message *
msg_newmsg ()

{
    register message        *msg;
    register header         *hdr;
    register struct iovec   *vector;
    register long           len;
    register block_desc     *acc_desc, *hdr_desc;

    acc_desc =  msg_accessalloc();
    msg = (message *) acc_desc->addr;
    if (msg_tracecaller)
        msg_callertrace ("new", msg, callername (1));
    hdr_desc = msg_blockalloc (sizeof (header));
    hdr_desc->type = BLK_HEADER;
    hdr = (header *) hdr_desc->addr;

    /* initialize message header */
    len = (char *) hdr->fld_desc - (char *) hdr;
    hdr->len = htonl (len);
    hdr->shortcode = MSG_SHORTCODE;
    hdr->longcode = MSG_LONGCODE;
    hdr->n_fields = 0;

    /* initialize message access block */
    msg->iovcnt = 1;
    msg->iov_desc = msg_blockalloc (0);
    msg->iov_desc->type = BLK_IOVARRAY;
    vector = (struct iovec *) msg->iov_desc->addr;
    vector->iov_base = (char *) hdr;
    vector->iov_len = len;

    msg->body_info = msg_blockalloc (0);
    msg->body_info->type = BLK_BODY;
    ((block_desc **) msg->body_info->addr)[0] = hdr_desc;

    msg->avail_desc = msg_blockalloc (0);
    msg->avail_desc->type = BLK_AVAIL;
    ((long *) msg->avail_desc->addr)[0] = 0;
    msg->access_desc = acc_desc;

    msg->ftab_size = 0;
    msg->ftab_desc = msg_blockalloc (0);
    msg->ftab_desc->type = BLK_FTAB;
    ((ftab_entry *) msg->ftab_desc->addr)->name = 0;

    msg->fpointer = 1;
    msg->last_field = msg->last_inst = msg->last_index = 0;
    msg_setsender (msg, my_address);

    msg_namsgs++;
    if (msg_tracemsgs)
        msg_recordmsgalloc (msg);
    return(msg);
}




/* msg_genmsg: Generate a message containing the fields passed as       */
/*             arguments, which are of the form field_name,field_type,  */
/*             pointer_to_data, field_length, ...  , followed by 0      */
 
 
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
#include <varargs.h>
/*VARARGS*/
message *
msg_genmsg (va_alist)
   va_dcl
{
    register fname;
    register message    *msg;
    va_list ap;
 
    va_start(ap);
    msg = msg_newmsg();
    while(fname = va_arg(ap, int))
    {
        register char *fbody;
        register ftype, flen;
        fbody = va_arg(ap, char*);
        ftype = va_arg(ap, int);
        flen = va_arg(ap, int);
        (void) msg_addfield ((message *) msg, fname, fbody, ftype, flen);
    }
    va_end(ap);
    return (msg);
}




/* msg_reconstruct  : Create a messsage (with a proper message access      */
/*                    structure) from a block containing its text.  (It is */
/*                    assumed that the block has a proper header.)         */

message *
msg_reconstruct (data, blk_desc)
  char          *data;
  block_desc    *blk_desc;

 {
    register message    *msg;
    register header     *hdr;
    register int        i;
    register field_desc *f_desc;
    register ftab_entry *ft_ent;
    register char       *blk_ptr;
    int                 msg_len;
    block_desc          *acc_desc;
    struct iovec        *vector;

    hdr = (header *) data;
    msg_convertheader (hdr);
    blk_desc->type = BLK_HDRDATA;
    acc_desc = msg_accessalloc ();
    msg = (message *) acc_desc->addr;
    if (msg_tracecaller)
        msg_callertrace ("rec", msg, callername (1));
    msg->iovcnt = 1;
    msg->iov_desc = msg_blockalloc (0);
    msg->iov_desc->type = BLK_IOVARRAY;
    vector = (struct iovec *) msg->iov_desc->addr;
    vector->iov_base = data;
    msg_len = vector->iov_len = ntohl (hdr->len);

    msg->body_info = msg_blockalloc (0);
    msg->body_info->type = BLK_BODY;
    ((block_desc **) msg->body_info->addr)[0] = blk_desc;

    msg->avail_desc = msg_blockalloc (0);
    msg->avail_desc->type = BLK_AVAIL;
    ((long *) msg->avail_desc->addr)[0] = 0;
    msg->access_desc = acc_desc;

    msg->ftab_size = hdr->n_fields;
    msg->ftab_desc = msg_blockalloc (msg->ftab_size * sizeof (ftab_entry));
    msg->ftab_desc->type = BLK_FTAB;
    ft_ent = (ftab_entry *) msg->ftab_desc->addr;
    f_desc = hdr->fld_desc;
    blk_ptr = (char *) (f_desc + hdr->n_fields);
    for (i = 0; i < hdr->n_fields; i++, f_desc++, ft_ent++)
    {
        ft_ent->name = f_desc->name;
        if (f_desc->type == FTYPE_BROKENMSG)
            f_desc->type = FTYPE_MESSAGE;
        if (f_desc->type == FTYPE_MESSAGE)
            ft_ent->flag = FLAG_MSG;
        else
            ft_ent->flag = FLAG_DATA;
        ft_ent->len = f_desc->len;
        ft_ent->block_index = 0;
        ft_ent->start = blk_ptr;
        blk_ptr += PADDED_LEN (f_desc->len);
    }
    ft_ent->name = 0;

    if (data + msg_len != blk_ptr)
    {
        printf ("msg_reconstruct: inconsistency in data block\n");
        fflush (stdout);
        return ((message *) 0);
    }

    msg->fpointer = 1;
    msg->last_field = msg->last_inst = msg->last_index = 0;
    msg_namsgs++;
    if (msg_tracemsgs)
        msg_recordmsgalloc (msg);

    return (msg);
}



/* msg_delete: If the reference count of the given message is 1,     */
/*             release the space allocated to it.  Else, decrement   */
/*             the reference count.                                  */

msg_delete (msg)
  register message  *msg;

{
    register int        i;
    register block_desc **blk_descpp;
    if (msg_tracecaller)
        msg_callertrace ("del", msg, callername (1));
    msg_blockfree (msg->iov_desc);
    for (blk_descpp = (block_desc **) msg->body_info->addr, i = 0;
                                         i < msg->iovcnt; i++, blk_descpp++)
        msg_blockfree (*blk_descpp);
    msg_blockfree (msg->body_info);
    msg_blockfree (msg->avail_desc);
    msg_blockfree (msg->ftab_desc);

    if (msg->access_desc->refcount == 1)
    {
        msg_nfmsgs++;
        if (msg_tracemsgs)
            msg_recordmsgfree (msg);
    }

    msg_blockfree (msg->access_desc);
}



/* msg_split:   Create a new header block for the given message */

msg_split (msg)
  register message  *msg;

{
    header                  *old_hdr;
    register int            hdr_size;
    block_desc              *blk_desc;
    register ftab_entry     *ftab_ent;
    register struct iovec   *iovarray;
    register block_desc     **body_desc;

    iovarray = (struct iovec *) msg->iov_desc->addr;
    body_desc = (block_desc **) msg->body_info->addr;
    old_hdr = (header *) iovarray->iov_base;
    blk_desc = msg_blockalloc (sizeof (header) + old_hdr->n_fields *
                                                      sizeof (field_desc));
    blk_desc->type = BLK_HEADER;
    hdr_size = ((char *) old_hdr->fld_desc - (char *) old_hdr) +
                                   old_hdr->n_fields * sizeof (field_desc);
    bcopy ((char *) old_hdr, blk_desc->addr, hdr_size);

    if (msg_singleblock (msg))
    {
        msg->iovcnt = 2;
        iovarray[1].iov_base = iovarray[0].iov_base + hdr_size;
        iovarray[1].iov_len = iovarray[0].iov_len - hdr_size;
        body_desc[1] = body_desc[0];
        body_desc[1]->type = BLK_DATA;
        
        for (ftab_ent = (ftab_entry *) msg->ftab_desc->addr; ftab_ent->name;
                                                                   ftab_ent++)
            ftab_ent->block_index = 1;

        body_desc[0]->refcount += msg->access_desc->refcount;
                                         /* will be decremented again below */
    }

    iovarray->iov_base = blk_desc->addr;
    iovarray->iov_len = hdr_size;
    body_desc[0]->refcount -= msg->access_desc->refcount;
    body_desc[0] = blk_desc;
    body_desc[0]->refcount = msg->access_desc->refcount;
    ((long *) msg->avail_desc->addr)[0] = 0;
    ((long *) msg->avail_desc->addr)[msg->iovcnt - 1] = 0;
}
    


/* msg_copy:  Create a copy of a given message */

message *
msg_copy (msg)
  message   *msg;
{
    register block_desc     *b_desc;
    register char           *dp;
    register int            i;
    register struct iovec   *vp;

    b_desc = msg_blockalloc (msg_getlen (msg));
    dp = b_desc->addr;
    vp = msg_getiovec (msg);
    for (i = 0; i < msg_getiovlen (msg); i++, vp++)
    {
        bcopy (vp->iov_base, dp, vp->iov_len);
        dp += vp->iov_len;
    }
    return (msg_reconstruct (b_desc->addr, b_desc));
}
