/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include "isis.h"
/*#include    "msg.h"*/
#define     begin

/* msg_addmsg  : Insert a msg2 into msg1 as a field           */

msg_addmsg (msg1, field, msg2)
  register message  *msg1;
  message           *msg2;
  u_char            field;

 {
    if (field > SYSFLD_USERLIMIT)
    {
        printf ("msg_addmsg: invalid field name %d; message %x not added\n",
                                                                  field, msg2);
        fflush (stdout);
        return;
    }
    msg_insertmsg (msg1, field, msg2);
}



msg_insertmsg (msg1, field, msg2)
  register message  *msg1;
  message           *msg2;
  u_char            field;

 {
    header                  *hdr1;
    long                    msg2_len;
    register struct iovec   *iovarray1;

    if (msg_tracecaller)
        msg_callertrace ("add", msg2, callername (1));
    if (field == 0)
    {
        printf ("msg_insertmsg: invalid field name %d; message %x not added\n",
                                                                  field, msg2);
        fflush (stdout);
        return;
    }
    if (!msg_ismsg (msg2))
    {
        printf ("msg_insertmsg: %x is not a message; not added to %x\n", msg2,
                                                                        msg1);
        fflush (stdout);
        return;
    }

    if (!msg_singleaccess (msg1) || msg_singleblock (msg1))
        msg_split (msg1);

    iovarray1 = (struct iovec *) msg1->iov_desc->addr;
    hdr1 = (header *) iovarray1->iov_base;
    msg2_len = msg_getlen (msg2);
    
    /* update hdr1 */
    hdr1->len = htonl (ntohl (hdr1->len) + msg2_len + sizeof (field_desc));
    begin
    {
        register field_desc     *f_desc;
        register block_desc     **hdr_descp;
        
        f_desc = &(hdr1->fld_desc[hdr1->n_fields]);
        hdr_descp = (block_desc **) msg1->body_info->addr;
        if ((char *) (f_desc + 1) > (*hdr_descp)->addr + (*hdr_descp)->len)
        {
            msg_blockdouble (hdr_descp);
            hdr1 = (header *) (*hdr_descp)->addr;
            iovarray1->iov_base = (char *) hdr1;
            f_desc = &(hdr1->fld_desc[hdr1->n_fields]);
        }
        hdr1->n_fields++;
        f_desc->name = field;
        f_desc->type = (msg_singleblock (msg2) ? FTYPE_MESSAGE :
                                                          FTYPE_BROKENMSG);
        f_desc->shortcode = MSG_SHORTCODE;
        f_desc->longcode = MSG_LONGCODE;
        f_desc->len = msg2_len;
    }
    
    /* update msg1 access structure and increment refcounts */
    iovarray1->iov_len += sizeof (field_desc);
    begin
    {
        register int            i, j;
        register ftab_entry     *entry;
        register struct iovec   *vector, *iovarray2;
        register block_desc     **b_desc;
        register long           *availp;

        iovarray2 = (struct iovec *) msg2->iov_desc->addr;
        entry = &(((ftab_entry *) msg1->ftab_desc->addr)[msg1->ftab_size]);
        if ((char *) (entry + 2) > msg1->ftab_desc->addr +
                                                      msg1->ftab_desc->len)
        {
            msg_blockdouble (&msg1->ftab_desc);
            entry = &(((ftab_entry *) msg1->ftab_desc->addr)[msg1->ftab_size]);
        }
        msg1->ftab_size++;
        entry->flag = (msg_singleblock (msg2) ? FLAG_MSG : FLAG_BROKENMSG);
        entry->name = field;
        entry->block_index = msg1->iovcnt;
        entry->len = msg2_len;
        entry->start = iovarray2->iov_base;
        (++entry)->name = 0;
        for (i = 0; i < msg2->iovcnt; i++)
        {
            vector = &(iovarray2[i]);
            j = msg1->iovcnt++;
            if ((char *) &(iovarray1[j + 1]) > (char *) iovarray1 +
                                                         msg1->iov_desc->len)
            {
                msg_blockdouble (&msg1->iov_desc);
                iovarray1 = (struct iovec *) msg1->iov_desc->addr;
            }
            iovarray1[j] = *vector;

            b_desc = &(((block_desc **) msg1->body_info->addr)[j]);
            if ((char *) (b_desc + 1) > msg1->body_info->addr +
                                                        msg1->body_info->len)
            {
                msg_blockdouble (&msg1->body_info);
                b_desc = &(((block_desc **) msg1->body_info->addr)[j]);
            }
            *b_desc = ((block_desc **) msg2->body_info->addr)[i];
            (*b_desc)->refcount += msg1->access_desc->refcount;

            availp = &(((long *) msg1->avail_desc->addr)[j]);
            if ((char *) (availp + 1) > msg1->avail_desc->addr +
                                                       msg1->avail_desc->len)
            {
                msg_blockdouble (&msg1->avail_desc);
                availp = &(((long *) msg1->avail_desc->addr)[j]);
            }
            *availp = 0;
        }
    }
}


/* msg_getmsg : Create a message from the contents of a given instance of a */
/*              field.  The field must have been added using msg_addmsg().  */

message *
msg_getmsg (msg, field, inst)
  register message  *msg;
  register u_char   field;
  register int      inst;

{
    message     *mp;

    mp = (message *) 0;
    msg_unpkmsgs (msg, field, inst, 1, &mp);
    if (msg_tracecaller)
        msg_callertrace ("get", msg, callername (1));
    return (mp);
}




/* msg_unpkmsgs : Return an array of upto n message pointers, the messages   */
/*                being created from the contents of a given field, starting */
/*                with instance first.  The field must have been added using */
/*                msg_addmsg().  Returns the actual number of messages found */

msg_unpkmsgs (msg, field, first, n, msgs)
  register message  *msg;
  u_char            field;
  int               first, n;
  message           *msgs[];

{
    register ftab_entry     *ftab_ent;
    int                     inst;
    int                     blk_index;
    int                     n_found = 0;
    int                     index, found = 0;

    if (field == 0 || field == SYSFLD_DELETED)
    {
        printf ("msg_unpkmsgs: invalid field name %d\n", field);
        fflush (stdout);
        return (0);
    }

    if (field == msg->last_field && first >= msg->last_inst)
    {
        ftab_ent = ((ftab_entry *) msg->ftab_desc->addr) + msg->last_index;
        inst = msg->last_inst - 1;
        index = msg->last_index;
    }
    else
    {
        ftab_ent = (ftab_entry *) msg->ftab_desc->addr;
        inst = 0;
        index = 0;
    }

    while (inst < first + n - 1 && ftab_ent->name)
    {
        if (ftab_ent->name == field)
            if (++inst >= first)
                if (ftab_ent->flag == FLAG_MSG)
                {
                    register block_desc     *blk_desc;

                    blk_desc = ((block_desc **)
                                  msg->body_info->addr)[ftab_ent->block_index];
                    msgs[n_found++] =
                                   msg_reconstruct (ftab_ent->start, blk_desc);
                    blk_desc->refcount++;
                    found = index;
                }
                else if (ftab_ent->flag == FLAG_BROKENMSG)
                {
                    register message        *mp;    
                    block_desc              *acc_desc, **body_desc;
                    register ftab_entry     *ft_ent;
                    register field_desc     *f_desc;
                    register char           *blk_ptr, *blk_end;
                    register int            i;
                    int                     curr_index;
                    header                  *hdr;

                    acc_desc = msg_accessalloc ();
                    mp = (message *) acc_desc->addr;
                    blk_index = ftab_ent->block_index;
                    mp->iovcnt = 1;
                    mp->iov_desc = msg_blockalloc (0);
                    mp->iov_desc->type = BLK_IOVARRAY;
                    ((struct iovec *) mp->iov_desc->addr)[0] = 
                           ((struct iovec *) msg->iov_desc->addr)[blk_index];

                    mp->body_info = msg_blockalloc (0);
                    mp->body_info->type = BLK_BODY;
                    ((block_desc **) mp->body_info->addr)[0] =
                            ((block_desc **) msg->body_info->addr)[blk_index];
                    ((block_desc **) mp->body_info->addr)[0]->refcount++;

                    mp->avail_desc = msg_blockalloc (0);
                    mp->avail_desc->type = BLK_AVAIL;
                    ((long *) mp->avail_desc->addr)[0] = 0;
                    mp->access_desc = acc_desc;
                    hdr = (header *) ftab_ent->start;
                    msg_convertheader (hdr);

                    mp->ftab_size = hdr->n_fields;
                    mp->ftab_desc = msg_blockalloc (mp->ftab_size * sizeof (ftab_entry));
                    mp->ftab_desc->type = BLK_FTAB;
                    ft_ent = (ftab_entry *) mp->ftab_desc->addr;
                    f_desc = hdr->fld_desc;
                    for (i = 0, blk_ptr = blk_end = 0; i < hdr->n_fields;
                                                       i++, f_desc++, ft_ent++)
                    {
                        int     nextlen;

                        if (blk_ptr > blk_end)
                        {
                            printf ("msg_unpkmsgs: broken field!\n");
                            fflush (stdout);
                            return (n_found);
                        }
                        curr_index = mp->iovcnt - 1;
                        nextlen = f_desc->len;
                        if (blk_ptr == blk_end && nextlen > 0)
                        {
                            int     totlen;
                            char    oneblock;

                            blk_ptr = (char *) 0;
                            for (oneblock = TRUE, totlen = 0;
                               totlen < nextlen; totlen += ((struct iovec *)
                                       msg->iov_desc->addr)[blk_index].iov_len)
                            {
                                register struct iovec   *vector;
                                register block_desc     **b_desc;
                                register long           *availp;

                                blk_index++;
                                vector = &(((struct iovec *)
                                             mp->iov_desc->addr)[mp->iovcnt]);
                                if ((char *) (vector + 1) >
                                      mp->iov_desc->addr + mp->iov_desc->len)
                                {
                                    msg_blockdouble (&mp->iov_desc);
                                    vector = &(((struct iovec *)
                                             mp->iov_desc->addr)[mp->iovcnt]);
                                }
                                *vector = ((struct iovec *)
                                              msg->iov_desc->addr)[blk_index];

                                b_desc = &(((block_desc **)
                                            mp->body_info->addr)[mp->iovcnt]);
                                if ((char *) (b_desc + 1) >
                                     mp->body_info->addr + mp->body_info->len)
                                {
                                    msg_blockdouble (&mp->body_info);
                                    b_desc = &(((block_desc **)
                                            mp->body_info->addr)[mp->iovcnt]);
                                }
                                *b_desc = ((block_desc **)
                                            msg->body_info->addr)[blk_index];
                                (*b_desc)->refcount++;

                                availp = &(((long *)
                                          mp->avail_desc->addr)[mp->iovcnt]);
                                if ((char *) (availp + 1) >
                                    mp->avail_desc->addr + mp->avail_desc->len)
                                {
                                    msg_blockdouble (&mp->avail_desc);
                                    availp = &(((long *)
                                           mp->avail_desc->addr)[mp->iovcnt]);
                                }
                                *availp = 0;

                                mp->iovcnt++;
                                if (blk_ptr == (char *) 0)
                                {
                                    blk_ptr = ((struct iovec *)
                                      msg->iov_desc->addr)[blk_index].iov_base;
                                    curr_index++;
                                }
                                else
                                {
                                    if (f_desc->type != FTYPE_BROKENMSG)
                                        print ("msg_unpkmsgs: not bmsg\n");
                                    oneblock = FALSE;
                                }
                            }
                            if (oneblock)
                                blk_end = blk_ptr + ((struct iovec *)
                                      msg->iov_desc->addr)[blk_index].iov_len;
                            else
                            {
                                if (totlen > nextlen)
                                    print ("msg_unpkmsgs: extra stuff!\n");
                                blk_end = blk_ptr + PADDED_LEN (f_desc->len);
                            }
                        }
                        ft_ent->name = f_desc->name;
                        if (f_desc->type == FTYPE_BROKENMSG)
                            if (((block_desc **)
                                 msg->body_info->addr)[blk_index]->type ==
                                                                  BLK_HDRDATA)
                            {
                                f_desc->type = FTYPE_MESSAGE;
                                ft_ent->flag = FLAG_MSG;
                            }
                            else
                                ft_ent->flag = FLAG_BROKENMSG;
                        else if (f_desc->type == FTYPE_MESSAGE)
                            ft_ent->flag = FLAG_MSG;
                        else
                            ft_ent->flag = FLAG_DATA;
                        ft_ent->len = f_desc->len;
                        ft_ent->block_index = curr_index;
                        ft_ent->start = blk_ptr;
                        blk_ptr += PADDED_LEN (f_desc->len);
                    }
                    ft_ent->name = 0;

                    mp->fpointer = 1;
                    mp->last_field = mp->last_inst = mp->last_index = 0;
                    msgs[n_found++] = mp;
                    found = index;

                    msg_namsgs++;
                    if (msg_tracemsgs)
                        msg_recordmsgalloc (mp);
                    if (msg_tracecaller)
                        msg_callertrace ("unp", mp, callername (1));
                }
                else
                    print ("msg_unpkmsgs: field %d was not %s\n",
                                            field, "added using msg_addmsg()");
        ftab_ent++;
        index++;
    }

    if (found)
    {
        msg->last_field = field;
        msg->last_inst = inst;
        msg->last_index = found;
    }

    return (n_found);
}
