/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include    "isis.h"

/* msg_memory: allocate and free message memory */

adesc   bd_adesc        = {sizeof(block_desc),0,32};
queue   *bd_adescq;

adesc   access_adesc    = {sizeof(message),0,32};
queue   *ac_adescq;

/* Limits amount buffered here at any time  to 32K */
#define MAX_BUFFERED            (32 * 1024)
int     amt_buffered;

#define BSIZE(n)                (1<<(n+7))
adesc   block_adesc[]   = {{BSIZE(0),0,32}, {BSIZE(1),0,16}, {BSIZE(2),0,16}, {BSIZE(3),0,8},  {BSIZE(4),0,4},  {BSIZE(5),0,2}};
queue   *block_adescq[] = { NULLQP, NULLQP };

block_desc *
msg_accessalloc ()
  {
        register block_desc     *blk_desc;
        register queue          *qp = bd_adescq;
        if (qp = qu_head (qp))
        {
            blk_desc = (block_desc *) qp->qu_data;
            qu_free(qp);
        }
        else
            blk_desc = (block_desc *) mallocate (&bd_adesc);
        qp = ac_adescq;
        if (qp = qu_head (qp))
        {
            blk_desc->addr = qp->qu_data;
            qu_free(qp);
        }
        else
            blk_desc->addr = mallocate (&access_adesc);
        blk_desc->refcount = 1;
        blk_desc->type = BLK_ACCESS;
#ifdef MSG_STATS
        msg_nalloc++;
        if (msg_usagestats)
           msg_recordalloc (blk_desc);
#endif MSG_STATS
        return (blk_desc);
  }


block_desc *
msg_blockalloc (req_len)
  register int  req_len;
  {
        register block_desc     *blk_desc;
        register                bn;
        register                len = req_len;
        char                    *malloc();
        register queue          *qp = bd_adescq;
        if (qp = qu_head (qp))
        {
            blk_desc = (block_desc *) qp->qu_data;
            qu_free(qp);
        }
        else
            blk_desc = (block_desc *) mallocate (&bd_adesc);
        blk_desc->refcount = 1;
        blk_desc->type = BLK_DATA;
        qp = NULLQP;
        if(len <= BSIZE(0))
           { bn = 0; blk_desc->len = BSIZE(0); qp = block_adescq[0]; }
        else if(len <= BSIZE(1))
           { bn = 1; blk_desc->len = BSIZE(1); qp = block_adescq[1];}
        else if(len <= BSIZE(2))
           { bn = 2; blk_desc->len = BSIZE(2); }
        else if(len <= BSIZE(3))
           { bn = 3; blk_desc->len = BSIZE(3); }
        else if(len <= BSIZE(4))
           { bn = 4; blk_desc->len = BSIZE(4); }
        else if(req_len <= BSIZE(5))
           { bn = 5; blk_desc->len = BSIZE(5); }
        else 
        {
            len = (req_len+0x3ff) & ~0x3ff;
            if (!(blk_desc->addr = malloc(len)))
            {
                perror("msg_blkalloc, malloc");
                panic("malloc failed");
            }
            blk_desc->len = len;
            bn = 6;
            goto done;
         }
         if (qp = qu_head(qp))
         {
             blk_desc->addr = qp->qu_data;
             amt_buffered -= blk_desc->len;
if(blk_desc->len != BSIZE(bn)) panic("Blarf in block alloc!\n");
             qu_free(qp);
         }
         else
             blk_desc->addr = mallocate (&block_adesc[bn]);
  done:
        blk_desc->bindex = bn;
#       ifdef MSG_STATS
        msg_nalloc++;
        msg_memused += blk_desc->len;
        if (msg_usagestats)
            msg_recordalloc (blk_desc);
#       endif
        return (blk_desc);
  }


msg_blockfree (blk_desc)
  register block_desc   *blk_desc;
  {
        if (blk_desc->refcount < 1)
        {
            print ("Incorrect refcount for block desc ");
            msg_printblkdesc (blk_desc);
            panic ("Incorrect refcount for block %x", blk_desc);
        }
        if(--blk_desc->refcount == 0)
        {
            if(blk_desc->type != BLK_ACCESS)
            {
                register bn = blk_desc->bindex;
                if (bn <= 1 && amt_buffered < MAX_BUFFERED)
                {
                    register queue *qp;
                    if ((qp = block_adescq[bn]) == NULLQP)
                        block_adescq[bn] = qp = qu_null();
                    qu_add(qp, 0, blk_desc->addr, NULLROUTINE);
if(bn < 0) panic("blk_desc-> type %d index %d", blk_desc->type, blk_desc->bindex);
                    amt_buffered += BSIZE(bn);
                }
                else if(bn != 6)
                    mdeallocate(blk_desc->addr, &block_adesc[bn]);
                else
                    free(blk_desc->addr);
            }
            else 
            {
                if(ac_adescq == NULLQP)
                    ac_adescq = qu_null();
                qu_add(ac_adescq, 0, blk_desc->addr, NULLROUTINE);
            }
            if(bd_adescq == NULLQP)
                bd_adescq = qu_null();
            qu_add(bd_adescq, 0, (char *) blk_desc, NULLROUTINE);
#ifdef      MSG_STATS
            msg_nfree++;
            if(blk_desc->type != BLK_ACCESS)
                msg_memfree += blk_desc->len;
            if (msg_usagestats)
                msg_recordfree (blk_desc);
#endif      MSG_STATS
        }
  }

msg_blockcheck (blk_desc)
  register block_desc   *blk_desc;
  {
        register int        i, j;
        register block_desc **blk_descpp;
        register message    *msg;
        message             *refs[4];
        int                 nrefs = 0;

        for (i = 0; i < 4; i++)
            refs[i] = 0;
        for (i = 0; i < MSG_TRACESIZE; i++)
        {
            if ((msg = alloc_msg[i]) == 0)
                continue;
            if (msg->iov_desc == blk_desc)
                refs[nrefs++] = msg;
            for (blk_descpp = (block_desc **) msg->body_info->addr, j = 0;
                                             j < msg->iovcnt; j++, blk_descpp++)
                if (*blk_descpp == blk_desc)
                    refs[nrefs++] = msg;
            if (msg->body_info == blk_desc)
                refs[nrefs++] = msg;
            if (msg->avail_desc == blk_desc)
                refs[nrefs++] = msg;
            if (msg->access_desc == blk_desc)
                refs[nrefs++] = msg;
            if (msg->ftab_desc == blk_desc)
                refs[nrefs++] = msg;
        }
        if (nrefs > 1)
        {
            print ("Attempting to free referenced block desc %x\n", blk_desc);
            for (i = 0; i < nrefs; i++)
                msg_printaccess (refs[i]);
            panic ("Freeing block desc referenced in more than one message");
        }
  }

msg_blockdouble (descp)
  register block_desc   **descp;
  {
        register block_desc *new_desc;
        new_desc = msg_blockalloc(2 * (*descp)->len);
        bcopy ((*descp)->addr, new_desc->addr, (*descp)->len);
        new_desc->refcount = (*descp)->refcount;
        (*descp)->refcount = 1;
        msg_blockfree(*descp);
        *descp = new_desc;
  }

msg_printblkdesc (blk_desc)
  register block_desc   *blk_desc;
  {
        printf ("[%x]%x/%d/%d/", blk_desc, blk_desc->addr, blk_desc->len,
                                                         blk_desc->refcount);
        switch (blk_desc->type)
        {
          case BLK_ACCESS:
            printf ("access/");
            break;

          case BLK_HEADER:
            printf ("header/");
            break;

          case BLK_DATA:
            printf ("data/");
            break;

          case BLK_HDRDATA:
            printf ("hdrdata/");
            break;

          case BLK_FTAB:
            printf ("ftab/");
            break;

          case BLK_IOVARRAY:
            printf ("iovarray/");
            break;

          case BLK_BODY:
            printf ("binfo/");
            break;

          case BLK_AVAIL:
            printf ("avail/");
            break;
    
          default:
            printf ("%d/", blk_desc->type);
            break;
        }
        if (blk_desc->bindex < 6) 
            printf("b%d", BSIZE(blk_desc->bindex));
        else
            printf ("malloc");
  }


msg_recordalloc (blk_desc)
  register block_desc   *blk_desc;
  {
        register int    i, slot = MSG_TRACESIZE;
  
        for (i = 0; i < MSG_TRACESIZE; i++)
        {
            if (slot == MSG_TRACESIZE && alloc_blk[i] == 0)
                slot = i;
            if (alloc_blk[i] == blk_desc)
            {
                printf ("msg_recordalloc: block %x already allocated!\n",
                                                                  blk_desc);
                fflush (stdout);
                return;
            }
        }
        if (slot == MSG_TRACESIZE)
        {
            printf ("msg_recordalloc: alloc_blk overflow.  %s\n",
                                                      "Turning off block trace.");
            fflush (stdout);
            msg_usagestats = FALSE;
            return;
        }
        alloc_blk[slot] = blk_desc;
        return;
  }


msg_recordfree (blk_desc)
  register block_desc   *blk_desc;
  {
        register int    i;

        for(i = 0; alloc_blk[i] != blk_desc && i < MSG_TRACESIZE; i++)
            continue;
        if (i == MSG_TRACESIZE)
        {
            printf ("msg_recordfree: block %x not allocated!\n", blk_desc);
            fflush (stdout);
        }
        else
            alloc_blk[i] = (block_desc *) 0;
  }
