/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Routines for adding/scanning messages
 */

#include "isis.h"
#include "ctype.h"
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
#include <varargs.h>

int	pushes_by_ref = -1;	/* Many varargs implementations have a problem... */

typedef struct
{
        int     fi_size;
        int     fi_type;
} format_item;

#define FMESSAGE        -1
#define FSTRING         -2

format_item     format_table[26] 
={
        sizeof(address),        FTYPE_ADDRESS,          /* 'a' */
        sizeof(bitvec),         FTYPE_BITVEC,           /* 'b' */
        sizeof(char),           FTYPE_CHAR,             /* 'c' */
        sizeof(int),            FTYPE_LONG,             /* 'd' */
        sizeof(event_id),       FTYPE_EVENT,            /* 'e' */
        0,                      -1,                     /* 'f' */
        0,                      -1,                     /* 'g' */
        sizeof(short),          FTYPE_SHORT,            /* 'h' */
        0,                      -1,                     /* 'i' */
        0,                      -1,                     /* 'j' */
        0,                      -1,                     /* 'k' */
        sizeof(int),            FTYPE_LONG,             /* 'l' */
        FMESSAGE,               FTYPE_MESSAGE,          /* 'm' */
        0,                      -1,                     /* 'n' */
        0,                      -1,                     /* 'o' */
        sizeof(groupview),      FTYPE_GROUPVIEW,                /* 'p' */
        0,                      -1,                     /* 'q' */
        0,                      -1,                     /* 'r' */
        FSTRING,                FTYPE_CHAR,             /* 's' */
        0,                      -1,                     /* 't' */
        0,                      -1,                     /* 'u' */
        0,                      -1,                     /* 'v' */
        0,                      -1,                     /* 'w' */
        0,                      -1,                     /* 'x' */
        0,                      -1,                     /* 'y' */
        0,                      -1,                     /* 'z' */
  };

message *
msg_gen(va_alist)
  va_dcl
  {
        va_list ap;
        register message *mp = msg_newmsg();
        register rval;
        va_start(ap);
        rval = msg_doputf(mp, SYSFLD_SCAN, &ap);
        va_end(ap);
        if(rval == 0)
            return(mp);
        msg_delete(mp);
        return((message*)0);
  }

msg_put(va_alist)
  va_dcl
  {
        va_list ap;
        message *mp;
        register rval;
        va_start(ap);
        mp = va_arg(ap, message*);
        rval = msg_doputf(mp, SYSFLD_SCAN, &ap);
        va_end(ap);
        return(rval);
  }

msg_putfld(va_alist)
  va_dcl
  {
        va_list ap;
        register char *fmt;
        message *mp;
        register rval, fname;
        va_start(ap);
        mp = va_arg(ap, message*);
        fname = va_arg(ap, int);
        rval = msg_doputf(mp, fname, &ap);
        va_end(ap);
        return(rval);
  }

msg_doputf(mp, fname, ap)
  message *mp;
  va_list *ap;
  {
        register c;
        register char *fmt;
        if(pushes_by_ref == -1)
	    check_varargs();
        isis_errno = 0;
        fmt = va_arg(*ap, char*);
        while(c = *fmt++)
            if(c == '%')
            {
                int vector = 0, *where, len;
                register format_item *fi;
                c = *fmt++;
                if(!isascii(c))
                {
                    isis_errno = IE_BADFITEM;
                    return(-1);
                }
                if(isupper(c))
                {
                    ++vector;
                    c = tolower(c);
                    where = va_arg(*ap, int *);
                    len = va_arg(*ap, int);
                }
                fi = &format_table[c-'a'];
                switch(fi->fi_size)
                {
                  case 0:
                    isis_errno = IE_BADFITEM;
                    return(-1);
                  default:
                    if(vector)
                        msg_insertfield(mp, fname, where, fi->fi_type, len * fi->fi_size);
                    else switch(c)
                    {
                      case 'a': {
                        address is_addr;
                        if(pushes_by_ref)
                            is_addr = *va_arg(*ap, address*);
                        else
                            is_addr = va_arg(*ap, address);
                        msg_insertfield(mp, fname, &is_addr, FTYPE_ADDRESS, sizeof(address));
                        break;
                      }
                      case 'b': {
                        bitvec is_bitvec;
                        if (pushes_by_ref)
                            is_bitvec = *va_arg(*ap, bitvec*);
                        else
                            is_bitvec = va_arg(*ap, bitvec);
                        msg_insertfield(mp, fname, &is_bitvec, FTYPE_BITVEC, sizeof(bitvec));
                        break;
                      }
                      case 'c':
                      case 'd':
                      case 'l':
                      case 'h': {
                        int is_int;
                        is_int = va_arg(*ap, int);
                        if(c == 'h')
                        {
                            short is_short = is_int;
                            msg_insertfield(mp, fname, &is_short, FTYPE_SHORT, sizeof(short));
                        }
                        else if (c == 'c')
                        {
                            char is_char = is_int;
                            msg_insertfield(mp, fname, &is_char, FTYPE_CHAR, sizeof(char));
                        }
                        else
                            msg_insertfield(mp, fname, &is_int, FTYPE_LONG, sizeof(long));
                        break;
                      }
                      case 'e': {
                        event_id is_eventid;
                        if (pushes_by_ref)
                            is_eventid = *va_arg(*ap, event_id*);
                        else
                            is_eventid = va_arg(*ap, event_id);
                        msg_insertfield(mp, fname, &is_eventid, FTYPE_EVENT, sizeof(event_id));
                        break;
                      }
                      case 'p': {
                        groupview is_groupview;
                        if (pushes_by_ref)
                            is_groupview = *va_arg(*ap, groupview*);
                        else
                            is_groupview = va_arg(*ap, groupview);
                        msg_insertfield(mp, fname, &is_groupview, FTYPE_GROUPVIEW, sizeof(&is_groupview));
                        break;
                      }
                    }
                    break;
                  case FMESSAGE:
                    if(vector)
                    {
                        isis_errno = IE_NOTIMP;
                        return(-1);
                    } 
                    msg_insertmsg(mp, fname, va_arg(*ap, message*));
                    break;
                  case FSTRING:
                    if(vector)
                    {
                        isis_errno = IE_NOTIMP;
                        return(-1);
                    } 
                    else
                    {
                        char *is_str;
                        is_str = va_arg(*ap, char*);
                        msg_insertfield(mp, fname, is_str, fi->fi_type, strlen(is_str)+1);
                    }
                    break;
                }
            }
        return(0);
  }

msg_get(va_alist)
  va_dcl
  {
        va_list ap;
        message *mp;
        int rval;
        va_start(ap);
        mp = va_arg(ap, message*);
        rval = msg_dogetf(&mp, 1, SYSFLD_SCAN, &mp->fpointer, &ap);
        va_end(ap);
        return(rval);
  }

msg_getfld(va_alist)
  va_dcl
  {
        va_list ap;
        message *mp;
        register fname, *fpointer, rval;
        va_start(ap);
        mp = va_arg(ap, message*);
        fname = va_arg(ap, int);
        fpointer = va_arg(ap, int*);
        if(fpointer && *fpointer == 0)
            ++*fpointer;
        rval = msg_dogetf(&mp, 1, fname, fpointer, &ap);
        va_end(ap);
        return(rval);
  }

char    *isis_format;   /* Last format scanned */
int     isis_fitem;     /* Last format item scanned */

/*
 *      Ugly little routine to collect answers from a list of messages
 *      and put them into vectors of places for answers provided
 *      by the caller.  Called from the bcast routines too.
 */
msg_dogetf(mlist, nmsgs, fname, fpt, argp)
  message **mlist;
  va_list *argp;
  int *fpt;
  {
        register c;
        int getf_count;
        va_list acopy = *argp;
        isis_errno = 0;
        while(nmsgs--)
        {
            register message *mp = *mlist++;
            register char *format;
            register *fpointer = fpt;
            int dummy_ptr = 1;
            if(fpointer == 0)
                fpointer = &dummy_ptr;
            /* Will need to rescan the argument list for 0..nmsgs-1 */
            getf_count = 0;
            *argp = acopy;
            isis_format = format = va_arg(*argp, char*);
            while(c = *format++) if(c == '%')
            {
                int vector = 0, do_malloc = 0, do_copy = 1, where, len;
                register format_item *fi;
                register char **ptr;
                c = *format++;
                if(c == '+')
                {
                    do_malloc = 1;
                    c = *format++;
                }
                else if(c == '-')
                {
                    do_copy = 0;
                    c = *format++;
                }
                if(!isascii(c))
                {
                    isis_errno = IE_BADFITEM;
                    return(-1);
                }
                if(isupper(c))
                {
                    ++vector;
                    c = tolower(c);
                }
                else if((do_malloc || !do_copy) && (c != 's'))
                {
                    isis_errno = IE_BADFITEM;
                    return(-1);
                }
                fi = &format_table[c-'a'];
                if(msg_gettype(mp, fname, *fpointer) != fi->fi_type)
                {
                    if(msg_getfield(mp, fname, *fpointer, (int*)0) == 0)
                        break;
                    isis_errno = IE_MISSMATCH;
                    return(-1);
                }
                ++getf_count;
                ptr = &va_arg(*argp, char*);
                switch(fi->fi_size)
                {
                    register char *source;
                  case 0:
                    isis_errno = IE_BADFITEM;
                    return(-1);
                  default:
                  case FSTRING:
                    source = msg_getfield(mp, fname, (*fpointer)++, &len);
                    if(do_malloc)
                    {
                        char *malloc();
                        register char *dest = malloc(len);
                        *(*(char***)ptr)++ = dest;
                        bcopy(source, dest, len);
                    }
                    else if(do_copy)
                    {
                        bcopy(source, *ptr, len);
                        (*ptr) += len;
                    }
                    else
                        *(*(char***)ptr)++ = source;
                    if(vector)
                    {
                        int **lptr;
                        lptr = &va_arg(*argp, int*);
                        if(*lptr)
                            *(*lptr)++ = len / fi->fi_size;
                    }
                    break;
                  case FMESSAGE:
                    if(vector)
                    {
                        isis_errno = IE_NOTIMP;
                        return(-1);
                    } 
                    *(*(message***)ptr)++ = msg_getmsg(mp, fname, (*fpointer)++);
                    break;
                }
            }
        }
        return(getf_count);
  }

msg_rewind(mp)
  register message *mp;
  {
        mp->fpointer = 1;
  }

isis_define_type(typeno, formatletter, size, converter)
  char formatletter;
  ifunc *converter;
  {
        char *malloc();
        register char *string = malloc(32);
        register format_item *fi;
        fi = &format_table[formatletter-'a'];
        if(formatletter < 'a' || formatletter > 'z' || fi->fi_size)
            panic("isis_define_type %%%c: illegal or redefined formatletter", formatletter);
        sprintf(string, "user-defined type %%%c", formatletter);
        msg_definetype (typeno, size, converter, string);
        fi->fi_size = size;
        fi->fi_type = typeno;
  }

static docheck_varargs();

check_varargs()
  {
        address test_addr;
        test_addr = ADDRESS(10, 11, 12, 13);
        pushes_by_ref = 0;
        if(docheck_varargs(1, NULLADDRESS, 2, test_addr, 3) == -1)
        {
	    ++pushes_by_ref;
	    if(docheck_varargs(1, NULLADDRESS, 2, test_addr, 3) == -1)
	        panic("varargs(1) seems to have a bug on your system!");
            if(my_process_id == ISIS)
            {
	        print("\nWARNING: VARARGS(1) problem detected!\n");
                print("WARNING: va_arg(ap, <struct by value>) doesn't work as documented\n");
                print("WARNING: ISIS is automatically compensating.... but you should get this fixed\n\n");
            }
	}
  }

static
docheck_varargs(va_alist)
  va_dcl
  {
        int one, two, three; address null_addr, taddr;
        address test_addr;
        va_list ap;
        va_start(ap);
        one = va_arg(ap, int);
        if(pushes_by_ref == 1)
            null_addr = *va_arg(ap, address*);
        else
            null_addr = va_arg(ap, address);
        two = va_arg(ap, int);
        if(one != 1 || !addr_isnull(null_addr) || two != 2)
            return(-1);
        if(pushes_by_ref == 1)
            taddr = *va_arg(ap, address*);
        else
            taddr = va_arg(ap, address);
        three = va_arg(ap, int);
        va_end(ap);
        test_addr = ADDRESS(10, 11, 12, 13);
        if(addr_cmp(taddr, test_addr) || three != 3)
            return(-1);
        return(0);
  }
