/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include    "msg.h"
#define     begin

/* msg_addfield : Add a new field to a given message. Only positive field */
/*                names are accepted.  Returns a pointer to the field.    */

char *
msg_addfield (msg, field, data, type, len)
  register message  *msg;
  register u_char   field;
  register char     *data;
  register u_char   type;
  register int      len;

{
    register char    *ptr;

    ptr = (char *) 0;
    if (field == 0 || field > SYSFLD_USERLIMIT)
    {
        printf ("msg_addfield: invalid field name %d, field not added\n",
                                                                        field);
        fflush (stdout);
    }
    else
        ptr = msg_insertfield (msg, field, data, type, len);

    return (ptr);
}



/* msg_insertfield:  Add a new field to the given message.  A pointer to */
/*                   field is returned.                                  */

char *
msg_insertfield (msg, field, data, type, len)
  register message  *msg;
  u_char            field;
  char              *data;
  u_char            type;
  int               len;

{
    register header         *hdr;
    register struct iovec   *iovarray, *vector;
    register int            blk_index;
    register char           *start;
    register long           padded_len;

    if (type == 0)
        type = FTYPE_CHAR;

    if (!msg_singleaccess (msg) || msg_singleblock (msg))
        msg_split (msg);

    iovarray = (struct iovec *) msg->iov_desc->addr;
    hdr = (header *) iovarray->iov_base;
    blk_index = msg->iovcnt - 1;
    vector = &(iovarray[blk_index]);
    padded_len = PADDED_LEN (len);

    if (((long *) msg->avail_desc->addr)[blk_index] < padded_len)
    {
        /* allocate a new block and assign refcount */
        register block_desc     *blk_desc, **b_desc;
        register long           *availp;

        blk_desc = msg_blockalloc (padded_len+ntohl (hdr->len));
        blk_desc->refcount = msg->access_desc->refcount;
        blk_index = msg->iovcnt++;
        vector = &(iovarray[blk_index]);
        if ((char *) (vector + 1) > msg->iov_desc->addr + msg->iov_desc->len)
        {
            msg_blockdouble (&msg->iov_desc);
            iovarray = (struct iovec *) msg->iov_desc->addr;
            vector = &(iovarray[blk_index]);
            hdr = (header *) iovarray->iov_base;
        }
        vector->iov_base = blk_desc->addr;
        vector->iov_len = 0;

        b_desc = &(((block_desc **) msg->body_info->addr)[blk_index]);
        if ((char *) (b_desc + 1) > msg->body_info->addr + msg->body_info->len)
        {
            msg_blockdouble (&msg->body_info);
            b_desc = &(((block_desc **) msg->body_info->addr)[blk_index]);
        }
        *b_desc = blk_desc;

        availp = &(((long *) msg->avail_desc->addr)[blk_index]);
        if ((char *) (availp + 1) > msg->avail_desc->addr+msg->avail_desc->len)
        {
            msg_blockdouble (&msg->avail_desc);
            availp = &(((long *) msg->avail_desc->addr)[blk_index]);
        }
        *availp = blk_desc->len;
    }

    /* copy data into field */
    start = vector->iov_base + vector->iov_len;
    if (len > 0)
        bcopy (data, start, len);
    ((long *) msg->avail_desc->addr)[blk_index] -= padded_len;

    /* update message header */
    hdr->len = htonl (ntohl (hdr->len) + padded_len + sizeof (field_desc));
    begin
    {
        register field_desc     *f_desc;
        register block_desc     **hdr_descp;
 
        f_desc = &(hdr->fld_desc[hdr->n_fields]);
        hdr_descp = (block_desc **) msg->body_info->addr;
        if ((char *) (f_desc + 1) > (*hdr_descp)->addr + (*hdr_descp)->len)
        {
            msg_blockdouble (hdr_descp);
            hdr = (header *) (*hdr_descp)->addr;
            ((struct iovec *) msg->iov_desc->addr)->iov_base = (char *) hdr;
            f_desc = &(hdr->fld_desc[hdr->n_fields]);
        }
        hdr->n_fields++;
        f_desc->name = field;
        f_desc->type = type;
        f_desc->shortcode = MSG_SHORTCODE;
        f_desc->longcode = MSG_LONGCODE;
        f_desc->len = len;
    }

    /* update message access structure */
    iovarray->iov_len += sizeof(field_desc);
    vector->iov_len += padded_len;
    begin
    {
        register ftab_entry     *entry;

        entry = &(((ftab_entry *) msg->ftab_desc->addr)[msg->ftab_size]);
        if ((char *) (entry + 2) > msg->ftab_desc->addr + msg->ftab_desc->len)
        {
            msg_blockdouble (&msg->ftab_desc);
            entry = &(((ftab_entry *) msg->ftab_desc->addr)[msg->ftab_size]);
        }
        msg->ftab_size++;
        entry->name = field;
        entry->flag = FLAG_DATA;
        entry->block_index = blk_index;
        entry->len = len;
        entry->start = start;
        (++entry)->name = 0;
    }
    return (start);
 }


/* msg_unpkfields: Return an array of upto n pointers to the data in a    */
/*                 field, starting with instance first, and an arrray of  */
/*                 their lengths, if the last argument is non-zero.       */
/*                 Returns the number of fields actually found.           */
/* msg_getfield:   Same, but returns pointer to field */
msg_unpkfields (msg, field, first, n, dp, lenp)
  register message  *msg;
  register u_char   field;
  register          first;
  char              **dp;
  int               *lenp;

{
    register char           **datap;
    register ftab_entry     *ftab_ent;
    register field_desc     *f_desc;
    register int            inst, max;
    register int            index, found = 0;
    char                    *where = 0;

    if ((datap = dp) == (char**)0)
        datap = &where;
    if (field == msg->last_field && first >= msg->last_inst)
    {
        ftab_ent = (ftab_entry *) msg->ftab_desc->addr + msg->last_index;
        f_desc = ((header *) ((struct iovec *) 
                 msg->iov_desc->addr)->iov_base)->fld_desc + msg->last_index;
        inst = msg->last_inst - 1;
        index = msg->last_index;
    }
    else
    {
        ftab_ent = (ftab_entry *) msg->ftab_desc->addr;
        f_desc = ((header *)
                 ((struct iovec *) msg->iov_desc->addr)->iov_base)->fld_desc;
        inst = 0;
        index = 0;
    }

    inst -= first;
    max = n-1;
    while (inst < max && ftab_ent->name)
    {
        if ((u_char)ftab_ent->name == field)
            if (++inst >= 0)
            {
                msg_convertfield (ftab_ent->start, f_desc);
                datap[inst] = ftab_ent->start;
                if (lenp)
                    lenp[inst] = ftab_ent->len;
                found = index;
            }
        ftab_ent++;
        f_desc++;
        index++;
    }

    if (found)
    {
        msg->last_field = field;
        msg->last_inst = inst+first;
        msg->last_index = found;
    }

    if(dp)
        /* Normal case */
        return (inst + 1);
    /* msg_getfield case */
    return((int)where);
 }




/* msg_deletefield : Mark the given instance of a field as deleted */

msg_deletefield (msg, field, inst)
  message           *msg;
  register u_char   field;
  register int      inst;

{
    register ftab_entry     *ftab_ent;
    register field_desc     *fld_desc;

    ftab_ent = (ftab_entry *) msg->ftab_desc->addr;
    if (field == 0 || field == SYSFLD_DELETED)
    {
        printf ("msg_deletefield: invalid field name %d\n", field);
        fflush (stdout);
        return;
    }

    if (!msg_singleaccess (msg))
        msg_split (msg);

    if (msg->last_field == field)
        msg->last_field = msg->last_inst = msg->last_index = 0;

    fld_desc = ((header *)
                 ((struct iovec *) msg->iov_desc->addr)->iov_base)->fld_desc;
    while (inst > 0 && ftab_ent->name)
    {
        if (ftab_ent->name == field)
            if (--inst == 0)
            {
                ftab_ent->name = SYSFLD_DELETED;
                if (fld_desc->name != field)
                {
                    printf ("msg_deletefield: inconsistency in %s %x\n",
                                                   "header of message", msg);
                    fflush (stdout);
                    return;
                }
                fld_desc->name = SYSFLD_DELETED;
            }
        ftab_ent++;
        fld_desc++;
    }
}




/* msg_replacefield:  Replace the first instance of the given field with */
/*                    a new value, or add a new field if it does not     */
/*                    exist.  Returns a pointer to the changed field.    */
/* WARNING:           This routine must be used with care, as it could   */
/*                    change the order of fields, if there are more than */
/*                    field with the same name.                          */

char *
msg_replacefield (msg, field, data, type, len)
  register message  *msg;
  u_char            field;
  char              *data;
  short             type;
  int               len;

{
    register ftab_entry     *ftab_ent;
    register field_desc     *f_desc;
    register int            index;
    char                    *fp;

    if (field == 0 || field == SYSFLD_DELETED)
    {
        printf ("msg_replacefield: invalid field name %d\n", field);
        fflush (stdout);
        return (0);
    }

    if (!msg_singleaccess (msg))
        msg_split (msg);

    if (field == msg->last_field && msg->last_inst == 1)
    {
        ftab_ent = (ftab_entry *) msg->ftab_desc->addr + msg->last_index;
        f_desc = ((header *) ((struct iovec *) 
                 msg->iov_desc->addr)->iov_base)->fld_desc + msg->last_index;
        index = msg->last_index;
    }
    else
    {
        ftab_ent = (ftab_entry *) msg->ftab_desc->addr;
        f_desc = ((header *)
                 ((struct iovec *) msg->iov_desc->addr)->iov_base)->fld_desc;
        index = 0;

        while (ftab_ent->name && ftab_ent->name != field)
        {
            ftab_ent++;
            f_desc++;
            index++;
        }
    }

    if (ftab_ent->name)
    {
        if (ftab_ent->len == len)
        {
            bcopy (data, ftab_ent->start, len);

            f_desc->type = type;
            f_desc->shortcode = MSG_SHORTCODE;
            f_desc->longcode = MSG_LONGCODE;

            msg->last_field = field;
            msg->last_inst = 1;
            msg->last_index = index;

            fp = ftab_ent->start;
        }
        else
        {
            ftab_ent->name = f_desc->name = SYSFLD_DELETED;
            if (msg->last_field == field)
                msg->last_field = msg->last_inst = msg->last_index = 0;

            fp = msg_insertfield (msg, field, data, type, len);
        }
    }
    else
        fp = msg_insertfield (msg, field, data, type, len);

    return (fp);
}
