/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* task.h:  multitasking datastructures */

/* Task-related constants */
# define        words           *4              /* Bytes per word */
# define        kw              *4*1024         /* Bytes per k-word */

# define        TASKLEN         (4 kw)          /* size of task struct */
# define        STACKLEN        (TASKLEN-((int)((task*)0)->task_data)-(1 words))        /* size of stack area */

/* Signal disciplines */
# define        SD              0               /* Signal delayed */
# define        SU              1               /* Signal urgent */

#include <setjmp.h>

struct  task
{
        jmp_buf         task_env;                       /* saved registers */
        int             env_pad[16];                    /* setjmp buf may lack room */
        int             task_msgid;                     /* RPC msg id number */
        int             task_rval;                      /* To return from t_wait */
        int             (*task_routine)();              /* Routine called */
        char            *task_arg0;                     /* Arg passed */
        address         task_addr;                      /* Address for this task */
        message         *task_msg_arg;                  /* Message arg to routine, if any */
        condition       *task_queue;                    /* Waiting on this queue */
        bitvec          task_watching;                  /* Sites this task is watching */
        condition       task_cond;                      /* For waiting */
        condition       task_iwait;                     /* For waiting in iterated case */
        condition       task_mwant;                     /* Wants message */
        message         *task_msg;                      /* Special for indirect (iterated) addressing */
        queue           *task_msgs;                     /* Message we got */
        queue           *task_active;                   /* Node on active task queue */
        char            task_nwant;                     /* Number wanted */
        char            task_nreplies;                  /* Number so far */
        char            task_nullreps;                  /* Null reps, failures observes so far */
        char            task_nsent;                     /* Number of messages sent */
        char            task_nresp;                     /* ... answers received */
        char            *task_waitingfor;               /* Why I am waiting */
        char            *task_done;                     /* Used for pr_dump */
        address         *task_dests;                    /* Used for pr_dump */
        char            task_data[4];                   /* stack area */
};

/* Variables for managing the task table */
extern task     *ctp;                                   /* Current task */
condition       runqueue;                               /* Runqueue */
condition       tasks;                                  /* Task queue */

#define    task_dequeue(cp)  ((*cp == 0)? &scheduler: do_task_dequeue(cp))

