/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Queue management utilities
 */

struct  queue
{
        queue   *qu_next;
        queue   *qu_last;
        union
        {
          int           qu_isint;
          char          *qu_ischar;
          address       qu_isaddress;
          int           (*qu_isproc)();
        }       qu_nun;
        union
        {
          char          *qu_ischar;
          char          *qu_arechars[2];
          queue         *qu_arequeues[2];
          queue         *qu_isqueue;
          int           qu_isint;
          int           (*qu_isproc)();
          bitvec        qu_isbitvec;
          struct task   *qu_istask;
          condition     qu_iscond;
          address       qu_isdaddress;
          message       *qu_ismsg;
          mdesc         *qu_ismd;
          site_id       qu_issid;
          ioq           *qu_isioq;
          sys_groupview        *qu_issys_groupview;
          wait_item     qu_iswitem;
          char          *qu_aretimeargs[3];
        }       qu_dun;
        int     (*qu_freeroutine)();
        int     qu_flag;
};

/* Node names */
#define         qu_name         qu_nun.qu_isint
#define         qu_time         qu_nun.qu_isint
#define         qu_pname        qu_nun.qu_isaddress
#define         qu_sname        qu_nun.qu_ischar
#define         qu_string       qu_nun.qu_ischar
#define         qu_callback     qu_nun.qu_isproc

/* Data fields */
#define         qu_data         qu_dun.qu_ischar
#define         qu_args         qu_dun.qu_arechars
#define         qu_value        qu_dun.qu_isint
#define         qu_queue        qu_dun.qu_isqueue
#define         qu_queues       qu_dun.qu_arequeues
#define         qu_cond         qu_dun.qu_iscond
#define         qu_address      qu_dun.qu_isdaddress
#define         qu_msg          qu_dun.qu_ismsg
#define         qu_md           qu_dun.qu_ismd
#define         qu_bitvec       qu_dun.qu_isbitvec
#define         qu_sid          qu_dun.qu_issid
#define         qu_ioq          qu_dun.qu_isioq
#define         qu_proc         qu_dun.qu_isproc
#define         qu_task         qu_dun.qu_istask
#define         qu_pg           qu_dun.qu_issys_groupview
#define         qu_witem        qu_dun.qu_iswitem
#define         qu_timeargs     qu_dun.qu_aretimeargs

/* Aliased fields */
#define         qu_site         qu_address.site
#define         qu_incarn       qu_address.incarn
#define         qu_process      qu_address.process

/* Aliased routines */
queue   *qu_freelist, *qu_newqp;
extern  adesc qu_adesc;

#define qalloc()        ((queue*)mallocate(&qu_adesc))

#define qu_remove(qp)                                                   \
  {                                                                     \
        qp->qu_next->qu_last = qp->qu_last;                             \
        qp->qu_last->qu_next = qp->qu_next;                             \
        qp->qu_next = qp->qu_last = qp;                                 \
  }

#define qu_head(qp)  (((qp) && (qp) != (qp)->qu_next)? (qp)->qu_next: (queue*)0)

#define qu_alloc1(qp, name, d0, routine)                                \
  {                                                                     \
        if((qp = qu_head(qu_freelist)) == (queue*)0)                    \
            qp = qalloc();                                              \
        else                                                            \
        {                                                               \
             qp->qu_next->qu_last = qp->qu_last;                        \
             qp->qu_last->qu_next = qp->qu_next;                        \
        }                                                               \
        qp->qu_next = qp->qu_last = qp;                                 \
        qp->qu_string = (char*)name;                                    \
        qp->qu_args[0] = (char*)d0;                                     \
        qp->qu_freeroutine = routine;                                   \
  }


#define qu_alloc3(qp, name, d0, d1, d2, routine)                        \
  {                                                                     \
        if((qp = qu_head(qu_freelist)) == (queue*)0)                    \
            qp = qalloc();                                              \
        else                                                            \
        {                                                               \
             qp->qu_next->qu_last = qp->qu_last;                        \
             qp->qu_last->qu_next = qp->qu_next;                        \
        }                                                               \
        qp->qu_next = qp->qu_last = qp;                                 \
        qp->qu_string = (char*)name;                                    \
        qp->qu_args[0] = (char*)d0;                                     \
        qp->qu_args[1] = (char*)d1;                                     \
        qp->qu_args[2] = (char*)d2;                                     \
        qp->qu_freeroutine = routine;                                   \
  }


#define qu_allocpg(qp, pname, d0, routine)                              \
  {                                                                     \
        if((qp = qu_head(qu_freelist)) == (queue*)0)                    \
            qp = qalloc();                                              \
        else                                                            \
        {                                                               \
             qp->qu_next->qu_last = qp->qu_last;                        \
             qp->qu_last->qu_next = qp->qu_next;                        \
        }                                                               \
        qp->qu_next = qp->qu_last = qp;                                 \
        qp->qu_pname = pname;                                           \
        qp->qu_args[0] = (char*)d0;                                     \
        qp->qu_freeroutine = routine;                                   \
  }

#define qu_tnull(qp)                                                    \
  {                                                                     \
        if((qp = qu_head(qu_freelist)) == (queue*)0)                    \
            qp = qalloc();                                              \
        else                                                            \
        {                                                               \
             qp->qu_next->qu_last = qp->qu_last;                        \
             qp->qu_last->qu_next = qp->qu_next;                        \
        }                                                               \
        qp->qu_next = qp->qu_last = qp;                                 \
        qp->qu_freeroutine = nullroutine;                               \
  }

#define qu_append(qp, np)                                               \
  {                                                                     \
        register queue *op = qp->qu_last;                               \
        op->qu_next = np;                                               \
        np->qu_last = op;                                               \
        qp->qu_last = np;                                               \
        np->qu_next = qp;                                               \
  }

 
#ifdef SUN /* Everyone else has a compiler bug */ 
#define qu_free(qp)                                                     \
  {                                                                     \
        if(qp)                                                          \
        {                                                               \
            (qp->qu_next->qu_last = qp->qu_last)->qu_next = qp->qu_next;\
            if(qp->qu_freeroutine)                                      \
                (*qp->qu_freeroutine)(qp->qu_data);                     \
            begin                                                       \
            {                                                           \
                register queue *qf = qu_freelist;                       \
                if(qf == 0)                                             \
                    qu_freelist = qf = qu_null();                       \
                qp->qu_next = qf;                                       \
                (qp->qu_last = qf->qu_last)->qu_next = qp;              \
                qf->qu_last = qp;                                       \
            }                                                           \
        }                                                               \
  }
#else 
#define qu_free(qp)                                                     \
  {                                                                     \
        if(qp)                                                          \
        {                                                               \
            qp->qu_last->qu_next = qp->qu_next;                         \
            qp->qu_next->qu_last = qp->qu_last;                         \
            if(qp->qu_freeroutine)                                      \
                (*qp->qu_freeroutine)(qp->qu_data);                     \
            begin                                                       \
            {                                                           \
                register queue *qf = qu_freelist;                       \
                if(qf == 0)                                             \
                    qu_freelist = qf = qu_null();                       \
                qp->qu_next = qf;                                       \
                qf->qu_last->qu_next = qp;                              \
                qp->qu_last = qf->qu_last;                              \
                qf->qu_last = qp;                                       \
            }                                                           \
        }                                                               \
  }
#endif  

/* Simple aliased routines */
#define         qu_null()               qu_alloc(0,(char*)0,nullroutine)
#define         qu_alloc_qu(n,v,r)      qu_alloc(n,(char*)v,r)
#define         qu_add_qu(q,n,v)        qu_add(q,n,(char*)v,qu_freeall)
#define         qu_add_cond(q,n)        qu_add(q,n,(char*)0,nullroutine)
#define         qu_add_mp(q,n,v,r)      qu_add(q,n,(char*)v,r)
#define         qu_add_md(q,n,v,r)      qu_add(q,n,(char*)v,r)
#define         qu_add_proc(q,n,v,r)    qu_add(q,n,(char*)v,r)
#define         qu_add_tp(q,n,v)        qu_add(q,n,(char*)v,nullroutine)
#define         qu_add_ioq(q,n,v)       qu_add(q,n,(char*)v,nullroutine)
#define         qu_alloc_int(n,v)       qu_alloc(n,(char*)v,nullroutine)
#define         qu_alloc_tp(n,v)        qu_alloc(n,(char*)v,nullroutine)
#define         pg_add_sys_groupview(q,n,v,r)  pg_add(q,n,(char*)v,r)
#define         pg_add_qu(q,n,v)        pg_add(q,n,(char*)v,qu_freeall)

int     qu_freeall();
queue   *qu_alloc();
queue   *qu_find(), *pg_find(), *qu_add_bits();
queue   *qu_add(), *pg_add(), *qu_add_pg(), *qu_add_cb(), *qu_add_sid();
