/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#ifndef PR
#define PR

/* Must match with definition in clib/isis.h */
#ifdef  SUN3
# define SUN                1
# define UNIX_DOM           1
#endif
#ifdef  NEXT
# define UNIX_DOM           1
#endif
#ifdef  SUN4
# define SUN                1
# define UNIX_DOM           1
#endif
#ifdef  VAX
# define UNIX_DOM           1
#endif

#ifndef TRUE
#define TRUE                1
#define FALSE               0
#endif  TRUE

#define INCR_PRIO(prio)     (prio = (((((prio >> 8) + 1) & 0x7fffff) << 8) | \
                            (my_site_no & 0xff)))
#define PR_CBLAZY           -1
#define PR_CBURGENT         0

#define AB_DELIVERABLE      0x1
#define AB_UNDELIVERABLE    0x0
#define AB_GBCAST           0x2
#define AB_DELIV_GBCAST     (AB_DELIVERABLE | AB_GBCAST)
#define AB_UNDELIV_GBCAST   (AB_UNDELIVERABLE | AB_GBCAST)

#define GB_ABORT            -1
#define CHANGE_MODE          1
#define READ_MODE            2

/* Dump alternatives */
#define DUMP_ALL            0xFFFF
#define DUMP_MEM            0x0001
#define DUMP_VIEWS          0x0002
#define DUMP_INTERSITE      0x0004
#define DUMP_ASTORE         0x0008
#define DUMP_BCAST          0x0010
#define DUMP_CLIENT         0x0020
#define DUMP_MESSAGES       0x0040

/* For tracing */
#define PN_CBCAST           0
#define PN_ICBCAST          1
#define PN_ABCAST           2
#define PN_IABCAST          3
#define PN_GBCAST           4
#define PN_IGBCAST          5
#define PN_BCAST            6
#define PN_IBCAST           7
#define PN_REPLY            8
#define PN_CLIENT           9
#define PN_FBCAST           10
#define PN_IFBCAST          11

int     collect_answ();
extern char *proto_names[];

#define MC_ALLSITES         -1

#define MAX_PROCS           64
#define MAX_SITES           127         /* Also change in isis.h! */
#define MAXCQUEUE           32*1024     /* Max client backlog: 32kbytes */

/*
 *      Per-processor options:
 *          UNIX_DOM: TRUE if this system supports unix-domain IPC, which is
 *              faster than TCP in a single-site (but used to have a bug causing crashes
 *              if a process with a pending "connect" exited without doing the accept).
 *          SCATTER_SEND: Currently always false: seems to slow things down!
 */

#if (HPUX)
#include "sys/types.h"
#include "sys/file.h"
#include <memory.h>
#define random()        rand()
#define srandom(s)      srand(s)
#define bcopy(a,b,c)    memcpy(b,a,c)
#define bzero(a,b)      memset(a,0,b)
#endif

/* Congestion related parameters */
#define MEM_HI              500000      /* Memory usage is high */
#define MSGMEM_HI           500000      /* Message memory usage is high */
#define INTERSITE_HI       2000000      /* Intersite backlog is developing */
#define TASK_HI                 15      /* Number of active tasks is high */
#define MEM_LO              250000      /* Memory usage is ok */
#define MSGMEM_LO           250000      /* Message memory usage is ok */
#define TASK_LO                  6      /* Number of tasks is ok */
#define INTERSITE_LO        250000      /* Intersite backlog is clear */

#include "pr_typedefs.h"
#include "stdio.h"
#include "isis_alloc.h"
#include "bits.h"
#include "msg.h"
#include "pr_fdect.h"
#include "pr_msgfields.h"
#include "pr_inter.h"
#include "pr_pgroups.h"
#include "pr_wqueues.h"
#include "pr_queues.h"
#include "pr_qnode.h"
#include "pr_address.h"
#include "pr_astore.h"
#include "pr_errors.h"
#include "pr_task.h"
#include "pr_client.h"
#include "pr_global.h"
#include "pr_glocks.h"
#include "pr_stats.h"
#include "pr_msgtank.h"

#define forever             for(;;)
#define begin
#define NULLPRIO            0x80000000

int     (*nullroutine)();
int     pr_lastmsg, pr_lastbcast;
extern  long    ab_priority;

struct wait_struct
{
    int         n_events;
    condition   cond;
};
#define W_INIT(w_struct)    (w_struct).n_events = 0; \
                            (w_struct).cond = 0
#define W_WAIT(w_struct)    if ((w_struct).n_events > 0) \
                                t_wait (&((w_struct).cond), "W_WAIT")

adesc   *qu_adescp;
#endif  PR
