/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#ifndef     MSG
#define     MSG

#include    <sys/types.h>
#include    <netinet/in.h>

#ifndef     FILE
#include    <stdio.h>
#endif      FILE

#ifndef     UIO
#include    <sys/uio.h>
#define     UIO
#endif

#if             (HPUX)
#include    <memory.h>
#define     bcopy(a,b,c)        memcpy(b,a,c)
#define     bzero(a,b)          memset(a,0,b)
#endif

#include    "sysfields.h"

#ifndef     TRUE
#define     TRUE                1
#define     FALSE               0
#endif      TRUE

#define     NOT_LAZY            0
#define     LAZY_ALWAYS         1
#define     LAZY_IFLOCALDEST    2
#define     ULTRA_LAZY          3

#define     FWI_SENDER          0
#define     FWI_NEWDEST         1

#define     PADDED_LEN(len)     (((len) + 3) & ~0x3)

typedef     struct block_desc   block_desc;
struct      block_desc
{
            char                *addr;
            long                len;
            short               refcount;
            short               type;
            int                 bindex;
};
#define     BLK_ACCESS          1
#define     BLK_HEADER          2
#define     BLK_DATA            3
#define     BLK_HDRDATA         4
#define     BLK_FTAB            5
#define     BLK_IOVARRAY        6
#define     BLK_BODY            7
#define     BLK_AVAIL           8

typedef     struct ftab_entry   ftab_entry;
struct      ftab_entry
{
            short               name;
            u_char              flag;
            u_char              block_index;
            long                len;
            char                *start;
};
#define     FLAG_DATA           1
#define     FLAG_MSG            2
#define     FLAG_BROKENMSG      3

typedef     struct address      address;
struct      address
{
            union
            {
              short             u_process;
              short             u_groupid;
            } ad_un;
            short               portno;
            u_char              cluster;
            u_char              site;
            u_char              incarn;
            u_char              entry;
            u_char              type;
            u_char              pad0;
            u_char              pad1;
            u_char              pad2;
};
#define     process             ad_un.u_process
#define     groupid             ad_un.u_groupid

#define     ISAPID              0
#define     ISAGID              1
#define     ISACT               2

#define     addr_isnull(ad)         ((ad).site == 0)
#define     addr_isequal(a1,a2) (addr_cmp (a1, a2) == 0)
#define     addr_ismine(addr)   (addr_cmp (addr, my_address) == 0)

typedef     struct message      message;
struct      message
{
            int                 iovcnt;
            block_desc          *iov_desc;
            block_desc          *body_info;
            block_desc          *avail_desc;
            block_desc          *access_desc;
            long                ftab_size;
            block_desc          *ftab_desc;
            int                 fpointer;
            u_char              last_field;
            int                 last_inst;
            int                 last_index;
};

typedef     struct field_desc   field_desc;
struct      field_desc
{
            u_char              name;
            u_char              type;
            u_char              shortcode;
            u_char              longcode;
            long                len;        /* does not include padding   */
};

typedef     struct header       header;
struct      header
{
            long                len;      /* no. of bytes including header  */
            u_char              shortcode;
            u_char              longcode;
            u_short             n_fields; /* must ensure boundary alignment */
            field_desc          fld_desc[1];
};


/* Interface routines */
char        *msg_addfield();
int         msg_addmsg();
#define     msg_convertchar(c)
int         msg_convertshort();
int         msg_convertlong();
int         msg_convertsiteid();
int         msg_convertpgroup();
message     *msg_copy();
int         msg_delete();
int         msg_deletefield();
int         msg_dumpblocks();
int         msg_dumpmsgs();
message     *msg_fread();
int         msg_fwrite();
address     *msg_getdests();
address     msg_getsender();
address     msg_gettruesender();
char        *msg_getfield();
#define     msg_getfields(mp,f,dp,lp,n) \
                                msg_unpkfields (mp, f, 1, n, dp, lp)
message     *msg_getmsg();
#define     msg_getmsgs(mp,f,mps,n) \
                                msg_unpkmsgs (mp, f, 1, n, mps)
#define     msg_getid(mp)       (*(long *) msg_getfield((mp), SYSFLD_MSGID, \
                                                                 1, (int *) 0))
int         msg_gettype();
int         msg_increfcount();
message     *msg_newmsg();
int         msg_makelazy();
address     *msg_setdest(), *msg_setdests();

/* Field types */
#define     FTYPE_CHAR          0x80
#define     FTYPE_SHORT         0x81
#define     FTYPE_LONG          0x82
#define     FTYPE_ADDRESS       0x83
#define     FTYPE_SITEID        0x84
#define     FTYPE_PGROUP        0x85
#define     FTYPE_MESSAGE       0x86
#define     FTYPE_INTERSITE     0x87
#define     FTYPE_BITVEC        0x88
#define     FTYPE_GROUPVIEW     0x89
#define     FTYPE_EVENT         0x8A
#define     FTYPE_GLDESC        0x8B
#define     FTYPE_VERIFY        0x8C
#define     FTYPE_INTERCLIENT   0x8D

/* Special values that can be passed for <nwanted> and <alen> */
#define     ALL                 10000
#define     MAJORITY            10001
#define     AMESSAGE            -1
#define     ASTRING             -2
#define     AMALLOC             -3      /* Supported only in protos */

/* Dump levels */
#define     MSG_SMALLDUMP       0
#define     MSG_DUMPACCESS      0x1
#define     MSG_DUMPHEADER      0x2
#define     MSG_DUMPBOTH        0x3

/* Internal field types */
#define     FTYPE_USERLIMIT     0x7f
#define     FTYPE_BROKENMSG     0xff

/* Internal routines*/
block_desc  *msg_accessalloc();
block_desc  *msg_blockalloc();
int         msg_blockfree();
int         msg_blockdouble();
message     *msg_gen(), *msg_genmsg();
address     msg_getreplyto();
#define     msg_getiovec(mp)    ((struct iovec *) (mp)->iov_desc->addr)
#define     msg_getiovlen(mp)   ((mp)->iovcnt)
#define     msg_getlen(mp)      ntohl(((header *) ((struct iovec *) \
                                        (mp)->iov_desc->addr)->iov_base)->len)
int         msg_ismsg();
char        *msg_insertfield();
int         msg_printaccess();
int         msg_printblkdesc();
int         msg_printfield();
int         msg_printheader();
char        *msg_replacefield();
message     *msg_reconstruct();
#define     msg_setreplyto(mp,r) msg_replacefield ((mp), SYSFLD_REPLYTO, \
                                 (char *) (&r), FTYPE_ADDRESS, sizeof (address))
#define     msg_setsender(mp,s) msg_replacefield ((mp), SYSFLD_SENDER, \
                                 (char *) (&s), FTYPE_ADDRESS, sizeof (address))
#define     msg_isforwarded(mp) (msg_getfield(mp, SYSFLD_FORWARD, 1, 0) != (char*)0)
#define     msg_singleaccess(mp) (((block_desc **) \
                                    (mp)->body_info->addr)[0]->refcount == \
                                                   (mp)->access_desc->refcount)
#define     msg_singleblock(mp) (((block_desc **) \
                                (mp)->body_info->addr)[0]->type == BLK_HDRDATA)
#define     msg_getfield(mp,f,i,lp)     ((char*)msg_unpkfields(mp,f,i,1,0,lp))

int         msg_split();
char        *msg_typename();
int         msg_unpkfields();
int         msg_unpkmsgs();

/* Memory management info */
int         msg_usagestats, msg_tracemsgs, msg_tracecaller;
long        msg_namsgs, msg_nfmsgs;
long        msg_nalloc, msg_nfree, msg_memused, msg_memfree;
#define     MSG_TRACESIZE       512
block_desc  *alloc_blk[MSG_TRACESIZE];
message     *alloc_msg[MSG_TRACESIZE];
char        *callername();

/* Byte swapping info */
extern u_short  msg_shortmask;
extern u_long   msg_longmask;
#define         MSG_SHORTCODE   ((((u_char *) (&msg_shortmask))[0] << 2 | \
                                 ((u_char *) (&msg_shortmask))[1]) << 4)
#define         MSG_LONGCODE    (((((u_char *) (&msg_longmask))[0] << 2 | \
                                 ((u_char *) (&msg_longmask))[1]) << 2 | \
                                 ((u_char *) (&msg_longmask))[2]) << 2 | \
                                 ((u_char *) (&msg_longmask))[3])

/* Site info */
extern address  my_address;
extern int      my_site_no;
extern int      my_site_incarn;
extern int      my_process_id;

#endif  MSG
