/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */

#ifndef PR_ALLOC
#define PR_ALLOC
/*  general purpose memory allocation/deallocation mechanism */

typedef    struct adesc    adesc;
typedef    struct chunk    chunk;

struct chunk
{
        chunk   *c_next;                /* Next chunk */
        char    *c_first;               /* First byte of this chunk */
        char    *c_last;                /* Last byte of this chunk */
        long    c_inuse;                /* Bitmap of items in use */
};

struct adesc
{
        long    a_isize;                /* Item size */
        long    a_izero;                /* Amount to zero */
        short   a_nalloc;               /* Number to allocate at a time (32 max) */
        long    a_flags;                /* Flags */
        chunk   *a_chunks;              /* To list of chunks */
        chunk   *a_notfull;             /* To a chunk that isn't full */
        int     a_nmalloc;              /* Number of mallocs done */
        int     a_nmfree;                /* Number of mallocs done */
};

#define A_INIT  0x01                    /* Set after first time */

char *mallocate ();

int     nalloc, nfree, memused, memfree, memalloc;

#endif PR_ALLOC
