/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      ISIS guarded bcast implementation
 */


struct  event_id
{
        int     e_msgid;                /* Event corresponds to this message  */
        int     e_op;                   /* Operation name */
        address e_pname;                /* Process */
};

struct  gnode 
{
        short   n_type;                 /* Node type */
        short   n_flag;                 /* Node flag */
        etree   *n_etree;               /* Etree this node was generated on behalf of */
        gnode   *n_chain;               /* Next node in chain */

        /* For nodes of all types other than patterns */
        gnode  *n_left;                 /* Left side */
        gnode  *n_right;                /* Right side */

        /* For patterns */
        event_id n_pat;                  /* Opname, mapped using local map */
};

#define G_EVAL_T       0x01             /* Subtree was evaluated as true */

/* Node names for expression nodes */
#define G_AFTER        1               /* after(e) g */
#define G_AND          2               /* g and g' */
#define G_OR           3               /* g or g' */
#define G_TIMEOUT      4               /* timeout(ticks) */
#define G_ARG          5               /* %? */
#define G_PATTERN      6               /* [p,opname] */
#define G_OP           7               /* %e.op */
#define G_OPNAME       8               /* opname in pattern */
#define G_ATOM         9               /* Used on expr queue to point to node on pats queue */
#define G_TRUE         10              /* True always */

/* Node flags */
#define G_EVAL_TRUE     0x01            /* Was evaluated to true already */

struct  etree
{
        event_id et_eid;                /* Event id */
        gnode   *et_expr;               /* Expression subtree */
        message *et_msg;                /* Message */
        short    et_flag;               /* Etree flags */
        short    et_entry;              /* Entry to invoke */
        gnode   *et_nodes;              /* Chain of nodes for this etree */
        ginfo   *et_gp;                 /* Group to which this belongs */
};

#define ET_NEED_EVAL    0x01            /* Must re-evaluate */
#define ET_DOING_INVOKE 0x02            /* Doing invocation */
#define ET_INHIBIT      0x04            /* Inhibiting joins */

typedef struct  timenode timenode;

struct  timenode
{
        int     to_flag;
        gnode   *to_nd;
        etree   *to_etree;
};

etree   *g_etree;                       /* Pointer to top node on the expression tree */
int     parse_error;
int     pre_parsing;
int     inv_level;
int     cur_op;
