/* cl_xaction.h */
/* The x_id struct is defined in cl_typedefs.h */

#define xid_cmp(id1, id2) addr_cmp(id1, id2)
  /* Returns 0 if id1 and id2 are equal,
           > 0 if id1 is "greater than" id2,
       and < 0 if id1 is "less than" id2.
     x_id_cmp is NOT A SERIALIZATION ORDERING on transactions!!!
     It's intended for equality tests, and as a key in sorting and table
     lookup.
  */

/* Of the following defines, only X_PREPARE, X_COMMIT, and X_ABORT are seen by
   client programmers. The rest are used internally by the transaction tool. */
#define X_COMPUTING -1/* Transaction in progress (i.e. after x_begin but before
                        x_commit or x_abort). */
#define X_PREPARE   0 /* In phase 1 of a 2 phase commit. */
#define X_COMMIT    1 /* Committed, but not necessarily all participants
                        know this yet. */
#define X_ABORT     2 /* Aborted, but not necessarily all participants know yet. */
#define X_FINISHED  3 /* All participants know the outcome, so we can
                         delete information about this transaction. */

/* An x_item describes the eventual outcome of a transaction to a participant
   that failed during transaction termination. */
typedef struct {
    x_id id; 
    int outcome;    /* One of X_COMMIT or X_ABORT. */
    message *info;  /* Participant supplied data. */
} x_item;

/* An x_list is returned by the x_outcomes routine and contains x_items for
   every transaction for which the participant may not have been informed
   of the outcome. */
typedef struct {
    int len;
    x_item items[1];
} x_list;

#define xlog_subdir "translogs"   /* Subdirectory for transaction logs. */
#define xmgr_service "XMGR-service" /* Used for group name and log file name. */
#define XR_SAVE_OUTCOME 1        /* Messages handled by recovery manager. */
#define XR_GET_OUTCOME 2

#ifndef     TRUE
#define     TRUE                1
#define     FALSE               0
#endif      TRUE

#ifndef     bool
#define     bool                int
#endif

x_id x_getid(); 
int x_begin();
int x_commit( /* int phases */ );
int x_abort();
int x_term( /* char *participant_name,
               ifunc *on_prepare, ifunc *on_commit, ifunc *on_abort,
               char *fmt, arg1, arg2, ... */ );
x_list *x_outcomes( /* char *part_name */ );
void x_outcomes_flush ( /* char *part_name, x_list *outcomes */ );
