/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* task.h:  multitasking datastructures */

/* Task-related constants */
# define        words           *4              /* Bytes per word */
# define        kw              *4*1024         /* Bytes per k-word */
# define        DEF_TASKLEN         (4 kw)          /* size of task struct */

/* Signal disciplines */
# define        SD              0               /* Signal delayed */
# define        SU              1               /* Signal urgent */

#include <setjmp.h>

struct  task
{
        jmp_buf         task_env;                       /* Saved registers */
        int             env_pad[16];                    /* Some jmp_bufs are too small */
        event_id        task_eid;                       /* Current event id */
        int             task_msgid;                     /* RPC msgid number */
        int             task_ccmsgid;                   /* msgid number for cc_terminate */
        int             task_rval;                      /* To return from t_wait */
        int             (*task_routine)();              /* Routine called */
        int             task_sleep;                     /* How long? */
        int             task_entry;                     /* Entry number, if any */
        short           task_act;                       /* Activity id for this task, if any */
        short           task_flag;                      /* flags */
        char            *task_arg0;                     /* Arg passed */
        address         task_addr;                      /* Address of this task */
        message         *task_msg_arg;                  /* Message arg to routine, if any */
        condition       *task_queue;                    /* Waiting on this queue */
        bitvec          task_watching;                  /* Sites this task is watching */
        condition       task_cond;                      /* For waiting */
        char            *task_waitingfor;               /* Why waiting */
        condition       task_mwant;                     /* Wants message */
        message         *task_msg;                      /* Special for indirect (iterated) addressing */
        queue           *task_msgs;                     /* Message we got */
        queue           *task_active;                   /* Node on active task queue */
        address         *task_cohorts;                  /* Cohort list, if in cc alg. */
        address         task_truesender;                /* Also for cc alg */
        char            task_data[4];                   /* stack area, normal case */
};

/* Field names for queue nodes */
#define TA_ISTASK               1

/* Variables for managing the task table */
task                   *do_task_dequeue();
extern task            *isis_ctp;                      /* Current task */
condition              isis_runqueue;                  /* Runqueue */
condition              isis_tasks;                     /* Task queue */
#define                my_eid                          isis_ctp->task_eid

/* Macros for fork routines */
# define t_fork(routine, arg)           isis_fork(routine, arg, NULLMP)
# define t_fork_urgent(routine, arg)    isis_fork_urgent(routine, arg, NULLMP)
# define t_fork_msg(routine, mp)        isis_fork(routine, mp, mp)
# define t_fork_urgent_msg(routine, mp) isis_fork_urgent(routine, mp, mp)

# define t_waiting(condp)               ((*(condp)) != 0)

#define TASK_START      0x01                            /* Set for the startup task */
#define TASK_LOGGED     0x02                            /* Set if logged */
#define TASK_INHIBIT    0x04                            /* Set if inhibits joins */
#define TASK_CONGESTED  0x08                            /* Congested and waiting */

#define    task_dequeue(cp)  ((*cp == 0)? &isis_scheduler: do_task_dequeue(cp))
