/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* cl_rmgr.h:  recovery manager */


/*********************************************************************
*
*  Process Restart Tool
*
*********************************************************************/

#define RMLEN 40

extern  int  rmgr_update     (/* char  *key, *program, *argv[], *envp[]; */);
extern  int  rmgr_register   (/* char  *key; */);
extern  int  rmgr_unregister ();

/* error codes */
#define RM_ELOCKED    1         /* the rmgr.rc file is locked */
#define RM_ENOTFOUND  2         /* pgroup not found in rmgr.rc file */


/*********************************************************************
*
*  Pgroup View Log Tool
*
*********************************************************************/

typedef struct {
            int        rm_mode;         /* restart mode (see below) */
            char       rm_key[RMLEN];   /* key */
            groupview  rm_view;         /* local view before proc/site crash */
        } rmgr_info;

typedef struct {
            char       rl_key[RMLEN];   /* key */
            groupview  rl_view;         /* local view log */
        } rmgr_viewlog;


extern  int         rmgr_start_log (/* address gaddr; char *key */);
extern  int         rmgr_stop_log  (/* address gaddr; char *key */);
extern  rmgr_info  *rmgr_getinfo   (/* char *gname; int noblock */);
extern  int         rmgr_lasttofail(/* char *gname; char *key; int noblock */);

/* restart mode: bitvector in which the following flags are set: */
#define RM_LOG    0x01  /* pgview was read from view-log file into rm_view */
#define RM_RECENT 0x02  /* rm_view is the most recent view of the group */
#define RM_SURE   0x04  /* RM_RECENT info is reliable */


/*********************************************************************
*
*  Pgroup Restart Tool
*
*********************************************************************/
extern  int  rmgr_optv;

extern  address  rmgr_create  (/* rmgr_info *rmi; */);
extern  address  rmgr_join    (/* rmgr_info *rmi;  message *mp; */);
extern  address  rmgr_restart (/* char *pgname; */);

extern  void  rmgr_mh_rmnews();
extern  void  rmgr_mh_rmup();
#define rmgr_init() isis_entry(GENERIC_RM_UP, rmgr_mh_rmup, "rmgr_mh_rmup"); \
                    isis_entry(GENERIC_RM_NEWS,rmgr_mh_rmnews,"rmgr_mh_rmnews")
