/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Front end program for playing twenty questions
 */

#include "isis.h"
#include "twenty.h"

int     verbose;
int     CLIENT_PORT;

main(argc, argv)
  char **argv;
  {
        int ask_questions();

        while(argc-- > 1)
            switch(**++argv)
            {
              case '-':
                switch(*++*argv)
                {
                  case 'v': ++verbose;   continue;
                  default:  printf("-%c: unknown option\n", **argv); continue;
                }
              case '0': case '1': case '2': case '3': case '4':
              case '5': case '6': case '7': case '8': case '9':
                CLIENT_PORT = atoi(*argv);
                continue;
            }

        /* Connect to ISIS */
        isis_init(CLIENT_PORT);
        
        isis_mainloop(ask_questions);
  }

int     delay[]
={
        2, 2, 2, 2, 2, -1
};

ask_questions()
  {
        int cat, class;
        char string[120];
        register char *sp;
        register c;
        address gid;

        isis_start_done();
        gid = pg_lookup("twenty");
        if(addr_isnull(gid))
            panic("twenty-questions asker -- can't connect to database program");
        pg_client(gid, "qa");
        printf("Welcome to... twenty questions!\nQuery categories are... ");
        begin
        {
            register n;
            static nretries;
            char cnames[NFIELDS][STRLEN];
            bzero(cnames, sizeof(cnames));
            while(cbcast(gid, TWENTY_HELLO, "", 1, "%C", cnames, (int*)0) != 1)
                if(++nretries > 2)
                    panic("Twenty questions service has been shut down!");
            for(n = 0; n < NFIELDS; n++)
                if(*cnames[n])
                    print("%s ", cnames[n]);
        }
        print("\n\nEnter a random number: ");
        sp = string;
        while((c = getchar()) != '\n')
            *sp++ = c;
        *sp = 0;
        cat = atoi(string);
        printf("Enter `* query' or `query'...\n");
        forever
        {
            int nrep = 1;
            print("? ");
            c = getchar();
            if(c <= 0)
            {
		print("... exiting (but leaving twenty running)\n");
                exit(0);
	    }
            if(c == '\n')
                continue;
            if(c == '*')
            {
                class = 'H';
                c = getchar();
            }
            else if(c == '@')
            {
                class = 'H';
                c = getchar();
                nrep = 50;
            }
            else
                class = 'V';
            sp = string;
            do
            {
                if(c != ' ' && c != '\t')
                    *sp++ = c;
            }
            while((c = getchar()) != '\n');
            *sp = 0;
            if(sp == string)
                continue;
            while(nrep--)
            {
                register nwant, nrep, n, i;
                static int who[NMEMBER+1];
                static int rep[NMEMBER+1];
                nwant = (class == 'H')? NMEMBER: 1;
                n = 0;
                while((nrep = cbcast(gid, TWENTY_QUERY, "%d,%d,%s", cat, class, string,
                    nwant, "%d,%d", who, rep)) != nwant)
                {
                    if(nrep == 0)
                        panic("twenty questions service has been shut down");
                    if(n == 0)
                        print("twenty questions service is restarting... please be patient\n");
                    else if(delay[n] < 0)
                        break;
                    sleep(delay[n++]);
                    print("... retrying\n");
                }
                if(nrep != nwant)
                    panic("twenty questions service has failed!");
                for(n = 0; n < nrep; n++)
                {
                    register i = 0;
                    if(class == 'H')
                        while(who[i] != n && i < nrep)
                            i++;
                    switch(rep[i])
                    {
                      case 'F':
                        print("<field unknown> ");
                        continue;
                      case 'Y':
                        print("yes ");
                        continue;
                      case 'N':
                        print("no ");
                        continue;
                      case '?':
                        print("sometimes ");
                        continue;
                      default:
                        print("<something went wrong>");
                        continue;
                    }
                }
                print("\n");
            }
        }
  }
