/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
%{
/******************************************************************************
 *  pp_yacc.y : compiler for compiling isis_pre specification files into
 *              C source code files.
 *
 *  by : Cheong, Weng Seng
 *       Dept of Computer Science
 *       Cornell University
 *
 *****************************************************************************/
%}
%union  {
        struct { 
                char *text; 
                int len;
        } v;
        int     freq;
}

%token  <v> RPC_STATEMENT NORMAL_TEXT INIT_RPC RET_VAL IDENT_EQUAL CONTROL_STAT 
%token  <v> FUNC_NAME IDENT BROADCAST INTG DECIMAL EXPR 
%token  <v> LIB_NAME  
%token  <v> RIGHT_CURLY LEFT_CURLY ARROW DOUBLE_DOLLAR 
%type   <v> var_name 

%{
/* reserved words */
%}
%token  <v> USES REPLY LIBRARY REGISTER NULLREPLY ABORTREPLY
%token  <freq> ENTRY IMPORT EXPORT IM_EXPORT

%start  input

%{
#include <stdio.h>
#include <strings.h>
#include "pp_const.h"
#include "pp_global.h"
#include "pp_info.e"
#include "pp_patch.e"
#include "pp_yacc_msg.h"

typedef struct {
        int     len;
        char    *strptr;
        bool    reg_var;
}vartype_t;

static vartype_t vartype = {0, NULL};
static FILE     *switchfile;            /* variable stream dependent on the 
                                         * value of pp_mode */
static char     func_name[PP_MAX_FUNCTION_CHAR],
                *funcptr = func_name;   /* function name buffer */
static char type_temp[PP_MAX_TYPE_CHAR];

%}

%%
input           :       statement
                |       input statement
                ;

statement       :       ENTRY
                                { switch(pp_mode) {
                                  case PP_NORMAL:
                                        /* wrong input file type */     
                                        yyerror(PP_ONLY_L_FILE_MSG);
                                        break;
                                  case PP_MAKELIB:
                                        break;
                                  }
                                }
                        rpc_decl
                                { switch(pp_mode) {
                                  case PP_NORMAL:       
                                        SyncLineNorm1();
                                        break;
                                  case PP_MAKELIB:      
                                        SyncLineLib1(PP_RCV);
                                        break;
                                  }
                                }
                |       DOUBLE_DOLLAR 
                                { switch(pp_mode) {
                                  case PP_NORMAL: switchfile = pp_cfile; break;
                                  case PP_MAKELIB: switchfile = pp_rcvfile; break;
                                  }
                                }       
                        rpc_call
                |       NORMAL_TEXT     
                                { switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        fprintf(pp_rcvfile, "%s", $1.text);
                                        break;
                                  case PP_NORMAL: 
                                        fprintf(pp_cfile, "%s", $1.text);
                                        break;
                                  }
                                }
                |       INIT_RPC
                                { switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        yyerror(PP_INIT_RPC_MISPLACED_MSG);     
                                        SyncLineLib2(PP_ALL);
                                        break;
                                  case PP_NORMAL:
                                        fprintf(pp_cfile, "\n#include \"%s.m\"\n",
                                                pp_genname);
                                        pp_mfile_included = PP_TRUE;
                                        SyncLineNorm1();        
                                        break;
                                  }
                                }
                |       CONTROL_STAT
                                { switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        fprintf(pp_rcvfile, $1.text);
                                        fprintf(pp_callfile, $1.text);
                                        break;
                                  case PP_NORMAL:
                                        fprintf(pp_cfile,$1.text);
                                        break;
                                  }
                                }

                |       EXPORT
                                { switch(pp_mode) {
                                  case PP_NORMAL:
                                        if($1 && !pp_shfile_included){
                                                fprintf(pp_cfile, "\n#include\
 \"%s.sh\"", pp_genname); 
                                                pp_shfile_included = PP_TRUE;
                                        }
                                        break;
                                  case PP_MAKELIB:      
                                        yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                        break;
                                  }
                                }
                        export_decl 

                |       IMPORT 
                                { switch(pp_mode) {
                                  case PP_NORMAL:       
                                        if($1 && !pp_shfile_included){
                                                fprintf(pp_cfile, "\n#include\
 \"%s.sh\"", pp_genname);       
                                                pp_shfile_included = PP_TRUE;
                                        }
                                        break;
                                  case PP_MAKELIB:      
                                        yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                        break;
                                  }
                                }
                        import_decl

                |       IM_EXPORT
                                { switch(pp_mode) 
                                    {
                                    case PP_NORMAL:
                                      if($1 && !pp_shfile_included)
                                        {
                                          fprintf(pp_cfile, "\n#include \"%s.sh\"", 
                                                  pp_genname);
                                          pp_shfile_included = PP_TRUE;
                                        }
                                      break;
                                    case PP_MAKELIB:
                                      yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                      break;
                                    }
                                }
                        im_export_decl
                ;
        
rpc_decl        :       rpc_header
                                { if (pp_mode == PP_MAKELIB) {
                                        SyncLineLib2(PP_CALL);
                                        CallModule1(); 
                                        SyncLineLib1(PP_CALL); 
                                  }
                                }
                        rpc_var
                                { if (pp_mode == PP_MAKELIB) {
                                        CallModule2();
                                        RcvModule1(); 
                                  }
                                }
                        LEFT_CURLY
                                { if (pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile,"{");
                                        RcvModule2();
                                        SyncLineLib1(PP_RCV); 
                                  }
                                }
                        rpc_body
                        RIGHT_CURLY
                                { if (pp_mode == PP_MAKELIB) 
                                        fprintf(pp_rcvfile, "%s\n", $8.text); }  
                |       error RIGHT_CURLY
                                { yyerrok; }
                ;

rpc_call        :       resp_store FUNC_NAME  
                                { fprintf(switchfile, "%s_call(", $2.text); }
                        '(' arglist ')' '@' addrlist ans_store ';'
                                { fprintf(switchfile, ";"); }
                |       error ';' 
                                { yyerrok; }
                ;
                                
rpc_header      :       func_type 
                                { ; }
                        FUNC_NAME 
                                { if (pp_mode == PP_MAKELIB) {
                                        if(insertinfo($3.text, $3.len, PP_F_NAME)
 != PP_OK) fprintf(stderr, PP_INS_FUNC_MSG1, pp_lineno,$3.text);
                                  } 
                                }
                        '(' paramlist ')' USES BROADCAST
                                { if (pp_mode == PP_MAKELIB) {
                                        if(insertinfo($9.text, $9.len, PP_B_TYPE)
 != PP_OK) fprintf(stderr, PP_INS_BCAST_MSG, pp_lineno,$9.text); 
                                  }
                                }
                ;

rpc_var         :       /* empty */
                |       vardecls
                ;

rpc_body        :       /* empty */
                |       rpc_body rpc_reply 
                |       rpc_body rpc_statements 
                |       rpc_body rpc_nullreply 
                |       rpc_body rpc_abortreply
                ;

rpc_reply       :       REPLY 
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_rcvfile, "%s", $1.text);
                                }
                        '(' RET_VAL 
                                { if(pp_mode == PP_MAKELIB)
                                        RcvModule3($4.text); 
                                }
                        ';'
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, ";\n");
                                        SyncLineLib1(PP_RCV); 
                                  }
                                }
                ;

rpc_abortreply  :       ABORTREPLY
                                { if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, "%s", $1.text);
                                      fprintf(pp_rcvfile, "abortreply(pp_msg_p)");
                                    }
                                }
                        ';'
                                { if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, ";\n");
                                    }
                                }
                ;

rpc_nullreply   :       NULLREPLY
                                { if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, "%s", $1.text);
                                      fprintf(pp_rcvfile, "nullreply(pp_msg_p)");
                                    }
                                }
                        ';'
                                { if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(pp_rcvfile, ";\n");
                                    }
                                }
                ;

vardecls        :       registr IDENT
                                { if(pp_mode == PP_MAKELIB) {
                                        vartype.strptr  = store_paratype($2.text, 
                                                vartype.len = $2.len);
                                        fprintf(pp_callfile, "\t%s\t", $2.text); 
                                  }
                                }
                        var_list ';'
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, ";"); 
                                        init_vartype();
                                   }
                                }
                |       vardecls 
                        registr IDENT
                                { if(pp_mode == PP_MAKELIB) {
                                        vartype.strptr = store_paratype($3.text, 
                                                vartype.len = $3.len);
                                        fprintf(pp_callfile, "\t%s\t", $3.text); 
                                  }
                                } 
                        var_list ';'
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, ";"); 
                                        init_vartype();
                                  }
                                }
                ;

registr         :       /* empty */

                |       REGISTER
                                { if (pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, "\tregister\t");
                                        vartype.reg_var = PP_TRUE;
                                  }
                                }

func_type       :       /* empty */
                                { if(pp_mode == PP_MAKELIB) {
                                        if(insertinfo("int", 3, PP_F_TYPE) !=
PP_OK)fprintf(stderr,PP_INS_FUNC_MSG2, pp_lineno); 
                                  }
                                }
                |       IDENT 
                                { if(pp_mode == PP_MAKELIB) {
                                        if(insertinfo($1.text, $1.len, PP_F_TYPE)
!= PP_OK) fprintf(stderr, PP_INS_FUNC_MSG3, pp_lineno, $1.text); 
                                  }
                                }
                |       IDENT '*'
                                { if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(stderr, PP_PTR_MSG1, pp_lineno);
                                      if(insertinfo("<ERROR>", 7, PP_F_TYPE) != PP_OK) 
                                        fprintf(stderr,PP_INS_FUNC_MSG3,pp_lineno, "<ERROR>"); 
                                    }
                                }
                ;
                
paramlist       :       /* empty */
                |       identlist
                ;

identlist       :       IDENT
                                { if(pp_mode == PP_MAKELIB) {
                                        if (insertparameter($1.text, $1.len) !=
PP_OK) fprintf(stderr,PP_PARA_TRUNC_MSG, pp_lineno,$1.text); 
                                  }
                                }
                        identmore
                ;

identmore       :       /* empty */
                |       identmore ',' IDENT     
                                { if(pp_mode == PP_MAKELIB) {
                                        if (insertparameter($3.text, $3.len) !=
PP_OK) fprintf(stderr,PP_PARA_TRUNC_MSG, pp_lineno,$3.text); 
                                  }
                                }
                ;

var_list        :       var_name 
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "%s", $1.text); }
                        var_listmore
                |       var_name 
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "%s", $1.text); }
                        '[' array_size ']'
                                { ; }
                        var_listmore
                ;

var_listmore    :       /* empty */
                |       var_listmore ',' 
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, ","); } 
                        var_name
                                { if (pp_mode == PP_MAKELIB)
                                    fprintf(pp_callfile, " %s", $4.text);}

                |       var_listmore ',' 
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, ","); }
                        var_name
                                { if (pp_mode == PP_MAKELIB)
                                    fprintf(pp_callfile, " %s", $4.text);}
                        '[' array_size ']'
                                { ; }
                ;

var_name        :       IDENT
                                { if(pp_mode == PP_MAKELIB) {
                                        if(insert_paratype($1.text,vartype.strptr,
vartype.len, vartype.reg_var) != PP_OK) {
                                               fprintf(stderr,PP_VAR_NOT_DECL_MSG,
pp_lineno, $1.text); 
                                        }
                                        $$ = $1;
                                  }
                                }
                |       '*' IDENT
                                { if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(pp_callfile, " *");
                                      sprintf(type_temp, "%s%c", vartype.strptr, '*');
                                      if (insert_paratype($2.text, type_temp, vartype.len + 1,
                                                          vartype.reg_var) != PP_OK)
                                        {
                                          fprintf(stderr,PP_VAR_NOT_DECL_MSG,pp_lineno, $2.text);
                                        }
                                        $$ = $2; 
                                  }
                                }
                ;
                
array_size      :       /* empty */
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(stderr, PP_PTR_MSG3, pp_lineno);
                                        fprintf(pp_callfile, "[]"); 
                                  }
                                }
                |       INTG
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "[%s]", $1.text); }
                |       IDENT
                                { if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "[%s]", $1.text); }
                ;

rpc_statements  :       RPC_STATEMENT  ';'
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, "%s", $1.text);
                                        fprintf(pp_rcvfile, ";");
                                  }
                                }
                        rpc_statementmore
                ;

rpc_statementmore
                :       /* empty */
                |       rpc_statementmore 
                        RPC_STATEMENT ';'
                                { if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, "%s", $2.text); 
                                        fprintf(pp_rcvfile, ";");
                                  }
                                }
                ;

resp_store      :       /* empty */
                                { yyerror(PP_RPC_RETURN_IGN_MSG); }
                |       IDENT_EQUAL
                                { fprintf(switchfile, "%s ", $1.text); }
                ;
                
arglist         :       /* empty */
                |       exprlist
                ;

exprlist        :       EXPR 
                                { fprintf(switchfile, "%s", $1.text); }
                        exprmore
                ;

exprmore        :       /* empty */
                |       exprmore ',' EXPR 
                                { fprintf(switchfile, ", %s", $3.text); }
                ;       

addrlist        :       '(' EXPR ')'
                                { fprintf(switchfile, ", %s", $2.text); }
                ;
                
ans_store       :       /* empty */
                                { fprintf(switchfile, ",0,NULL)"); }
                |       ARROW  '(' EXPR 
                                { fprintf(switchfile, ", %s", $3.text); }
                        ',' EXPR 
                                { fprintf(switchfile, ", %s", $6.text); }
                        ')'   
                                { fprintf(switchfile, ")"); }
                ;

export_decl     :       LIBRARY '<' LIB_NAME '>'
                                { if(pp_mode == PP_NORMAL) 
                                    {
                                      SyncLineNorm2();
                                      if(LibraryModule1($3.text,PP_FROM_EXPORT) != PP_OK)
                                                yyerror(PP_CANT_READ_FN_MSG);
                                  } 
                                }
                ;

import_decl     :       LIBRARY '<' LIB_NAME '>'
                                { if(pp_mode == PP_NORMAL) {
                                        SyncLineNorm2();
                                        if(LibraryModule1($3.text, PP_FROM_IMPORT) 
                                           != PP_OK)
                                                yyerror(PP_CANT_READ_FN_MSG);
                                  } 
                                }
                ;

im_export_decl  :       LIBRARY '<' LIB_NAME '>'
                                { if(pp_mode == PP_NORMAL) 
                                    {
                                      SyncLineNorm2();
                                      if(LibraryModule1($3.text, PP_FROM_IM_EXPORT)
                                         != PP_OK)
                                        yyerror(PP_CANT_READ_FN_MSG);
                                    }
                                }
                ;
                                  
%%
yyerror(s)
        char    *s;
{
        fprintf(stderr,"line %d: ", pp_lineno);
        sys_error("%s ", s);
}

yywrap()        
{
        write_fnfile();
        return 1;
}

void    init_vartype()
{
        if(vartype.strptr != NULL) {
                vartype.strptr = NULL;
                vartype.len = 0;
                vartype.reg_var = PP_FALSE;
        }
}
