/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */

# line 2 "../../isis_pre/pp_yacc.y"
/******************************************************************************
 *  pp_yacc.y : compiler for compiling isis_pre specification files into
 *              C source code files.
 *
 *  by : Cheong, Weng Seng
 *       Dept of Computer Science
 *       Cornell University
 *
 *****************************************************************************/

# line 12 "../../isis_pre/pp_yacc.y"
typedef union   {
        struct { 
                char *text; 
                int len;
        } v;
        int     freq;
} YYSTYPE;
# define RPC_STATEMENT 257
# define NORMAL_TEXT 258
# define INIT_RPC 259
# define RET_VAL 260
# define IDENT_EQUAL 261
# define CONTROL_STAT 262
# define FUNC_NAME 263
# define IDENT 264
# define BROADCAST 265
# define INTG 266
# define DECIMAL 267
# define EXPR 268
# define LIB_NAME 269
# define RIGHT_CURLY 270
# define LEFT_CURLY 271
# define ARROW 272
# define DOUBLE_DOLLAR 273

# line 27 "../../isis_pre/pp_yacc.y"
/* reserved words */
# define USES 274
# define REPLY 275
# define LIBRARY 276
# define REGISTER 277
# define NULLREPLY 278
# define ABORTREPLY 279
# define ENTRY 280
# define IMPORT 281
# define EXPORT 282
# define IM_EXPORT 283

# line 35 "../../isis_pre/pp_yacc.y"
#include <stdio.h>
#include <strings.h>
#include "pp_const.h"
#include "pp_global.h"
#include "pp_info.e"
#include "pp_patch.e"
#include "pp_yacc_msg.h"

typedef struct {
        int     len;
        char    *strptr;
        bool    reg_var;
}vartype_t;

static vartype_t vartype = {0, NULL};
static FILE     *switchfile;            /* variable stream dependent on the 
                                         * value of pp_mode */
static char     func_name[PP_MAX_FUNCTION_CHAR],
                *funcptr = func_name;   /* function name buffer */
static char type_temp[PP_MAX_TYPE_CHAR];

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 522 "../../isis_pre/pp_yacc.y"

yyerror(s)
        char    *s;
{
        fprintf(stderr,"line %d: ", pp_lineno);
        sys_error("%s ", s);
}

yywrap()        
{
        write_fnfile();
        return 1;
}

void    init_vartype()
{
        if(vartype.strptr != NULL) {
                vartype.strptr = NULL;
                vartype.len = 0;
                vartype.reg_var = PP_FALSE;
        }
}
short yyexca[] ={
-1, 1,
        0, -1,
        -2, 0,
-1, 32,
        271, 27,
        -2, 45,
-1, 42,
        271, 28,
        -2, 45,
-1, 68,
        91, 58,
        -2, 56,
        };
# define YYNPROD 92
# define YYLAST 242
short yyact[]={

   5,   6,  44,  31,   7,  29,  27,  98,  92, 114,
  58,  33,  49,  48,  47,   4, 144, 133, 116,  70,
 115,  86,   3,   9,   8,  10,  91,  64, 111,  93,
  94, 110,  19, 109, 124,  81,  73,  59,  52,  24,
  21,  45,  36, 135,  25, 128, 108,  96,  68, 145,
 123, 141,  97,  67,  84,  57,  56,  55,  40,  39,
  38, 140, 139, 125, 120, 119, 104,  95,  78,  37,
 142, 107, 112, 102,  43,  35, 147, 127,  82,  74,
 126, 117, 101,  61,  54,   2, 146,  11, 138,  85,
  75,  63, 129, 118, 136, 122, 121, 132,  80,  79,
  99,  83,  72,  66,  60, 105, 106, 134, 103,  90,
  89,  88,  87,  42,  71,  53,  34,  51,  20, 113,
  77, 100,  62,  46,  23,  76,  65,  50,  41,  32,
  18,  30,  16,  28,  15,  26,  14,  22,  13,  17,
  12,   1,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 130, 131,   0,   0,   0,   0,   0,   0,   0,   0,
 137,   0,   0,   0,   0,   0,   0,   0, 143,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  69 };
short yypact[]={

-258,-258,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-224,-217,-270,-271,-273,-1000,-1000,-259,
-1000,  33,-1000,-221,  10,-1000,-1000,   0,-1000,  -1,
-1000,  -2,-275,-1000,-222,-1000,-1000,-1000,-255,-256,
-257,-1000,-275,-226,-1000,-1000,  44,  -5,  -6,  -7,
-261,-227,-1000,  43,-241,-1000,-1000,-1000,-1000,-1000,
 -23,-228,  38,-1000,-1000,-1000, -23,   9,-1000,-1000,
-229,  37,-1000,-1000, -10,-1000,-249,   8,-1000,-1000,
 -39,-1000,-267,-1000,  42,  29,-1000,-1000,-1000,-1000,
-1000,-1000,   7,-1000,-1000,-1000,  27,-233,-237,  28,
-263,-248,-250,  41,-1000,   6,   5,-1000, -43,-1000,
-1000,-1000,-230,   4,  40,  36,-1000,-215,-1000,-1000,
-1000, -23, -23,-1000,-1000,-1000,-251,-1000,-1000,-214,
-1000,-1000,-1000,-1000,   3,   2, -40,  27,  26,-1000,
-1000,-233,-252, -44,-1000,-1000,  35,-1000 };
short yypgo[]={

   0,  48, 141,  85, 140, 139, 138, 137, 136, 135,
 134, 133, 132, 131, 130, 129, 128, 127, 126, 125,
 124, 123, 122, 121, 119, 118, 116, 115, 114, 113,
 112, 111, 110, 109, 108, 107, 106, 105,  74, 104,
  53, 103, 102, 101, 100,  99,  47,  98,  46,  97,
  96,  95,  94,  93,  92,  91,  90,  89,  88,  86 };
short yyr1[]={

   0,   2,   2,   4,   3,   6,   3,   3,   3,   3,
   8,   3,  10,   3,  12,   3,  15,  17,  18,   5,
   5,  21,   7,   7,  26,  27,  14,  16,  16,  19,
  19,  19,  19,  19,  34,  35,  30,  36,  33,  37,
  32,  39,  29,  41,  29,  38,  38,  25,  25,  25,
  28,  28,  43,  42,  44,  44,  45,  40,  47,  49,
  40,  46,  50,  46,  51,  52,  46,   1,   1,  48,
  48,  48,  53,  31,  54,  54,  20,  20,  22,  22,
  56,  55,  57,  57,  23,  24,  58,  59,  24,   9,
  11,  13 };
short yyr2[]={

   0,   1,   2,   0,   3,   0,   3,   1,   1,   1,
   0,   3,   0,   3,   0,   3,   0,   0,   0,   8,
   2,   0,  10,   2,   0,   0,   9,   0,   1,   0,
   2,   2,   2,   2,   0,   0,   6,   0,   3,   0,
   3,   0,   5,   0,   6,   0,   1,   0,   1,   2,
   0,   1,   0,   3,   0,   3,   0,   3,   0,   0,
   7,   0,   0,   4,   0,   0,   8,   1,   2,   0,
   1,   1,   0,   4,   0,   3,   0,   1,   0,   1,
   0,   3,   0,   3,   3,   0,   0,   0,   8,   4,
   4,   4 };
short yychk[]={

-1000,  -2,  -3, 280, 273, 258, 259, 262, 282, 281,
 283,  -3,  -4,  -6,  -8, -10, -12,  -5, -14, 256,
 -25, 264,  -7, -20, 256, 261,  -9, 276, -11, 276,
 -13, 276, -15, 270, -26,  42, 263,  59,  60,  60,
  60, -16, -29, -38, 277, 263, -21, 269, 269, 269,
 -17, -38, 264, -27,  40,  62,  62,  62, 271, 264,
 -39,  40, -22, -55, 268, -18, -41, -40,  -1, 264,
  42, -28, -42, 264,  41, -56, -19, -40,  59, -45,
 -47, 264,  41, -43,  64, -57, 270, -30, -31, -32,
 -33, 275, 257, 278, 279,  59, -46,  91, 274, -44,
 -23,  40,  44, -34,  59, -37, -36,  44, -48, 266,
 264, 265,  44, -24, 272, 268, 268,  40, -53,  59,
  59, -50, -51,  93, 264,  59,  40,  41, 260, -54,
  -1,  -1, -49, 268, -35, 257, -52, -46, -58,  59,
  59,  91,  44, -48, 268,  93, -59,  41 };
short yydef[]={

   0,  -2,   1,   3,   5,   7,   8,   9,  10,  12,
  14,   2,  47,  76,   0,   0,   0,   4,  16,   0,
  24,  48,   6,   0,   0,  77,  11,   0,  13,   0,
  15,   0,  -2,  20,   0,  49,  21,  23,   0,   0,
   0,  17,  -2,   0,  46,  25,   0,   0,   0,   0,
   0,   0,  41,   0,  78,  89,  90,  91,  18,  43,
   0,  50,   0,  79,  80,  29,   0,   0,  -2,  67,
   0,   0,  51,  52,   0,  82,   0,   0,  42,  61,
   0,  68,   0,  54,   0,  81,  19,  30,  31,  32,
  33,  34,   0,  39,  37,  44,  57,  69,   0,  53,
  85,   0,   0,   0,  72,   0,   0,  62,   0,  70,
  71,  26,   0,   0,   0,   0,  83,   0,  74,  40,
  38,   0,   0,  59,  55,  22,   0,  84,  35,  73,
  63,  65,  61,  86,   0,   0,   0,  60,   0,  36,
  75,  69,   0,   0,  87,  66,   0,  88 };
#ifndef lint
static  char yaccpar_sccsid[] = "@(#)yaccpar 1.3 86/10/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*      parser for yacc output  */

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

        short yys[YYMAXDEPTH];
        short yyj, yym;
        register YYSTYPE *yypvt;
        register short yystate, *yyps, yyn;
        register YYSTYPE *yypv;
        register short *yyxi;

        yystate = 0;
        yychar = -1;
        yynerrs = 0;
        yyerrflag = 0;
        yyps= &yys[-1];
        yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
        if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
                if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
                *yyps = yystate;
                ++yypv;
                *yypv = yyval;

 yynewstate:

        yyn = yypact[yystate];

        if( yyn<= YYFLAG ) goto yydefault; /* simple state */

        if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
        if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

        if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
                yychar = -1;
                yyval = yylval;
                yystate = yyn;
                if( yyerrflag > 0 ) --yyerrflag;
                goto yystack;
                }

 yydefault:
        /* default state action */

        if( (yyn=yydef[yystate]) == -2 ) {
                if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
                /* look through exception table */

                for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

                while( *(yyxi+=2) >= 0 ){
                        if( *yyxi == yychar ) break;
                        }
                if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
                }

        if( yyn == 0 ){ /* error */
                /* error ... attempt to resume parsing */

                switch( yyerrflag ){

                case 0:   /* brand new error */

                        yyerror( "syntax error" );
                yyerrlab:
                        ++yynerrs;

                case 1:
                case 2: /* incompletely recovered error ... try again */

                        yyerrflag = 3;

                        /* find a state where "error" is a legal shift action */

                        while ( yyps >= yys ) {
                           yyn = yypact[*yyps] + YYERRCODE;
                           if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
                              yystate = yyact[yyn];  /* simulate a shift of "error" */
                              goto yystack;
                              }
                           yyn = yypact[*yyps];

                           /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
                           if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
                           --yyps;
                           --yypv;
                           }

                        /* there is no state on the stack with an error shift ... abort */

        yyabort:
                        return(1);


                case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
                        if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

                        if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
                        yychar = -1;
                        goto yynewstate;   /* try again in the same state */

                        }

                }

        /* reduction by production yyn */

#ifdef YYDEBUG
                if( yydebug ) printf("reduce %d\n",yyn);
#endif
                yyps -= yyr2[yyn];
                yypvt = yypv;
                yypv -= yyr2[yyn];
                yyval = yypv[1];
                yym=yyn;
                        /* consult goto table to find next state */
                yyn = yyr1[yyn];
                yyj = yypgo[yyn] + *yyps + 1;
                if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
                switch(yym){
                        
case 3:
# line 64 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_NORMAL:
                                        /* wrong input file type */     
                                        yyerror(PP_ONLY_L_FILE_MSG);
                                        break;
                                  case PP_MAKELIB:
                                        break;
                                  }
                                } break;
case 4:
# line 74 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_NORMAL:       
                                        SyncLineNorm1();
                                        break;
                                  case PP_MAKELIB:      
                                        SyncLineLib1(PP_RCV);
                                        break;
                                  }
                                } break;
case 5:
# line 84 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_NORMAL: switchfile = pp_cfile; break;
                                  case PP_MAKELIB: switchfile = pp_rcvfile; break;
                                  }
                                } break;
case 7:
# line 91 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        fprintf(pp_rcvfile, "%s", yypvt[-0].v.text);
                                        break;
                                  case PP_NORMAL: 
                                        fprintf(pp_cfile, "%s", yypvt[-0].v.text);
                                        break;
                                  }
                                } break;
case 8:
# line 101 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        yyerror(PP_INIT_RPC_MISPLACED_MSG);     
                                        SyncLineLib2(PP_ALL);
                                        break;
                                  case PP_NORMAL:
                                        fprintf(pp_cfile, "\n#include \"%s.m\"\n",
                                                pp_genname);
                                        pp_mfile_included = PP_TRUE;
                                        SyncLineNorm1();        
                                        break;
                                  }
                                } break;
case 9:
# line 115 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_MAKELIB:      
                                        fprintf(pp_rcvfile, yypvt[-0].v.text);
                                        fprintf(pp_callfile, yypvt[-0].v.text);
                                        break;
                                  case PP_NORMAL:
                                        fprintf(pp_cfile,yypvt[-0].v.text);
                                        break;
                                  }
                                } break;
case 10:
# line 127 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_NORMAL:
                                        if(yypvt[-0].freq && !pp_shfile_included){
                                                fprintf(pp_cfile, "\n#include\
 \"%s.sh\"", pp_genname); 
                                                pp_shfile_included = PP_TRUE;
                                        }
                                        break;
                                  case PP_MAKELIB:      
                                        yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                        break;
                                  }
                                } break;
case 12:
# line 143 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) {
                                  case PP_NORMAL:       
                                        if(yypvt[-0].freq && !pp_shfile_included){
                                                fprintf(pp_cfile, "\n#include\
 \"%s.sh\"", pp_genname);       
                                                pp_shfile_included = PP_TRUE;
                                        }
                                        break;
                                  case PP_MAKELIB:      
                                        yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                        break;
                                  }
                                } break;
case 14:
# line 159 "../../isis_pre/pp_yacc.y"
{ switch(pp_mode) 
                                    {
                                    case PP_NORMAL:
                                      if(yypvt[-0].freq && !pp_shfile_included)
                                        {
                                          fprintf(pp_cfile, "\n#include \"%s.sh\"", 
                                                  pp_genname);
                                          pp_shfile_included = PP_TRUE;
                                        }
                                      break;
                                    case PP_MAKELIB:
                                      yyerror(PP_NO_RECURSIVE_LIB_MSG);
                                      break;
                                    }
                                } break;
case 16:
# line 178 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        SyncLineLib2(PP_CALL);
                                        CallModule1(); 
                                        SyncLineLib1(PP_CALL); 
                                  }
                                } break;
case 17:
# line 185 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        CallModule2();
                                        RcvModule1(); 
                                  }
                                } break;
case 18:
# line 191 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile,"{");
                                        RcvModule2();
                                        SyncLineLib1(PP_RCV); 
                                  }
                                } break;
case 19:
# line 199 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) 
                                        fprintf(pp_rcvfile, "%s\n", yypvt[-0].v.text); } break;
case 20:
# line 202 "../../isis_pre/pp_yacc.y"
{ yyerrok; } break;
case 21:
# line 206 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, "%s_call(", yypvt[-0].v.text); } break;
case 22:
# line 208 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ";"); } break;
case 23:
# line 210 "../../isis_pre/pp_yacc.y"
{ yyerrok; } break;
case 24:
# line 214 "../../isis_pre/pp_yacc.y"
{ ; } break;
case 25:
# line 216 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        if(insertinfo(yypvt[-0].v.text, yypvt[-0].v.len, PP_F_NAME)
 != PP_OK) fprintf(stderr, PP_INS_FUNC_MSG1, pp_lineno,yypvt[-0].v.text);
                                  } 
                                } break;
case 26:
# line 222 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        if(insertinfo(yypvt[-0].v.text, yypvt[-0].v.len, PP_B_TYPE)
 != PP_OK) fprintf(stderr, PP_INS_BCAST_MSG, pp_lineno,yypvt[-0].v.text); 
                                  }
                                } break;
case 34:
# line 241 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_rcvfile, "%s", yypvt[-0].v.text);
                                } break;
case 35:
# line 245 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        RcvModule3(yypvt[-0].v.text); 
                                } break;
case 36:
# line 249 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, ";\n");
                                        SyncLineLib1(PP_RCV); 
                                  }
                                } break;
case 37:
# line 257 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, "%s", yypvt[-0].v.text);
                                      fprintf(pp_rcvfile, "abortreply(pp_msg_p)");
                                    }
                                } break;
case 38:
# line 264 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, ";\n");
                                    }
                                } break;
case 39:
# line 272 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                    {
                                      fprintf(pp_rcvfile, "%s", yypvt[-0].v.text);
                                      fprintf(pp_rcvfile, "nullreply(pp_msg_p)");
                                    }
                                } break;
case 40:
# line 279 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(pp_rcvfile, ";\n");
                                    }
                                } break;
case 41:
# line 287 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        vartype.strptr  = store_paratype(yypvt[-0].v.text, 
                                                vartype.len = yypvt[-0].v.len);
                                        fprintf(pp_callfile, "\t%s\t", yypvt[-0].v.text); 
                                  }
                                } break;
case 42:
# line 294 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, ";"); 
                                        init_vartype();
                                   }
                                } break;
case 43:
# line 301 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        vartype.strptr = store_paratype(yypvt[-0].v.text, 
                                                vartype.len = yypvt[-0].v.len);
                                        fprintf(pp_callfile, "\t%s\t", yypvt[-0].v.text); 
                                  }
                                } break;
case 44:
# line 308 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, ";"); 
                                        init_vartype();
                                  }
                                } break;
case 46:
# line 318 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB) {
                                        fprintf(pp_callfile, "\tregister\t");
                                        vartype.reg_var = PP_TRUE;
                                  }
                                } break;
case 47:
# line 325 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        if(insertinfo("int", 3, PP_F_TYPE) !=
PP_OK)fprintf(stderr,PP_INS_FUNC_MSG2, pp_lineno); 
                                  }
                                } break;
case 48:
# line 331 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        if(insertinfo(yypvt[-0].v.text, yypvt[-0].v.len, PP_F_TYPE)
!= PP_OK) fprintf(stderr, PP_INS_FUNC_MSG3, pp_lineno, yypvt[-0].v.text); 
                                  }
                                } break;
case 49:
# line 337 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(stderr, PP_PTR_MSG1, pp_lineno);
                                      if(insertinfo("<ERROR>", 7, PP_F_TYPE) != PP_OK) 
                                        fprintf(stderr,PP_INS_FUNC_MSG3,pp_lineno, "<ERROR>"); 
                                    }
                                } break;
case 52:
# line 351 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        if (insertparameter(yypvt[-0].v.text, yypvt[-0].v.len) !=
PP_OK) fprintf(stderr,PP_PARA_TRUNC_MSG, pp_lineno,yypvt[-0].v.text); 
                                  }
                                } break;
case 55:
# line 361 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        if (insertparameter(yypvt[-0].v.text, yypvt[-0].v.len) !=
PP_OK) fprintf(stderr,PP_PARA_TRUNC_MSG, pp_lineno,yypvt[-0].v.text); 
                                  }
                                } break;
case 56:
# line 369 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "%s", yypvt[-0].v.text); } break;
case 58:
# line 373 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "%s", yypvt[-0].v.text); } break;
case 59:
# line 376 "../../isis_pre/pp_yacc.y"
{ ; } break;
case 62:
# line 382 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, ","); } break;
case 63:
# line 385 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB)
                                    fprintf(pp_callfile, " %s", yypvt[-0].v.text);} break;
case 64:
# line 389 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, ","); } break;
case 65:
# line 392 "../../isis_pre/pp_yacc.y"
{ if (pp_mode == PP_MAKELIB)
                                    fprintf(pp_callfile, " %s", yypvt[-0].v.text);} break;
case 66:
# line 395 "../../isis_pre/pp_yacc.y"
{ ; } break;
case 67:
# line 399 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        if(insert_paratype(yypvt[-0].v.text,vartype.strptr,
vartype.len, vartype.reg_var) != PP_OK) {
                                               fprintf(stderr,PP_VAR_NOT_DECL_MSG,
pp_lineno, yypvt[-0].v.text); 
                                        }
                                        yyval.v = yypvt[-0].v;
                                  }
                                } break;
case 68:
# line 409 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) 
                                    {
                                      fprintf(pp_callfile, " *");
                                      sprintf(type_temp, "%s%c", vartype.strptr, '*');
                                      if (insert_paratype(yypvt[-0].v.text, type_temp, vartype.len + 1,
                                                          vartype.reg_var) != PP_OK)
                                        {
                                          fprintf(stderr,PP_VAR_NOT_DECL_MSG,pp_lineno, yypvt[-0].v.text);
                                        }
                                        yyval.v = yypvt[-0].v; 
                                  }
                                } break;
case 69:
# line 424 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(stderr, PP_PTR_MSG3, pp_lineno);
                                        fprintf(pp_callfile, "[]"); 
                                  }
                                } break;
case 70:
# line 430 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "[%s]", yypvt[-0].v.text); } break;
case 71:
# line 433 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB)
                                        fprintf(pp_callfile, "[%s]", yypvt[-0].v.text); } break;
case 72:
# line 438 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, "%s", yypvt[-1].v.text);
                                        fprintf(pp_rcvfile, ";");
                                  }
                                } break;
case 75:
# line 450 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_MAKELIB) {
                                        fprintf(pp_rcvfile, "%s", yypvt[-1].v.text); 
                                        fprintf(pp_rcvfile, ";");
                                  }
                                } break;
case 76:
# line 458 "../../isis_pre/pp_yacc.y"
{ yyerror(PP_RPC_RETURN_IGN_MSG); } break;
case 77:
# line 460 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, "%s ", yypvt[-0].v.text); } break;
case 80:
# line 468 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, "%s", yypvt[-0].v.text); } break;
case 83:
# line 474 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ", %s", yypvt[-0].v.text); } break;
case 84:
# line 478 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ", %s", yypvt[-1].v.text); } break;
case 85:
# line 482 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ",0,NULL)"); } break;
case 86:
# line 484 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ", %s", yypvt[-0].v.text); } break;
case 87:
# line 486 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ", %s", yypvt[-0].v.text); } break;
case 88:
# line 488 "../../isis_pre/pp_yacc.y"
{ fprintf(switchfile, ")"); } break;
case 89:
# line 492 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_NORMAL) 
                                    {
                                      SyncLineNorm2();
                                      if(LibraryModule1(yypvt[-1].v.text,PP_FROM_EXPORT) != PP_OK)
                                                yyerror(PP_CANT_READ_FN_MSG);
                                  } 
                                } break;
case 90:
# line 502 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_NORMAL) {
                                        SyncLineNorm2();
                                        if(LibraryModule1(yypvt[-1].v.text, PP_FROM_IMPORT) 
                                           != PP_OK)
                                                yyerror(PP_CANT_READ_FN_MSG);
                                  } 
                                } break;
case 91:
# line 512 "../../isis_pre/pp_yacc.y"
{ if(pp_mode == PP_NORMAL) 
                                    {
                                      SyncLineNorm2();
                                      if(LibraryModule1(yypvt[-1].v.text, PP_FROM_IM_EXPORT)
                                         != PP_OK)
                                        yyerror(PP_CANT_READ_FN_MSG);
                                    }
                                } break;
                }
                goto yystack;  /* stack new state and value */

        }
