/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
/******************************************************************************
 *
 *  pp_patch.h : format string to be inserted into the generated files
 *
 *****************************************************************************/
#define COMP_PARAMETER_NAME     "addr, nwanted, answ)\n"

#define COMP_PARAMETER_DECL_1    \
"       address addr;           /* rpc destination address */\n\
        int     nwanted;        /* number of answers wanted by the user */\n"
        
#define COMP_PARAMETER_DECL_2   \
"       %s      *answ;          /* pointer the storage for answers */ \n"

#define LOCAL_VAR_FOR_CALL              \
"{ \n\
        int     nresp;\n\n"
        
#define BROADCAST_1     \
"       nresp = %s(addr, (u_char)%s, \"%s\",\n\
\t\t%s, nwanted, \"%%%c\", answ);\n \
        return(nresp);\n}\n"

#define BROADCAST_2      \
"       nresp = %s(addr, (u_char)%s, \"%s\",\n\
\t\t%s, 0, \"%%d\", answ);\n\
        return(nresp);\n}\n"

#define DECLARE_RCV     \
"void   %s_rcv(pp_msg_p) \n\
        message *pp_msg_p;\n"

#define GET_FIELD       \
"\n     msg_get(pp_msg_p, \"%s\", %s);\n"

#define REPLY_MSG       \
"reply(pp_msg_p, \"%%%c\", %s); return"

#define DEFINE_ENTRY_POINT      \
"#define %s     (GENERICRCV_REPLY - %d)\n"

#define INIT_ENTRY_POINT        \
"       isis_entry(%s, %s_rcv, \"%s\");\n"

#define EXTERN_CALL     \
"extern int     %s_call();\n"

#define EXTERN_RCV      \
"extern void    %s_rcv();\n"

extern char     *invert_lettercase();
