/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
/******************************************************************************
 *
 *  patch.c - routines to write patches into the preprocessed files
 *
 *  Patches are defined as constant strings in patch.e
 *
 *  by : Cheong, Weng Seng
 *       Dept of Computer Science
 *       Cornell University
 *
 *****************************************************************************/
#include <stdio.h>
#include <strings.h>
#include <ctype.h>

#include "pp_const.h"
#include "pp_global.h"
#include "pp_info.e"
#include "pp_fname_tab.e"
#include "pp_patch.h"

/*
 * global variables for the string of parameter names and format string
 */
        /* namebuf is the list of parameter name */
        static
        char    fmtbuf[(2 * PP_MAX_NO_PARA) + 1];
        static
        char    namebuf[((PP_MAX_PARA_CHAR + 1) * PP_MAX_NO_PARA) + 1];

        /* namebuf1 is the list of parameter name addresses */
        static
        char    fmtbuf1[(2 * PP_MAX_NO_PARA) + 1];
        static
        char    namebuf1[((PP_MAX_PARA_CHAR + 1) * PP_MAX_NO_PARA) + 1];

/*
 * given a string, change all lower case characters to upper case, and vice versa.
 * let all non alphabetically characters unchanged
 */
char    *invert_lettercase(buffer)
        char    *buffer;
{
        char    *i;

        for(i = buffer; *i != '\0'; i++) {
                if (islower(*i)) *i = toupper(*i);
                else if (isupper(*i)) *i = tolower(*i);
        }
        return(buffer);
}

/* 
 * synchronize the line number of the library output files with the 
 * statements from the source file.
 */
void    SyncLineLib1(scope)
        int     scope;
{
        if (scope == PP_CALL || scope == PP_ALL)
                fprintf(pp_callfile, "# line %d \"%s\"\n", pp_lineno, pp_sourcename);
        if (scope == PP_RCV || scope == PP_ALL)
                fprintf(pp_rcvfile, "# line %d \"%s\"\n", pp_lineno, pp_sourcename);
}

/* 
 * similar to SyncLineLib1 except inserting a newline before the control statement
 */
void    SyncLineLib2(scope)
        int     scope;
{
        if (scope == PP_CALL || scope == PP_ALL)
                fprintf(pp_callfile, "\n# line %d \"%s\"\n", pp_lineno,
                         pp_sourcename);
        if (scope == PP_RCV || scope == PP_ALL)
                fprintf(pp_rcvfile, "\n# line %d \"%s\"\n", pp_lineno,
                         pp_sourcename);
}

/* 
 * synchronize line no in the c file with the source file
 */
void    SyncLineNorm1()
{
        fprintf(pp_cfile, "# line %d \"%s\"\n", pp_lineno, pp_sourcename);
}

/* 
 * same as SyncLineNorm1() except prints a newline before the control statement
 */
void    SyncLineNorm2()
{
        fprintf(pp_cfile, "\n# line %d \"%s\"\n", pp_lineno, pp_sourcename);
}

/* 
 * print part 1 of the calling procedure on the line where the reserved
 * word $entry appears.
 * 
 * part 1 :     the _call function declarations 
 *
 */
void    CallModule1()
{
        char    *name, *dummy1, dummy2;
        bool    dummy3;
        char    *func_type_ptr;
        
        /* print the function type. */ 
        fprintf(pp_callfile, "int\t");
        
        /* print the calling function name by appending _call to the name */
        fprintf(pp_callfile, "%s_call", getinfo(PP_F_NAME));
        
        /* print the list of user defined parameters */
        fprintf(pp_callfile, "%c", '(');
        for (firstparameter(&name, &dummy1, &dummy2, &dummy3);
                 name != NULL; nextparameter(&name, &dummy1, &dummy2, &dummy3) ) 
                fprintf(pp_callfile, "%s, ", name);
        
        /* print the compulsory parameters */
        fprintf(pp_callfile, COMP_PARAMETER_NAME);

        /* print the compulsory parameters' declaration */
        fprintf(pp_callfile, COMP_PARAMETER_DECL_1);
        func_type_ptr = getinfo(PP_F_TYPE);
        if (strcmp(func_type_ptr, "void") == PP_EQUAL) {
                fprintf(pp_callfile, COMP_PARAMETER_DECL_2, "int");
        } else {
                fprintf(pp_callfile, COMP_PARAMETER_DECL_2, func_type_ptr);
        }
}

/* 
 * print part 2 of the calling procedure, and set the entry point value 
 * This routine initializes the global buffers, fmtbuf, namebuf1 and namebuf
 * These buffers will be use by RcvModule2()
 * 
 * part 2 :     body of the calling routine
 *              the _rcv function declaration
 */
void    CallModule2()
{
        char    constname[PP_MAX_FUNCTION_CHAR + 1];
        char    *name, *type, fmt;
        bool    dummy;
        int     i = 0, j = 0;
        
        /* print the local _call vars */
        fprintf(pp_callfile, LOCAL_VAR_FOR_CALL);
        
        /* compile all parameter names and format strings */

        firstparameter(&name, &type, &fmt, &dummy);
        fmtbuf[i++] = '%';
        fmtbuf1[j++] = '%';
        fmtbuf[i++] = fmt;
        if (fmt != 's')
          {
            fmtbuf1[j++] = fmt;
          }
        else
          {
            fmtbuf1[j++] = '-';
            fmtbuf1[j++] = fmt;
          }
        strcpy(namebuf, name);
        strcpy(namebuf1, "&");
        strcat(namebuf1, name);
        for (nextparameter(&name, &type, &fmt, &dummy); name != NULL;
                        nextparameter(&name, &type, &fmt, &dummy)) 
          {
            fmtbuf[i++] = '%';
            fmtbuf1[j++] = '%';
            fmtbuf[i++] = fmt;
            if (fmt != 's')
              {
                fmtbuf1[j++] = fmt;
              }
            else
              {
                fmtbuf1[j++] = '-';
                fmtbuf1[j++] = fmt;
              }
            strcat(namebuf, ",");
            strcat(namebuf1, ",&");
            strcat(namebuf, name);
            strcat(namebuf1, name);
          }
        fmtbuf[i] = '\0';
        fmtbuf1[j] = '\0';
                        
        /* print the broadcast command */
        fmt = *getinfo(PP_F_FMT);    /* get the function return value type */
        if (fmt == 'v')
          {
            fprintf(pp_callfile, BROADCAST_2, getinfo(PP_B_TYPE),
                    invert_lettercase(strcpy(constname, getinfo(PP_F_NAME))),
                    fmtbuf, namebuf);
          }
        else
          {
            fprintf(pp_callfile, BROADCAST_1, getinfo(PP_B_TYPE), 
                    invert_lettercase(strcpy(constname, getinfo(PP_F_NAME))),
                    fmtbuf, namebuf, fmt );     
          }
}

/*
 * print the declaration of _rcv function 
 */
void    RcvModule1()
{
        /* declare the _rcv function */
        fprintf(pp_rcvfile, DECLARE_RCV, getinfo(PP_F_NAME));
}

/* 
 * print part 2 of the _rcv function 
 * Uses the global buffers, fmtbuf1 and namebuf1 as init by CallModule2()
 * 
 * part 2 :     local var and body of the _rcv function
 */
void    RcvModule2()
{       
        char    *name, *type, dummy1;
        bool    reg;
        int     i;
                
        /* user declared variables */
        fprintf(pp_rcvfile, "\n");
        for (firstparameter(&name, &type, &dummy1, &reg);
                name != NULL; nextparameter(&name, &type, &dummy1, &reg)) {
                if (reg == PP_TRUE) {
                        fprintf(pp_rcvfile, "\tregister %s\t%s;\n", type, name);
                } else {
                        fprintf(pp_rcvfile, "\t%s\t%s;\n", type, name);
                }
        }
                
        /* get the parameter values from the message */
        fprintf(pp_rcvfile, GET_FIELD, fmtbuf1, namebuf1);
}

/*
 * print part 3 of the _rcv function 
 * 
 * part 3 :     reply to the calling function
 */
void    RcvModule3(str)
        char    *str;
{       
        fprintf(pp_rcvfile, REPLY_MSG, *getinfo(PP_F_FMT), str);
}


/*
 * Replace the library statement with "include" statement of appropriate
 * files, and read the library's fn file into the source file function name 
 * table
 */
int LibraryModule1(libraryname, mode)
     char *libraryname;
     int mode;
{
  FILE  *libfn;
  char  buf[PP_MAX_FILE_CHAR], *bufptr = buf;
  char  functionname[PP_MAX_FUNCTION_CHAR + 1];
  
  /* include the library's call routine extern file */
  if (mode == PP_FROM_EXPORT || mode == PP_FROM_IM_EXPORT)
    fprintf(pp_cfile, "#include \"%s.libr.e\"\n", libraryname); 
  if (mode == PP_FROM_IMPORT || mode == PP_FROM_IM_EXPORT)
    fprintf(pp_cfile, "#include \"%s.libc.e\"\n", libraryname);
  
  /* read the library's fn file into the source file table */
  bufptr = strcpy(buf, libraryname);
  bufptr = strcat(buf, ".libfn");
  if((libfn = fopen(bufptr, "r")) == NULL) {
    return(PP_ERROR);
  }
  functionname[0] = mode;
  while(fscanf(libfn, "%s", &functionname[1]) != EOF) {
    if(insert_tab(functionname) == NULL) return(PP_ERROR);
  }
  fclose(libfn);
  return(PP_OK);
}

/* 
 * alphabetically sort the rpc function names in the fname_tab 
 * and write them to the fn file
 */
void    write_fnfile()
{
        int     i;
        char    *ptr;
        
        /* sort the function names */
        sort_tab();

        /* get the ith. function name one at a time , and write into the 
         * and write into the fn file */
        for (i = 0; (ptr = get_fname(i)) != NULL; i++)
                fprintf(pp_fnfile, "%s\n", ptr);
}
