/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
        struct yywork *yystoff;
        struct yysvf *yyother;
        int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/******************************************************************************
 *
 * pp_lex.l : lexical analyser for specification files in isis_pre
 *
 * description of the various start symbols :
 *      N :
 *              The normal text in the source file. In this mode, lex
 *              will eat up as much text as possible ( till the next <cr> )
 *      RPC_HEAD :
 *              RPC's declaration statement and parameters' declaration
 *      RPC_STAT :
 *              RPC's body statement
 *      RPC_REPLY :
 *              RPC's reply to the caller. This start symbol is triggered
 *              by the keyword return in RPC_STAT
 *      RPC_CALL :
 *              RPC function invokation
 *      RPC_ARG :
 *              Arguments when calling an RPC function. This start symbol is 
 *              triggered after the RPC function name is read in RPC_CALL
 *      COMMENT :
 *              Comments in the specification file. 
 *      IMPT_EXPT :
 *              <import> and <export> statements
 *      CONTROL :
 *              control statements (ie. statements beginning with '#')
 *
 *  by : Cheong, Weng Seng
 *       Dept of Computer Science
 *       Cornell University
 *
 *****************************************************************************/
#include <strings.h>
#include <stdio.h>
#include "pp_yacc.h"
#include "pp_const.h"
#include "pp_global.h"
#include "pp_lex_msg.h"

static int      clevel; /* level of curly braces in the rpc declaration's body */
static int      plevel; /* level of parentheses */
static int      backslash_in_string = PP_FALSE;
static int      stage;  /* current stage before entering stage COMMENT */
static int      bufcount = 0;           /* # of charaters in the buffer */
static int      entry_count = 0;        /* number of entrys encountered */
static int      import_count = 0;       /* number of imports encountered */
static int      export_count = 0;       /* number of exports encountered */
static int      im_export_count = 0;    /* number of im/export encountered */

/* text buffer to store token obtained by pp_lex */
typedef struct lexbuf {
        char    buf[PP_BUFSIZE];
} lexbuf;

static  lexbuf  buf_tab[PP_NO_OF_LEX_BUF];
static  int     current_buf = 0;        /* no of the buffer to be filled */
                                         
void    push_text()
{
        if ((yyleng + bufcount) > PP_BUFSIZE) {
                fprintf(stderr,PP_BUFFER_OVERFLOW_MSG);
                
        } else {
                if (bufcount == 0)
                        strcpy(buf_tab[current_buf].buf, yytext);
                else
                        strcat(buf_tab[current_buf].buf, yytext);
                yylval.v.text = buf_tab[current_buf].buf;
                yylval.v.len = (bufcount += yyleng);
        }
}

void    no_text()
{
        yylval.v.text = buf_tab[current_buf].buf;
        yylval.v.len = bufcount;
}

#define INIT_BUFFER()   (bufcount = 0)
#define WRAPUP_BUFFER() bufcount = 0; ++current_buf;current_buf %= PP_NO_OF_LEX_BUF

void    push_token()
{
        if (yyleng > PP_BUFSIZE){ 
                fprintf(stderr, "yylex() read more than buffersize");
        } else {
                strcpy(buf_tab[current_buf].buf, yytext);
                yylval.v.text = buf_tab[current_buf].buf;
                yylval.v.len = yyleng;
                ++current_buf;
                current_buf %= PP_NO_OF_LEX_BUF;
        }
}

void    empty_token()   
{ 
        yylval.v.text = NULL;
        yylval.v.len = 0;
}

void    do_increline()
{
        char    *tmp;
        
        for(tmp = index(yytext, '\n'); 
                tmp != 0; pp_lineno++, tmp = index(tmp, '\n'));
}
# define N 2
# define RPC_HEAD 4
# define RPC_STAT 6
# define RPC_REPLY 8
# define COMMENT 10
# define RPC_ARG 12
# define RPC_CALL 14
# define IMPT_EXPT 16
# define CONTROL 18
# define STR 20
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
                { empty_token(); return USES; }
break;
case 2:
        { push_token(); return BROADCAST; }
break;
case 3:
                { push_token(); return BROADCAST; }
break;
case 4:
                { push_token(); return BROADCAST; }
break;
case 5:
                { push_token(); return BROADCAST; }
break;
case 6:
        { empty_token(); return REGISTER; }
break;
case 7:
                { empty_token(); return '('; }
break;
case 8:
                { empty_token(); return ')'; }
break;
case 9:
                { empty_token(); return ','; }
break;
case 10:
                { empty_token(); return '='; }
break;
case 11:
                { empty_token(); return '['; }
break;
case 12:
                { empty_token(); return ']'; }
break;
case 13:
                { empty_token(); return ';'; }
break;
case 14:
                { stage = RPC_HEAD; BEGIN COMMENT; }
break;
case 15:
                { unput(*yytext); clevel = 0;
                                  BEGIN RPC_STAT; }
break;
case 16:
                { empty_token(); return '*'; }
break;
case 17:
        { push_token(); return INTG; }
break;
case 18:
{ push_token(); return DECIMAL; }
break;
case 19:

                                { push_token(); do_increline(); 
                                  return FUNC_NAME; }
break;
case 20:
{ push_token(); return IDENT; }
break;
case 21:
                ;
break;
case 22:
{ no_text(); WRAPUP_BUFFER();
                                  return NULLREPLY; }
break;
case 23:

                                { no_text(); WRAPUP_BUFFER();
                                  return ABORTREPLY; }
break;
case 24:
        { no_text(); WRAPUP_BUFFER(); 
                                  plevel = 0; BEGIN RPC_REPLY;
                                  return REPLY; }
break;
case 25:
                { stage = RPC_STAT; BEGIN COMMENT; }
break;
case 26:
                { clevel++;  
                                  if (clevel == 1) {
                                        /* signal the start of the rpc body */
                                        empty_token(); INIT_BUFFER();
                                        return LEFT_CURLY;
                                  } else {
                                        /* just another parenthesis */
                                        push_text();
                                  }
                                }
break;
case 27:
                { clevel--; 
                                  if (clevel == 0) {
                                        push_text(); WRAPUP_BUFFER();
                                        BEGIN N;
                                        return RIGHT_CURLY;
                                  } else {
                                        push_text();
                                  }
                                }
break;
case 28:
                { empty_token(); return ';'; }
break;
case 29:
                { push_text(); }
break;
case 30:
                { push_text(); }
break;
case 31:
        { push_text(); }
break;
case 32:
{ push_text(); WRAPUP_BUFFER(); 
                                  return RPC_STATEMENT; }
break;
case 33:
        { push_text(); }
break;
case 34:
                { push_text(); pp_lineno++; }
break;
case 35:
                { plevel++;
                                  if (plevel == 1) {
                                        empty_token(); INIT_BUFFER();
                                        return '(';
                                  } else {
                                        push_text();
                                  }
                                }
break;
case 36:
                { plevel--;
                                  if(plevel == 0) {
                                        no_text(); WRAPUP_BUFFER();
                                        BEGIN RPC_STAT;
                                        return RET_VAL;
                                  } else {
                                        push_text();
                                  }
                                }
break;
case 37:
        { push_text(); }
break;
case 38:
                { push_text(); pp_lineno++; }
break;
case 39:
                { empty_token(); BEGIN N;
                                  INIT_BUFFER(); return ';'; }
break;
case 40:
                { plevel++;
                                  if (plevel == 1) {
                                        empty_token(); INIT_BUFFER();
                                        return '(';
                                  } else {
                                        push_text();
                                  }
                                }
break;
case 41:
                { if (plevel == 1){
                                        empty_token(); INIT_BUFFER();
                                        plevel--;
                                        return ')';
                                  } else {
                                        push_text();
                                        plevel--;
                                  }
                                }
break;
case 42:
                { if (plevel == 1) {
                                        empty_token(); INIT_BUFFER();
                                        return ',';
                                  } else {
                                        push_text();
                                  }
                                }
break;
case 43:
                { empty_token(); INIT_BUFFER();
                                  return '@'; }
break;
case 44:
                { empty_token(); INIT_BUFFER();
                                  return ARROW; }
break;
case 45:
                { push_text();
                                  if (*yytext == '(') plevel++;
                                  if (*yytext == ')') plevel--;
                                  if (plevel == 1) {
                                        WRAPUP_BUFFER();
                                        return EXPR;
                                  }
                                }
break;
case 46:
                { push_text();
                                  if (*yytext == '(') plevel++;
                                  if (*yytext == ')') plevel--;
                                  if (plevel == 1) {
                                        WRAPUP_BUFFER(); return EXPR;
                                  }
                                }
break;
case 47:
                { push_text(); }
break;
case 48:

                                { push_token(); do_increline();
                                  return IDENT_EQUAL; }
break;
case 49:
        
                                { push_token(); do_increline();
                                  plevel = 0; INIT_BUFFER();
                                  BEGIN RPC_ARG; return FUNC_NAME; }
break;
case 50:
                { if (yytext[yyleng - 1] == '\\') {
                                        push_text();
                                  } else {
                                        push_text(); WRAPUP_BUFFER();
                                        BEGIN N; return CONTROL_STAT;
                                  }
                                }
break;
case 51:
                { push_text(); pp_lineno++; }
break;
case 52:
        { push_token(); return LIBRARY; }
break;
case 53:
        { push_token(); return LIB_NAME; }
break;
case 54:
                { empty_token(); return '<'; }
break;
case 55:
                { empty_token(); BEGIN N; return '>'; }
break;
case 56:
                ;
break;
case 57:
                { switch(stage) {
                                        case N:         BEGIN N;
                                                        break;
                                        case RPC_STAT:  BEGIN RPC_STAT;
                                                        break;
                                        case RPC_HEAD:  BEGIN RPC_HEAD;
                                                        break;
                                        default:        halt("Error: Undefined stage value in lexical analyser\n");
                                   }
                                }
break;
case 58:
                ;
break;
case 59:
                { push_text();
                                  if(yytext[yyleng - 1] == '\\') 
                                        backslash_in_string = PP_TRUE;
                                }
break;
case 60:
                        { push_text();
                                  if(backslash_in_string) 
                                        /* backslash no more in effect */
                                        backslash_in_string = PP_FALSE;
                                  else {
                                        BEGIN N;
                                        return NORMAL_TEXT;
                                  }
                                }
break;
case 61:
                        { push_text(); pp_lineno++;
                                  if(backslash_in_string) 
                                        /* backslash no more in effect */
                                        backslash_in_string = PP_FALSE;
                                  else
                                        fprintf(stderr,PP_RETURN_IN_STR_MSG,                                            pp_lineno - 1);
                                }
break;
case 62:
                { nul_info(); BEGIN RPC_HEAD; 
                                  yylval.freq = ++entry_count; 
                                  return ENTRY; }
break;
case 63:
                { BEGIN IMPT_EXPT;
                                  yylval.freq = ++import_count;
                                  return IMPORT; }
break;
case 64:
                { BEGIN IMPT_EXPT;
                                  yylval.freq = ++export_count;
                                  return EXPORT; }
break;
case 65:
        { BEGIN IMPT_EXPT;
                                  yylval.freq = ++im_export_count;
                                  return IM_EXPORT; }
break;
case 66:
        
                                { empty_token(); do_increline();
                                  return INIT_RPC; }
break;
case 67:
                        { nul_info(); BEGIN RPC_CALL;
                                  plevel = 0; INIT_BUFFER();
                                  empty_token(); return DOUBLE_DOLLAR; }
break;
case 68:
                        { stage = N; BEGIN COMMENT; }
break;
case 69:
                        { switch(pp_mode) {
                                  case PP_NORMAL : 
                                        fprintf(pp_cfile, "$");
                                        break;
                                  case PP_MAKELIB:
                                        fprintf(pp_rcvfile, "$");
                                        break;
                                  }
                                }
break;
case 70:
                        { switch(pp_mode) {
                                  case PP_NORMAL :
                                        fprintf(pp_cfile, "/");
                                        break;
                                  case PP_MAKELIB:
                                        fprintf(pp_rcvfile, "/");
                                        break;
                                  }
                                }
break;
case 71:
                        { switch(pp_mode) {
                                  case PP_NORMAL : 
                                        fprintf(pp_cfile, "*");
                                        break;
                                  case PP_MAKELIB:
                                        fprintf(pp_rcvfile, "*");
                                        break;
                                  } 
                                }
break;
case 72:
                        { push_text(); BEGIN CONTROL; }
break;
case 73:
                        { switch(pp_mode) {
                                  case PP_NORMAL : 
                                        fprintf(pp_cfile, "#");
                                        break;
                                  case PP_MAKELIB:
                                        fprintf(pp_rcvfile, "#");
                                        break;
                                  }
                                }
break;
case 74:
                        {  /* trap all strings in the normal text 
                                    * to  prevent error when $<keyword> 
                                    * is in the string */
                                   push_text(); 
                                   backslash_in_string = PP_FALSE;
                                   BEGIN STR;
                                }
break;
case 75:
                { push_token(); return NORMAL_TEXT; }
break;
case 76:
                        { pp_lineno++; 
                                  switch(pp_mode) {
                                  case PP_NORMAL : 
                                        fprintf(pp_cfile, "\n");
                                        break;
                                  case PP_MAKELIB:      
                                        fprintf(pp_rcvfile, "\n");
                                        fprintf(pp_callfile, "\n");
                                        break;
                                  } 
                                }
break;
case 77:
                        { unput(*yytext);
                                  entry_count = 0;
                                  import_count = 0;
                                  export_count = 0;
                                  BEGIN N; }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] = {
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

53,
0,

77,
0,

76,
0,

75,
77,
0,

74,
77,
0,

73,
77,
0,

69,
77,
0,

71,
77,
0,

70,
77,
0,

72,
73,
77,
0,

21,
77,
0,

7,
21,
77,
0,

8,
21,
77,
0,

16,
21,
77,
0,

9,
21,
77,
0,

21,
77,
0,

17,
21,
77,
0,

13,
21,
77,
0,

10,
21,
77,
0,

20,
21,
77,
-19,
0,

11,
21,
77,
0,

12,
21,
77,
0,

20,
21,
77,
-19,
0,

20,
21,
77,
-19,
0,

20,
21,
77,
-19,
0,

20,
21,
77,
-19,
0,

20,
21,
77,
-19,
0,

20,
21,
77,
-19,
0,

15,
21,
77,
0,

33,
77,
-32,
0,

34,
76,
0,

30,
77,
0,

31,
77,
0,

31,
77,
0,

28,
77,
0,

29,
77,
0,

26,
77,
0,

27,
77,
0,

37,
77,
0,

38,
76,
0,

35,
77,
0,

36,
77,
0,

58,
77,
0,

58,
77,
0,

47,
77,
-45,
-46,
0,

40,
47,
77,
-45,
-46,
0,

41,
47,
77,
-45,
-46,
0,

42,
47,
77,
-45,
-46,
0,

39,
47,
77,
-45,
-46,
0,

47,
77,
-45,
-46,
0,

43,
47,
77,
-45,
-46,
0,

77,
0,

76,
0,

77,
0,

77,
-49,
0,

56,
77,
0,

53,
56,
77,
0,

54,
56,
77,
0,

55,
56,
77,
0,

53,
56,
77,
0,

50,
77,
0,

51,
76,
0,

59,
77,
0,

61,
76,
0,

60,
77,
0,

75,
0,

67,
0,

68,
0,

14,
0,

18,
0,

17,
0,

19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

33,
-32,
0,

32,
0,

25,
0,

37,
0,

57,
0,

46,
0,

45,
0,

44,
0,

-49,
0,

49,
0,

48,
0,

53,
0,

53,
0,

50,
0,

59,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

53,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

1,
20,
-19,
0,

53,
0,

20,
-19,
0,

3,
20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

53,
0,

62,
0,

2,
20,
-19,
0,

4,
20,
-19,
0,

5,
20,
-19,
0,

20,
-19,
0,

24,
0,

53,
0,

64,
0,

63,
0,

20,
-19,
0,

52,
53,
0,

6,
20,
-19,
0,

65,
0,

66,
0,

22,
0,

23,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,    0,0,    1,23,   0,0,    
0,0,    3,25,   0,0,    0,0,    
0,0,    0,0,    1,23,   1,24,   
0,0,    3,25,   3,24,   0,0,    
0,0,    0,0,    0,0,    0,0,    
75,118, 75,118, 0,0,    0,0,    
0,0,    0,0,    15,73,  15,74,  
0,0,    16,73,  16,74,  0,0,    
0,0,    0,0,    0,0,    1,23,   
1,23,   1,23,   3,26,   3,27,   
3,28,   1,23,   28,88,  75,118, 
3,25,   8,54,   3,29,   1,23,   
1,23,   1,23,   3,25,   3,30,   
3,25,   10,63,  4,31,   14,68,  
5,32,   30,91,  14,69,  15,75,  
1,23,   4,29,   16,75,  3,25,   
5,32,   5,24,   1,23,   6,34,   
6,35,   3,25,   6,36,   37,92,  
55,108, 65,111, 18,79,  14,71,  
18,80,  66,112, 14,72,  71,114, 
66,113, 124,0,  15,76,  0,0,    
0,0,    16,76,  0,0,    6,40,   
0,0,    5,32,   5,32,   5,32,   
0,0,    0,0,    0,0,    5,33,   
5,34,   5,35,   0,0,    5,36,   
53,106, 5,32,   5,37,   5,38,   
45,97,  45,99,  46,100, 28,89,  
47,101, 48,97,  49,97,  28,90,  
48,102, 53,107, 5,39,   1,23,   
5,40,   6,42,   3,25,   6,43,   
5,41,   57,109, 18,81,  6,44,   
6,45,   6,46,   8,58,   49,103, 
8,59,   6,47,   81,123, 15,76,  
89,126, 102,97, 16,76,  106,136,        
87,0,   14,66,  102,134,        14,66,  
90,128, 90,129, 89,127, 6,49,   
98,97,  98,130, 5,42,   103,97, 
5,43,   6,50,   103,135,        6,32,   
5,44,   5,45,   5,46,   7,51,   
95,95,  95,95,  5,47,   107,137,        
87,0,   87,0,   87,0,   7,51,   
7,52,   99,131, 99,97,  109,138,        
87,0,   5,48,   100,97, 100,132,        
5,49,   87,0,   110,0,  9,60,   
101,97, 101,133,        5,50,   95,95,  
5,32,   123,139,        126,140,        9,60,   
9,61,   127,141,        104,0,  95,96,  
7,51,   7,51,   7,53,   11,64,  
125,0,  129,144,        7,51,   136,151,        
7,54,   130,145,        130,97, 11,64,  
7,51,   7,55,   7,51,   137,152,        
110,0,  110,0,  116,118,        116,118,        
9,60,   9,60,   9,60,   131,97, 
104,0,  7,56,   9,62,   9,63,   
125,0,  138,153,        104,0,  7,51,   
9,60,   9,60,   9,60,   104,0,  
11,64,  11,64,  11,64,  128,142,        
131,146,        116,118,        11,64,  139,154,        
11,65,  9,60,   132,147,        132,97, 
11,64,  11,64,  11,64,  9,60,   
133,148,        133,97, 140,155,        134,97, 
119,119,        119,119,        141,156,        142,157,        
12,64,  11,64,  134,149,        143,158,        
135,97, 144,159,        145,97, 11,64,  
12,64,  93,93,  93,93,  93,93,  
93,93,  93,93,  93,93,  93,93,  
93,93,  93,93,  93,93,  119,119,        
7,57,   135,150,        151,165,        145,160,        
152,166,        146,97, 153,167,        119,120,        
13,66,  7,58,   154,168,        7,59,   
147,97, 12,64,  12,64,  12,64,  
13,66,  13,24,  148,97, 12,64,  
9,60,   12,65,  104,0,  146,161,        
128,143,        12,64,  12,64,  12,64,  
119,121,        147,162,        155,169,        104,0,  
156,170,        104,0,  157,171,        148,163,        
11,64,  158,172,        12,64,  149,97, 
159,173,        13,66,  13,66,  13,66,  
12,64,  160,97, 162,97, 13,67,  
13,68,  17,77,  165,178,        13,69,  
166,179,        13,66,  13,66,  13,66,  
149,164,        17,77,  17,24,  163,97, 
167,180,        168,181,        164,97, 160,174,        
162,175,        170,182,        13,70,  171,183,        
13,71,  172,184,        19,82,  13,72,  
13,66,  173,185,        178,187,        179,188,        
181,189,        163,176,        19,82,  19,83,  
164,177,        183,190,        17,77,  17,77,  
17,77,  185,191,        177,97, 187,193,        
17,77,  177,186,        21,84,  188,194,        
190,195,        12,64,  17,78,  17,78,  
17,78,  191,196,        21,84,  21,85,  
193,197,        194,198,        195,199,        19,82,  
19,82,  19,82,  197,201,        17,77,  
17,79,  19,82,  17,80,  198,202,        
201,204,        17,78,  202,205,        19,82,  
19,82,  19,82,  25,87,  196,196,        
196,196,        13,66,  204,207,        21,86,  
21,84,  21,84,  25,87,  25,0,   
19,82,  21,84,  13,66,  0,0,    
13,66,  0,0,    19,82,  21,84,  
21,84,  21,84,  200,200,        200,200,        
0,0,    0,0,    196,196,        205,205,        
205,205,        0,0,    203,203,        203,203,        
21,84,  0,0,    196,200,        25,0,   
25,0,   25,0,   21,84,  0,0,    
17,81,  25,87,  0,0,    25,0,   
0,0,    200,200,        17,78,  25,87,  
25,0,   25,87,  205,205,        0,0,    
0,0,    203,203,        200,203,        0,0,    
0,0,    0,0,    0,0,    205,208,        
25,87,  207,207,        207,207,        0,0,    
0,0,    0,0,    25,87,  19,82,  
38,93,  0,0,    38,94,  38,94,  
38,94,  38,94,  38,94,  38,94,  
38,94,  38,94,  38,94,  38,94,  
203,206,        0,0,    0,0,    0,0,    
207,207,        0,0,    0,0,    21,84,  
0,0,    0,0,    0,0,    0,0,    
0,0,    207,209,        0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    25,87,  
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,95,  41,95,  41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   0,0,    
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,96,  
41,0,   41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,97,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    41,0,   41,0,   41,0,   
41,0,   41,0,   41,0,   41,0,   
41,97,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
44,95,  44,95,  41,0,   41,0,   
41,0,   41,0,   0,0,    41,0,   
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    44,95,  
0,0,    41,97,  0,0,    0,0,    
0,0,    0,0,    0,0,    44,96,  
0,0,    0,0,    41,0,   41,0,   
41,0,   41,0,   41,0,   44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  0,0,    0,0,    
0,0,    0,0,    44,97,  0,0,    
44,97,  44,98,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  44,97,  44,97,  
44,97,  44,97,  51,104, 0,0,    
0,0,    60,110, 0,0,    0,0,    
0,0,    0,0,    51,104, 51,0,   
0,0,    60,110, 60,0,   0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    51,104, 
51,104, 51,0,   60,110, 60,110, 
60,110, 51,104, 0,0,    51,0,   
60,0,   60,0,   0,0,    51,104, 
51,0,   51,104, 60,110, 60,110, 
60,110, 0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
51,105, 0,0,    0,0,    60,110, 
0,0,    0,0,    51,104, 0,0,    
0,0,    60,110, 0,0,    73,115, 
73,115, 0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    73,115, 0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
73,116, 0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    51,0,   
0,0,    0,0,    60,110, 0,0,    
0,0,    0,0,    0,0,    0,0,    
51,0,   0,0,    51,0,   73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 0,0,    0,0,    0,0,    
0,0,    73,117, 0,0,    73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 73,117, 73,117, 73,117, 
73,117, 76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,0,   76,119, 76,119, 76,0,   
76,0,   76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
0,0,    76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,120, 76,0,   76,0,   76,0,   
76,0,   76,0,   76,0,   76,0,   
76,117, 0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    76,0,   76,0,   
76,0,   76,121, 76,0,   76,0,   
76,0,   76,117, 0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    76,0,   
76,0,   76,0,   76,0,   0,0,    
76,0,   0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    76,117, 0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    76,0,   
76,0,   76,0,   76,0,   76,0,   
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 0,0,    0,0,    0,0,    
0,0,    78,122, 0,0,    78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 78,122, 78,122, 78,122, 
78,122, 82,124, 0,0,    0,0,    
84,125, 0,0,    0,0,    0,0,    
0,0,    82,124, 82,0,   0,0,    
84,125, 84,0,   0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    82,124, 82,124, 
82,124, 84,0,   84,125, 84,125, 
82,124, 0,0,    0,0,    84,125, 
0,0,    0,0,    82,124, 82,124, 
82,124, 84,125, 84,125, 84,125, 
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    82,124, 
0,0,    0,0,    84,125, 0,0,    
0,0,    82,124, 0,0,    0,0,    
84,125, 0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    82,124, 0,0,    
0,0,    84,125, 97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   118,118,        118,118,        
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   118,118,        97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   0,0,    97,0,   97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    97,0,   
97,0,   97,0,   97,0,   97,0,   
97,0,   97,0,   118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
97,0,   97,0,   97,0,   97,0,   
118,117,        97,0,   118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
118,117,        118,117,        118,117,        118,117,        
97,0,   97,0,   97,0,   97,0,   
97,0,   117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
117,0,  0,0,    0,0,    117,0,  
117,0,  117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
0,0,    117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
0,0,    117,0,  117,0,  117,0,  
117,0,  117,0,  117,0,  117,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    117,0,  117,0,  
117,0,  117,121,        117,0,  117,0,  
117,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    117,0,  
117,0,  117,0,  117,0,  0,0,    
117,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    117,0,  
117,0,  117,0,  117,0,  117,0,  
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
0,0,    0,0,    150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  0,0,    
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  0,0,    
150,0,  150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    150,0,  150,0,  150,0,  
150,0,  150,0,  150,0,  150,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    150,0,  150,0,  
150,0,  150,0,  0,0,    150,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    150,0,  150,0,  
150,0,  150,0,  150,0,  161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  0,0,    
0,0,    161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  0,0,    161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  0,0,    161,0,  
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
161,0,  161,0,  161,0,  161,0,  
161,0,  161,0,  161,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    161,0,  161,0,  161,0,  
161,0,  0,0,    161,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    161,0,  161,0,  161,0,  
161,0,  161,0,  174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  0,0,    0,0,    
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  0,0,    174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  0,0,    174,0,  174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    174,0,  
174,0,  174,0,  174,0,  174,0,  
174,0,  174,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
174,0,  174,0,  174,0,  174,0,  
0,0,    174,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
174,0,  174,0,  174,0,  174,0,  
174,0,  175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  0,0,    0,0,    175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
0,0,    175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
0,0,    175,0,  175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    175,0,  175,0,  
175,0,  175,0,  175,0,  175,0,  
175,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    175,0,  
175,0,  175,0,  175,0,  0,0,    
175,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    175,0,  
175,0,  175,0,  175,0,  175,0,  
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
0,0,    0,0,    176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  0,0,    
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  0,0,    
176,0,  176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    176,0,  176,0,  176,0,  
176,0,  176,0,  176,0,  176,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    176,0,  176,0,  
176,0,  176,0,  0,0,    176,0,  
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    176,0,  176,0,  
176,0,  176,0,  176,0,  186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  0,0,    
0,0,    186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  0,0,    186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  0,0,    186,0,  
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
186,0,  186,0,  186,0,  186,0,  
186,0,  186,0,  186,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    186,0,  186,0,  186,0,  
186,0,  0,0,    186,0,  0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
186,192,        0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    186,0,  186,0,  186,0,  
186,0,  186,0,  192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  0,0,    0,0,    
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  0,0,    192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  0,0,    192,0,  192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    192,0,  
192,0,  192,0,  192,0,  192,0,  
192,0,  192,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
192,0,  192,0,  192,0,  192,0,  
0,0,    192,0,  0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
0,0,    0,0,    0,0,    0,0,    
192,0,  192,0,  192,0,  192,0,  
192,0,  0,0,    0,0,    0,0,    
0,0};
struct yysvf yysvec[] = {
0,      0,      0,
yycrank+-1,     0,              yyvstop+1,
yycrank+0,      yysvec+1,       yyvstop+3,
yycrank+-4,     0,              yyvstop+5,
yycrank+-19,    yysvec+3,       yyvstop+7,
yycrank+-55,    0,              yyvstop+9,
yycrank+-26,    yysvec+5,       yyvstop+11,
yycrank+-154,   0,              yyvstop+13,
yycrank+-3,     yysvec+7,       yyvstop+15,
yycrank+-174,   0,              yyvstop+17,
yycrank+-12,    yysvec+9,       yyvstop+19,
yycrank+-190,   yysvec+3,       yyvstop+21,
yycrank+-247,   yysvec+3,       yyvstop+23,
yycrank+-275,   0,              yyvstop+25,
yycrank+-14,    yysvec+13,      yyvstop+27,
yycrank+-17,    yysvec+1,       yyvstop+29,
yycrank+-20,    yysvec+1,       yyvstop+31,
yycrank+-316,   0,              yyvstop+33,
yycrank+-14,    yysvec+17,      yyvstop+35,
yycrank+-337,   0,              yyvstop+37,
yycrank+0,      yysvec+19,      yyvstop+39,
yycrank+-357,   0,              yyvstop+41,
yycrank+0,      yysvec+21,      yyvstop+43,
yycrank+0,      0,              yyvstop+45,
yycrank+0,      0,              yyvstop+47,
yycrank+-385,   0,              yyvstop+49,
yycrank+0,      0,              yyvstop+52,
yycrank+0,      0,              yyvstop+55,
yycrank+6,      0,              yyvstop+58,
yycrank+0,      0,              yyvstop+61,
yycrank+15,     0,              yyvstop+64,
yycrank+0,      0,              yyvstop+67,
yycrank+0,      0,              yyvstop+71,
yycrank+0,      0,              yyvstop+74,
yycrank+0,      0,              yyvstop+78,
yycrank+0,      0,              yyvstop+82,
yycrank+0,      0,              yyvstop+86,
yycrank+29,     0,              yyvstop+90,
yycrank+406,    0,              yyvstop+93,
yycrank+0,      0,              yyvstop+97,
yycrank+0,      0,              yyvstop+101,
yycrank+-499,   0,              yyvstop+105,
yycrank+0,      0,              yyvstop+110,
yycrank+0,      0,              yyvstop+114,
yycrank+579,    0,              yyvstop+118,
yycrank+6,      yysvec+44,      yyvstop+123,
yycrank+8,      yysvec+44,      yyvstop+128,
yycrank+10,     yysvec+44,      yyvstop+133,
yycrank+11,     yysvec+44,      yyvstop+138,
yycrank+12,     yysvec+44,      yyvstop+143,
yycrank+0,      0,              yyvstop+148,
yycrank+-701,   0,              yyvstop+152,
yycrank+0,      0,              yyvstop+156,
yycrank+3,      0,              yyvstop+159,
yycrank+0,      0,              yyvstop+162,
yycrank+30,     0,              yyvstop+165,
yycrank+0,      0,              yyvstop+168,
yycrank+20,     0,              yyvstop+171,
yycrank+0,      0,              yyvstop+174,
yycrank+0,      0,              yyvstop+177,
yycrank+-704,   0,              yyvstop+180,
yycrank+0,      0,              yyvstop+183,
yycrank+0,      0,              yyvstop+186,
yycrank+0,      0,              yyvstop+189,
yycrank+0,      0,              yyvstop+192,
yycrank+26,     0,              yyvstop+195,
yycrank+36,     0,              yyvstop+198,
yycrank+0,      yysvec+66,      yyvstop+203,
yycrank+0,      yysvec+66,      yyvstop+209,
yycrank+0,      yysvec+66,      yyvstop+215,
yycrank+0,      yysvec+66,      yyvstop+221,
yycrank+17,     yysvec+66,      yyvstop+227,
yycrank+0,      yysvec+66,      yyvstop+232,
yycrank+762,    0,              yyvstop+238,
yycrank+0,      yysvec+73,      yyvstop+240,
yycrank+11,     yysvec+73,      yyvstop+242,
yycrank+-884,   0,              yyvstop+244,
yycrank+0,      0,              yyvstop+247,
yycrank+966,    0,              yyvstop+250,
yycrank+0,      0,              yyvstop+254,
yycrank+0,      0,              yyvstop+258,
yycrank+25,     yysvec+78,      yyvstop+262,
yycrank+-1088,  0,              yyvstop+266,
yycrank+0,      0,              yyvstop+269,
yycrank+-1091,  0,              yyvstop+272,
yycrank+0,      0,              yyvstop+275,
yycrank+0,      0,              yyvstop+278,
yycrank+-126,   yysvec+25,      yyvstop+281,
yycrank+0,      0,              yyvstop+283,
yycrank+22,     0,              0,      
yycrank+31,     0,              0,      
yycrank+0,      0,              yyvstop+285,
yycrank+0,      0,              yyvstop+287,
yycrank+209,    0,              yyvstop+289,
yycrank+0,      yysvec+38,      yyvstop+291,
yycrank+147,    0,              0,      
yycrank+0,      0,              yyvstop+293,
yycrank+-1205,  yysvec+41,      yyvstop+295,
yycrank+46,     yysvec+44,      yyvstop+298,
yycrank+68,     yysvec+44,      yyvstop+301,
yycrank+72,     yysvec+44,      yyvstop+304,
yycrank+78,     yysvec+44,      yyvstop+307,
yycrank+35,     yysvec+44,      yyvstop+310,
yycrank+49,     yysvec+44,      yyvstop+313,
yycrank+-176,   yysvec+51,      yyvstop+316,
yycrank+0,      0,              yyvstop+319,
yycrank+37,     0,              0,      
yycrank+42,     0,              0,      
yycrank+0,      0,              yyvstop+321,
yycrank+51,     0,              0,      
yycrank+-164,   yysvec+60,      yyvstop+323,
yycrank+0,      0,              yyvstop+325,
yycrank+0,      0,              yyvstop+327,
yycrank+0,      0,              yyvstop+329,
yycrank+0,      0,              yyvstop+331,
yycrank+0,      yysvec+73,      0,      
yycrank+197,    yysvec+73,      0,      
yycrank+-1332,  yysvec+76,      yyvstop+333,
yycrank+1205,   0,              0,      
yycrank+235,    0,              0,      
yycrank+0,      0,              yyvstop+335,
yycrank+0,      0,              yyvstop+337,
yycrank+0,      yysvec+78,      yyvstop+339,
yycrank+83,     yysvec+78,      yyvstop+341,
yycrank+-71,    yysvec+82,      yyvstop+343,
yycrank+-182,   yysvec+84,      yyvstop+345,
yycrank+66,     0,              0,      
yycrank+73,     0,              0,      
yycrank+180,    0,              0,      
yycrank+88,     0,              0,      
yycrank+100,    yysvec+44,      yyvstop+347,
yycrank+113,    yysvec+44,      yyvstop+350,
yycrank+137,    yysvec+44,      yyvstop+353,
yycrank+143,    yysvec+44,      yyvstop+356,
yycrank+145,    yysvec+44,      yyvstop+359,
yycrank+154,    yysvec+44,      yyvstop+362,
yycrank+84,     0,              0,      
yycrank+95,     0,              0,      
yycrank+100,    0,              0,      
yycrank+117,    yysvec+78,      yyvstop+365,
yycrank+128,    0,              0,      
yycrank+135,    0,              0,      
yycrank+146,    0,              0,      
yycrank+140,    0,              0,      
yycrank+137,    0,              0,      
yycrank+156,    yysvec+44,      yyvstop+367,
yycrank+175,    yysvec+44,      yyvstop+370,
yycrank+182,    yysvec+44,      yyvstop+373,
yycrank+188,    yysvec+44,      yyvstop+376,
yycrank+209,    yysvec+44,      yyvstop+379,
yycrank+-1459,  yysvec+41,      yyvstop+382,
yycrank+156,    0,              0,      
yycrank+164,    0,              0,      
yycrank+160,    0,              0,      
yycrank+181,    yysvec+78,      yyvstop+386,
yycrank+177,    0,              0,      
yycrank+186,    0,              0,      
yycrank+182,    0,              0,      
yycrank+191,    0,              0,      
yycrank+213,    0,              0,      
yycrank+215,    yysvec+44,      yyvstop+388,
yycrank+-1586,  yysvec+41,      yyvstop+391,
yycrank+216,    yysvec+44,      yyvstop+395,
yycrank+229,    yysvec+44,      yyvstop+398,
yycrank+232,    yysvec+44,      yyvstop+401,
yycrank+202,    0,              0,      
yycrank+206,    0,              0,      
yycrank+218,    0,              0,      
yycrank+215,    yysvec+78,      yyvstop+404,
yycrank+0,      0,              yyvstop+406,
yycrank+217,    0,              0,      
yycrank+223,    0,              0,      
yycrank+221,    0,              0,      
yycrank+227,    0,              0,      
yycrank+-1713,  yysvec+41,      yyvstop+408,
yycrank+-1840,  yysvec+41,      yyvstop+412,
yycrank+-1967,  yysvec+41,      yyvstop+416,
yycrank+256,    yysvec+44,      yyvstop+420,
yycrank+228,    0,              0,      
yycrank+242,    0,              0,      
yycrank+0,      0,              yyvstop+423,
yycrank+223,    yysvec+78,      yyvstop+425,
yycrank+0,      0,              yyvstop+427,
yycrank+238,    0,              0,      
yycrank+0,      0,              yyvstop+429,
yycrank+241,    0,              0,      
yycrank+-2094,  yysvec+41,      yyvstop+431,
yycrank+254,    0,              0,      
yycrank+247,    0,              0,      
yycrank+0,      yysvec+78,      yyvstop+434,
yycrank+246,    0,              0,      
yycrank+266,    0,              0,      
yycrank+-2221,  yysvec+41,      yyvstop+437,
yycrank+256,    0,              0,      
yycrank+261,    0,              0,      
yycrank+254,    0,              0,      
yycrank+378,    0,              0,      
yycrank+266,    0,              0,      
yycrank+258,    0,              0,      
yycrank+0,      0,              yyvstop+441,
yycrank+397,    0,              0,      
yycrank+259,    0,              0,      
yycrank+342,    0,              0,      
yycrank+405,    0,              0,      
yycrank+350,    0,              0,      
yycrank+402,    0,              0,      
yycrank+0,      0,              yyvstop+443,
yycrank+436,    0,              0,      
yycrank+0,      0,              yyvstop+445,
yycrank+0,      0,              yyvstop+447,
0,      0,      0};
struct yywork *yytop = yycrank+2348;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,'#' ,'$' ,01  ,01  ,01  ,
'(' ,'(' ,'$' ,01  ,01  ,01  ,'.' ,'/' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,';' ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,'A' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'r' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,';' ,01  ,';' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,
0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static  char ncform_sccsid[] = "@(#)ncform 1.2 86/10/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
        register struct yysvf *yystate, **lsp;
        register struct yywork *yyt;
        struct yysvf *yyz;
        int yych, yyfirst;
        struct yywork *yyr;
# ifdef LEXDEBUG
        int debug;
# endif
        char *yylastch;
        /* start off machines */
# ifdef LEXDEBUG
        debug = 0;
# endif
        yyfirst=1;
        if (!yymorfg)
                yylastch = yytext;
        else {
                yymorfg=0;
                yylastch = yytext+yyleng;
                }
        for(;;){
                lsp = yylstate;
                yyestate = yystate = yybgin;
                if (yyprevious==YYNEWLINE) yystate++;
                for (;;){
# ifdef LEXDEBUG
                        if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
                        yyt = yystate->yystoff;
                        if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
                                yyz = yystate->yyother;
                                if(yyz == 0)break;
                                if(yyz->yystoff == yycrank)break;
                                }
                        *yylastch++ = yych = input();
                        yyfirst=0;
                tryagain:
# ifdef LEXDEBUG
                        if(debug){
                                fprintf(yyout,"char ");
                                allprint(yych);
                                putchar('\n');
                                }
# endif
                        yyr = yyt;
                        if ( (int)yyt > (int)yycrank){
                                yyt = yyr + yych;
                                if (yyt <= yytop && yyt->verify+yysvec == yystate){
                                        if(yyt->advance+yysvec == YYLERR)       /* error transitions */
                                                {unput(*--yylastch);break;}
                                        *lsp++ = yystate = yyt->advance+yysvec;
                                        goto contin;
                                        }
                                }
# ifdef YYOPTIM
                        else if((int)yyt < (int)yycrank) {              /* r < yycrank */
                                yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
                                if(debug)fprintf(yyout,"compressed state\n");
# endif
                                yyt = yyt + yych;
                                if(yyt <= yytop && yyt->verify+yysvec == yystate){
                                        if(yyt->advance+yysvec == YYLERR)       /* error transitions */
                                                {unput(*--yylastch);break;}
                                        *lsp++ = yystate = yyt->advance+yysvec;
                                        goto contin;
                                        }
                                yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
                                if(debug){
                                        fprintf(yyout,"try fall back character ");
                                        allprint(YYU(yymatch[yych]));
                                        putchar('\n');
                                        }
# endif
                                if(yyt <= yytop && yyt->verify+yysvec == yystate){
                                        if(yyt->advance+yysvec == YYLERR)       /* error transition */
                                                {unput(*--yylastch);break;}
                                        *lsp++ = yystate = yyt->advance+yysvec;
                                        goto contin;
                                        }
                                }
                        if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
                                if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
                                goto tryagain;
                                }
# endif
                        else
                                {unput(*--yylastch);break;}
                contin:
# ifdef LEXDEBUG
                        if(debug){
                                fprintf(yyout,"state %d char ",yystate-yysvec-1);
                                allprint(yych);
                                putchar('\n');
                                }
# endif
                        ;
                        }
# ifdef LEXDEBUG
                if(debug){
                        fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
                        allprint(yych);
                        putchar('\n');
                        }
# endif
                while (lsp-- > yylstate){
                        *yylastch-- = 0;
                        if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
                                yyolsp = lsp;
                                if(yyextra[*yyfnd]){            /* must backup */
                                        while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
                                                lsp--;
                                                unput(*yylastch--);
                                                }
                                        }
                                yyprevious = YYU(*yylastch);
                                yylsp = lsp;
                                yyleng = yylastch-yytext+1;
                                yytext[yyleng] = 0;
# ifdef LEXDEBUG
                                if(debug){
                                        fprintf(yyout,"\nmatch ");
                                        sprint(yytext);
                                        fprintf(yyout," action %d\n",*yyfnd);
                                        }
# endif
                                return(*yyfnd++);
                                }
                        unput(*yylastch);
                        }
                if (yytext[0] == 0  /* && feof(yyin) */)
                        {
                        yysptr=yysbuf;
                        return(0);
                        }
                yyprevious = yytext[0] = input();
                if (yyprevious>0)
                        output(yyprevious);
                yylastch=yytext;
# ifdef LEXDEBUG
                if(debug)putchar('\n');
# endif
                }
        }
yyback(p, m)
        int *p;
{
if (p==0) return(0);
while (*p)
        {
        if (*p++ == m)
                return(1);
        }
return(0);
}
        /* the following are only used in the lex library */
yyinput(){
        return(input());
        }
yyoutput(c)
  int c; {
        output(c);
        }
yyunput(c)
   int c; {
        unput(c);
        }
