/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
/*****************************************************************************
 * 
 * Error handling routines for isis_pre
 *
 *  by : Cheong, Weng Seng
 *       Dept of Computer Science
 *       Cornell University
 *
 *****************************************************************************/
#include <sys/file.h>    /* file i/o functions */
#include <stdio.h>       /* i/o standard library functions */
#include <string.h>      /* string manipulation functions */
#include <ctype.h>

#include "pp_const.h"       /* constant definitions */
#include "pp_global.h"
extern int  errno, sys_nerr;
extern char *sys_errlist[];

/*
 * print the error messages which occured in calling function
 * print string m with format f, 
 *   and, if errno is valid, print message from global sys_errlist[]
 * 
 * This routine was adapted from K&P "UNIX ... environment" pg 207
 */
void sys_error(f, m)
        char *f, *m;
{
        fprintf(stderr, f, m);
        if (errno > PP_NULLERROR && errno < sys_nerr)
                fprintf(stderr,"(%s)",sys_errlist[errno]);
        fprintf(stderr,"\n");
        errno = PP_NULLERROR;
}

/*
 * print the error messages which occured in the calling function
 * print interger m with format f, 
 *   and, if errno is valid, print message from global sys_errlist[]
 * 
 * This routine was adapted from K&P "UNIX ... environment" pg 207
 */
void sys_Ierror(f, m)
        char    *f;
        int     m;
{
        fprintf(stderr, f, m);
        if (errno > PP_NULLERROR && errno < sys_nerr)
                fprintf(stderr,"(%s)",sys_errlist[errno]);
        fprintf(stderr,"\n");
        errno = PP_NULLERROR;
}

/*
 * fatal error ! print message and halt immediately
 */
void    halt(m)
        char    *m;
{
        fprintf(stderr, m);
        fprintf(stderr, "\n");
        exit(1);
}

/*
 * fatal error ! print message and halt immediately
 */
void    halt2(f, m)
        char    *f,*m;
{
        fprintf(stderr, f, m);
        fprintf(stderr, "\n");
        exit(1);
}

/* 
 * Resynchronized input by skipping thru the declaration of the function
 * The function body is presumed to be delimited by { .... }
 */
void    resync_skip_declaration()
{
        register int    found = PP_FALSE,i = 0;

        while (!found) {
                switch (getchar()) {
                        case '{':       i++; break;
                        case '}':       if (i-- == 1) found = PP_TRUE;
                                        break;
                        case '\n':      pp_lineno++; break;             
                        default:        /*skip */;
                }
        }
}
        

        
