/*
 * ISIS System V1.0 (8/15/88).   Report problems to isis-bugs@gvax.cs.cornell.edu 
 * Note: Export restrictions apply.  License required for export to ``non-free world''
 * countries (USDC terminology).  Agreement to respect this export restriction required
 * for export to all other countries.
 */
/*******************************************************************************
 *
 * pp_const.h
 *
 *******************************************************************************/

/* size of data structure */
#define PP_BLKSIZE              512     /* disk block size (in bytes) */
#define PP_NO_OF_LEX_BUF        2       /* no of buffers used by lex to store
                                         * tokens */
#define PP_BUFSIZE              256     /* max chars in the text buffer */
#define PP_MAX_FILE_CHAR        128     /* maximum character of in a filename */
#define PP_MAX_NO_FUNCTION      40      /* max number of rpc functions allowed
                                         * to be called by a source file (N.B.
                                         * this includes imported and exported 
                                         * functions) */
#define PP_MAX_FUNCTION_CHAR    32      /* max chars in a function name */
#define PP_MAX_TYPE_CHAR        16      /* max chars in an function or parameter                                                 * type */
#define PP_MAX_NO_PARA          8       /* max no of parameters allowed in an rpc                                                * func */
#define PP_MAX_PARA_CHAR        16      /* max char in a parameter name */
#define PP_MAX_BTYPE_CHAR       6       /* max of broadcast type length (refer to
                                         * ISIS documentation ) */

/* mode code */
#define PP_NORMAL       1
#define PP_MAKELIB      2

/* synchronize line scope constants */
#define PP_CALL         20
#define PP_RCV          21
#define PP_ALL          22

/* char indicator for function name which are imported or exported */
#define PP_FROM_EXPORT  '0'
#define PP_FROM_IMPORT  '1'
#define PP_FROM_IM_EXPORT '2'

/* constants of type of rpc function information */
#define PP_F_NAME       999
#define PP_F_TYPE       998
#define PP_B_TYPE       997
#define PP_F_FMT        996

/* type category indicators */
#define PP_ADDRESS_TYPE 1
#define PP_CHAR_TYPE    2
#define PP_LONG_TYPE    3
#define PP_SHORT_TYPE   4
#define PP_NONSTD_TYPE  5

#define PP_TRUE    1
#define PP_FALSE   0
#define PP_ERROR   -1
#define PP_OK      0
#define PP_EQUAL   0

#define PP_NULLERROR    0       /* value of global variable errno when
                                * no error occured   */
#define PP_NULLSTR      ""

