/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */

#include    "grid.h"
#include    <stdio.h>
#include    <signal.h>
#include    <X11/Xlib.h>

char        name[19];
int         namelen;
Display     *dpy;
GC          gc;
int         screen;
XFontStruct *font;
int         black, white;
short       width, height;
int         twidth, theight, titleheight;
int         joined = 0;         
int         bdrwidth;
Window      win;

init_display(displayname, fontname, x, y)
  char *displayname, *fontname;
  int x, y;
{
    register int    i;

    gethostname (name, 19);
    for (namelen = 0; name[namelen] && name[namelen] != '.' && namelen < 18;
                                                                    namelen++)
        continue;
    name[namelen] = '\0';
        
    dpy = XOpenDisplay (displayname);
    screen = DefaultScreen(dpy);
    gc = DefaultGC(dpy, screen);
    black = BlackPixel(dpy, screen);
    white = WhitePixel(dpy, screen);
    if ((font = XLoadQueryFont (dpy, fontname)) == 0) {
        panic("can't find font");
    }
    XSetFont(dpy, gc, font-> fid);
    width = font->max_bounds.rbearing - font->min_bounds.lbearing;
    height = font->ascent + font->descent;
    twidth = 48 * width + 6;
    titleheight = 3 * height + 1;
    theight = titleheight + 24 * height + 6;
    bdrwidth = 2;

    win = XCreateSimpleWindow (dpy, RootWindow(dpy, screen),
                               x, y, twidth, theight, bdrwidth, black, white);
       /* The x and y positions here don't seem to do anything: the
          window manager grabs control of placement regardles. */
    XStoreName(dpy, win, name);
    XMapRaised (dpy, win);
    if (x != 0 && y != 0) { /* Hack to move window where I want it. */
        XMoveWindow (dpy, win, x, y);
    }
    XSelectInput (dpy, win, ExposureMask | ButtonPressMask);
    display_all();
    start ();
    return (dpy-> fd);
}


display (x, y)
  int   x, y;
{
    char            data[7];
    int             fore, back;
    int             dlen;
    register int    bx, by;

    if (color[x][y])
    {
        fore = white;
        back = black;
    }
    else
    {
        fore = black;
        back = white;
    }
    sprintf (data, "%d", value[x][y]);
    dlen = strlen (data);
    bx = 6 * x * width + x;
    by = titleheight + 3 * y * height + y;


    XSetForeground(dpy, gc, back);
    XFillRectangle(dpy, win, gc, bx, by, 6*width, 3*height);
    XSetForeground(dpy, gc, fore);
    XSetBackground(dpy, gc, back);
    XDrawImageString(dpy, win, gc,
                     bx + (6 - dlen) * width / 2, by + height + font->ascent,
                     data, dlen);
    XSetForeground(dpy, gc, black);
    XSetBackground(dpy, gc, white);
    XFlush(dpy);
}


display_all()
{
    register int    i, j;

    XFillRectangle(dpy, win, gc, 0, titleheight - 1, twidth, 1);
    for (i = 1; i < 8; i++)
        XFillRectangle(dpy, win, gc, 0, titleheight+3*i*height+i-1, twidth, 1);
    for (i = 1; i < 8; i++)
        XFillRectangle(dpy, win, gc, 6*i*width+i-1, 3*height, 1, theight);
    display_title();
    for (i = 0; i < 8; i++)
        for (j = 0; j < 8; j++)
            display (i, j);
}

display_title()
{
    register int    i;
    register char   *str; 
    char            string[13];

    XDrawImageString(dpy, win, gc, width, height + font->ascent,
                     name, namelen);

    if (joined && n_memb > 0)
    {
        sprintf (string, "(%d member%s)", n_memb, (n_memb == 1 ? "" : "s"));
        for (i = strlen (string); i < 12; i++)
            strcat (string, " ");
        XDrawImageString(dpy, win, gc, 18*width+3, height + font->ascent,
                         string, 12);
    }

    str = (mode == AB_MODE ? "abcast" : (mode == CB_MODE ? "cbcast" :
                                    (mode == GB_MODE ? "gbcast" : "random")));
    XDrawImageString(dpy, win, gc, 30*width+5, height + font->ascent, str, 6);
                                                                 
    str = (joined ? "exit" : "join");
    XDrawImageString(dpy, win, gc, 37*width+6, height + font->ascent, str, 4);

    str = (go ? "stop" : " go ");
    XDrawImageString(dpy, win, gc, 43*width+7, height + font->ascent, str, 4);
    XFlush(dpy);
}


display_input()
{
    XEvent      event;

    do
    {
        XNextEvent (dpy, &event);
        if (((XButtonEvent *) &event)-> window == win)
            if (event.type == Expose)
                display_all();
            else if (event.type == ButtonPress)
                if ((((XButtonEvent *) &event)->y < titleheight) &&
                       (((XButtonEvent *) &event)->x > 36 * width + 6))
                    if (((XButtonEvent *) &event)->x > 42 * width + 7)
                    {
                        go = (go ? 0 : 1);
                        display_title();
                        if (go)
                           update();
                    }
                    else
                        exit();
    }
    while (QLength(dpy) != 0);
}


start()
{
    XEvent      event;

    while (!joined)
    {
        XNextEvent  (dpy, &event);
        if (((XButtonEvent *) &event)-> window == win)
            if (event.type == Expose)
                display_all();
            else if (event.type == ButtonPress)
                if (((XButtonEvent *) &event)->y < titleheight)
                    if ((((XButtonEvent *) &event)->x > 30 * width + 5) &&
                             (((XButtonEvent *) &event)->x < 42 * width + 6))
                    {
                        if (((XButtonEvent *) &event)->x < 36 * width + 5)
                            mode = (mode == AB_MODE ? CB_MODE :
                                     (mode == CB_MODE ? GB_MODE :
                                       (mode == GB_MODE ? NO_MODE : AB_MODE)));
                        else
                            joined = go = 1;
                        display_title();
                    }

    }
}
