/* Written by Alex Siegel at Cornell University 9/88 */
/* This module has simple unit and army manipulation routines */

#include <stdio.h>
#include "config.h"
#include "gdefs.h"

extern long getval();

/* Return the cost of an entire unit */
long unitcost(unit)
armyunit *unit;
/* unit - pointer to unit structure */
{
  return(unit->count*(getval(unit->platf,COST) +
					  getval(unit->weapon,COST) +
					  getval(unit->armor,COST)));
}

/* Return the technology level of a unit */
long unittech(unit)
armyunit *unit;
/* unit - pointer to unit structure */
{
  long t1,t2,t3;

  t1 = getval(unit->platf,TECH);
  t2 = getval(unit->weapon,TECH);
  t3 = getval(unit->armor,TECH);

  return(max(max(t1,t2),t3));
}

/* Load in an army.  Return a pointer to the newly allocated army. */
army *loadarmy(fid)
FILE *fid;
/* fid - input file */
{
  army *curarm;
  /* curarm - pointer to current army */
  long cost,tech;
  /* cost - army cost
	 tech - technology level */

  /* Load in cost and technology level */
  fread(&cost,sizeof(long),1,fid);
  fread(&tech,sizeof(long),1,fid);
  printf("Total cost is %d.  Technology level is %d.\n",cost,tech);

  /* Allocate army */
  curarm = (army *) malloc(sizeof(army));
  /* Read in size of army */
  fread(&(curarm->size),sizeof(short),1,fid);
  /* Allocate unit array */
  curarm->units = (armyunit *) malloc(curarm->size *
									  sizeof(armyunit));
  /* Read in unit array */
  fread(curarm->units,sizeof(armyunit),curarm->size,fid);

  /* Return pointer to new army */
  return(curarm);
}

/* Save an army to a file.  This is the logical reverse of loadarmy() */
savearmy(fid,curarm)
FILE *fid;
/* fid - output file */
army *curarm;
/* curarm - pointer to army to be saved */
{
  long cost,tech,ntech;
  /* cost - army total cost
	 tech,ntech - technological level */
  int i;
  /* i - loop variable */

  /* Compute cost and technology level */
  cost = 0;
  tech = 0;
  for(i=0;i<curarm->size;++i) {
	cost += unitcost((curarm->units) + i);
	ntech = unittech((curarm->units) + i);
	tech = max(tech,ntech);
  }
  printf("Total cost is %d.  Technology level is %d.\n",cost,tech);

  /* Save cost and technology level */
  fwrite(&cost,sizeof(long),1,fid);
  fwrite(&tech,sizeof(long),1,fid);
  /* Write out army size */
  fwrite(&(curarm->size),sizeof(short),1,fid);
  /* Write out unit array */
  fwrite(curarm->units,sizeof(armyunit),curarm->size,fid);
}
