/* Written by Alex Siegel at Cornell University 9/88 */
/* This module allows the user to reassign unit positions with X */
/* windows graphics. */

#include <stdio.h>
#include <X11/Xlib.h>
#include "config.h"
#include "gdefs.h"
#include <math.h>

extern float xfact,yfact;
extern long xmin,ymin;
extern Display *disp;
extern Window wind;

/* X windows error handler.  It just describes the error and quits. */
xerrhandle(disp,err)
Display *disp;
XErrorEvent *err;
{
  char buf[100];
  int len;

  XGetErrorText(disp,err->error_code,buf,&len);

  printf("X error!  Op code = %d: %s\n",err->request_code,buf);
  exit(-1);
}

/* X windows event mask */
#define EVMASK ButtonPressMask | ButtonReleaseMask | ExposureMask | EnterWindowMask | KeyPressMask

/* Reassign positions for all the army units graphicaly */
movepos(curarm)
army *curarm;
/* curarm - pointer to army to be manipulated */
{
  XEvent xev;
  /* xev - current X event */
  int grabbed,i;
  /* grabbed - unit number which has been grabbed for moving
	 i - loop variable */
  long truex,truey,xav,yav;
  /* truex,truey - true game coordinates of mouse
	 xav,yav - average unit position for army */
  float mindist,xdif,ydif;
  /* mindist - minimum distance to unit from mouse position
	 xdif,ydif - x and y distance between mouse and unit */
  armyunit *curunit;
  /* curunit - pointer to current army unit */

  /* Print directions */
  printf("Press left button to drag a unit.\n");
  printf("Press right button and keyboard key to return to army generator.\n");

  /* Set X error handler */
  XSetErrorHandler(xerrhandle);
  /* Make tactical map */
  makemap();
  /* Select appropriate input */
  XSelectInput(disp,wind,EVMASK);
  /* Loop until termination event */
  do {
	/* Get next window event */
	XWindowEvent(disp,wind,EVMASK,&xev);
	/* If expose event, redraw screen */
	if(xev.type == Expose)
	  drawmap(curarm,1);
	/* If button press, grab a unit */
	else if((xev.type == ButtonPress) && (xev.xbutton.button == Button1)) {
	  /* Get true coordinate of mouse */
	  truex = xev.xbutton.x/xfact + xmin;
	  truey = xev.xbutton.y/yfact + ymin;
	  /* Get pointer to first army unit */
	  curunit = curarm->units;
	  /* Get distance to first army unit as an initialization step */
	  xdif = truex - curunit->xpos;
	  ydif = truey - curunit->ypos;
	  mindist = sqrt(xdif*xdif + ydif*ydif);
	  grabbed = 0;
	  /* Loop through army units and find the closest one to the mouse */
	  for(i=1;i<curarm->size;++i) {
		/* Get pointer to unit */
		curunit = curarm->units + i;
		/* Get distance from mouse coordinate */
		xdif = truex - curunit->xpos;
		ydif = truey - curunit->ypos;
		/* Check to see if it is closer than previous candidate */
		if(mindist > sqrt(xdif*xdif + ydif*ydif)) {
		  mindist = sqrt(xdif*xdif + ydif*ydif);
		  grabbed = i;
		}
	  }
	  /* Erase old position of unit */
	  drawunit(curarm,grabbed,0,1);
	}
	/* If button release, drop a unit */
	else if(xev.type == ButtonRelease) {
	  /* Get true game coordinate of mouse */
	  truex = (xev.xbutton.x/xfact + 0.5) + xmin;
	  truey = (xev.xbutton.y/yfact + 0.5) + ymin;
	  /* Assign new position to unit */
	  curunit = curarm->units + grabbed;
	  curunit->xpos = truex;
	  curunit->ypos = truey;
	  /* Draw new copy of unit */
	  drawunit(curarm,grabbed,0,1);
	}
	/* If mouse enters window, raise the window */
	else if(xev.type == EnterNotify)
	  XRaiseWindow(disp,wind);
	/* Flush out X commands */
	XFlush(disp);
  } while(((xev.type != ButtonPress) || (xev.xbutton.button != Button3)) &&
		  (xev.type != KeyPress));

  /* Re center the units so that the average position is at 0,0 */
  printf("Recentering positions...\n");
  /* Calculate average position */
  xav = 0;
  yav = 0;
  for(i=0;i<curarm->size;++i) {
	curunit = curarm->units + i;
	xav += curunit->xpos;
	yav += curunit->ypos;
  }
  xav /= curarm->size;
  yav /= curarm->size;
  /* Adjust unit positions accordingly */
  for(i=0;i<curarm->size;++i) {
	curunit = curarm->units + i;
	curunit->xpos -= xav;
	curunit->ypos -= yav;
  }

  /* Destroy the tactical map */
  killmap();
}
