/* Written by Alex Siegel at Cornell University 9/88 */
/* This module has simple item description manipulation routines. */

#include <stdio.h>
#include "gdefs.h"
#include "config.h"

/* Label string descriptor fields */
typedef char *string;
static string labdescr[] = {  "value",
								"type",
								"bulk",
								"hardness",
								"range",
								"hits",
								"hitprob",
								"(unused)",
								"damage",
								"speed",
								"sptype",
								"spbonus",
								"(unused)",
								"charges",
								"capacity",
								"evasiveness",
								"attacks",
								"technology"
								};

/* Load the item description data blocks from the data file.  This */
/* data must be predigested with icomp. */
loaddata()
{
  FILE *infile;
  /* infile - input file */

  /* Open input file */
  infile = fopen(DATAFILE,"r");
  if(infile == NULL) {
	perror(DATAFILE);
	exit(-1);
  }

  /* Read in label value pairs */
  /* Read in number of values */
  fread(&numvals,sizeof(long),1,infile);
  /* Allocate array for values */
  itemdata = (labval *) malloc(numvals*sizeof(labval));
  /* Read in label value pairs as a block */
  fread(itemdata,sizeof(labval),numvals,infile);

  /* Read in list of general items */
  fread(&numitem,sizeof(int),1,infile);
  itemlist = (genitem *) malloc(numitem*sizeof(genitem));
  fread(itemlist,sizeof(genitem),numitem,infile);

  /* Read in name list data block */
  fread(&nameslen,sizeof(long),1,infile);
  names = (char *) malloc(nameslen*sizeof(char));
  fread(names,sizeof(char),nameslen,infile);

  /* Close input file */
  fclose(infile);
}

/* Save the item description data blocks to the data file.  This is */
/* the logical reverse of loaddata(). */
savedata()
{
  FILE *outfile;
  /* outfile - output file */

  /* Open output file */
  outfile = fopen(DATAFILE,"w");
  if(outfile == NULL) {
	perror(DATAFILE);
	exit(-1);
  }

  /* Write out label value pairs */
  fwrite(&numvals,sizeof(long),1,outfile);
  fwrite(itemdata,sizeof(labval),numvals,outfile);

  /* Write out list of general items */
  fwrite(&numitem,sizeof(int),1,outfile);
  fwrite(itemlist,sizeof(genitem),numitem,outfile);

  /* Write out name list data block */
  fwrite(&nameslen,sizeof(long),1,outfile);
  fwrite(names,sizeof(char),nameslen,outfile);

  /* Close output file */
  fclose(outfile);
}

/* Print the name and item number of an item */
dispname(inum)
	 int inum;
{
  printf("%s (%d)\n",names+itemlist[inum].namepos,inum);
}

/* Return true is s1 is a substring of s2 */
int substr(s1,s2)
	 char *s1,*s2;
{
  register int i,j;
  /* i,j - loop variables */
  
  for(i=0;s2[i];++i) {
	for(j=0;s1[j] && (s1[j] == s2[i+j]);++j) ;
	if(! s1[j])
	  return(1);
  }
  return(0);
}

/* Return the number of the first label which pat is a substring of */
long labmatch(pat)
	 char *pat;
{
  int i;

  for(i=0;i<NUMFIELD;++i)
	if(substr(pat,labdescr[i]))
	  return(i);
  return(-1);
}

/* Get the value for a label from an item.  Return 0 if the item does */
/* not have that label or item is -1. */
long getval(inum,lab)
short inum,lab;
/* inum - item number
   lab - numeric label */
{
  register int i;
  /* i - loop variable */

  if(inum != -1)
	/* Loop through item value list looking for that label */
	for(i=itemlist[inum].datapos;itemdata[i].label != LASTLAB;++i) {
	  /* Found it, return the value */
	  if(itemdata[i].label == lab)
		return(itemdata[i].val);
	}
  /* Could not find it, return a 0 */
  return(0);
}
