/* Written by Alex Siegel at Cornell University 9/88 */
/* This module is the main program for icomp.  It compiles items from */
/* textual format into a compact predigested format which is */
/* convenient to load and use. */

#include <stdio.h>
#include "gdefs.h"

extern int substr();

/* Load the next labal/value pair from a file.  Return LASTLAB if at end of line */
loadval(inf,l,v)
FILE *inf;
/* inf - input file */
int *l;
/* l - label  RETURN VALUE! */
long *v;
/* v - value  RETURN VALUE! */
{
  char buf[50],c;
  /* buf - label string buffer
	 c - single input character */

  /* Clear past blanks */
  while((c=fgetc(inf)) == ' ') ;
  /* If at end of line, return label as LASTLAB */
  if(c == '\n') {
	*l = LASTLAB;
	return;
  }
  /* Push back last character */
  else
	ungetc(c,inf);
  /* Read in label */
  fscanf(inf,"%s",buf);
  /* Find out numeric value for label */
  *l = labmatch(buf);
  if(*l == -1) {
	fprintf(stderr,"Unknown field (%s).\n",buf);
	exit(-1);
  }
  /* Load in value */
  fscanf(inf," %d",v);
}

main(argc,argv)
int argc;
char **argv;
{
  FILE *infile;
  /* infile - input file */
  int l,curitem;
  /* l - current label
	 curitem - number of current item */
  long v,curname,curval;
  /* v - current value
	 curname - current position in name array of item name
	 curval - current position in value array of item */
  char buf[100];
  /* buf - line input buffer */

  /* Check number of command line arguments */
  if(argc < 2) {
	printf("usage: icomp inputfile\n");
	exit(-1);
  }
  
  /* Open text input file */
  infile = fopen(argv[1],"r");
  if(infile == NULL) {
	perror(argv[1]);
	exit(-1);
  }

  /* Initialize position in name and value array */
  numitem = 0;
  numvals = 0;
  nameslen = 0;
  /* Determine length of name and value arrays */
  while(! feof(infile)) {
	/* Load in item name */
	if(! fgets(buf,100,infile))
	  break;
	/* Chop off trailing new line */
	buf[strlen(buf) - 1] = '\0';
	/* If comment or blank line, ignore */
	if((buf[0] == '\0') || (buf[0] == '#') || (buf[0] == '\n')) continue;
	/* Add to size of name buffer */
	numitem++;
	nameslen += strlen(buf) + 1;
	/* Read past and count number of value fields */
	do {
	  loadval(infile,&l,&v);
	  numvals++;
	} while((l != LASTLAB) && (! feof(infile)));
  }
  printf("%d items  %d fields\n",numitem,numvals);

  /* Start again */
  rewind(infile);
  curname = 0;
  curval = 0;
  curitem = 0;
  /* Allocate name and item arrays */
  itemdata = (labval *) malloc(numvals * sizeof(labval));
  itemlist = (genitem *) malloc(numitem * sizeof(genitem));
  names = (char *) malloc(nameslen * sizeof(char));
  /* Read in items */
  while(! feof(infile)) {
	/* Read in item name */
	if(! fgets(buf,100,infile))
	  break;
	/* Chop off trailing new line */
	buf[strlen(buf) - 1] = '\0';
	/* Skip past comments and blank lines */
	if((buf[0] == '\0') || (buf[0] == '#') || (buf[0] == '\n')) continue;
	/* Store position of name and values */
	itemlist[curitem].namepos = curname;
	itemlist[curitem].datapos = curval;
	/* Store name in name array */
	strcpy(names + curname,buf);
	curitem++;
	curname += strlen(buf) + 1;
	/* Load in all label/value pairs for this item */
	do {
	  /* Load label/value pair */
	  loadval(infile,&l,&v);
	  /* Store label and value */
	  itemdata[curval].label = l;
	  itemdata[curval].val = v;
	  curval++;
	} while((l != LASTLAB) && (! feof(infile)));
  }

  /* Save compact form of data in data file */
  savedata();
}
