/* Generic labelled value for describing a parameter of an item */
struct labval_ {
  short label;		/* Label.  See list below */
  long val;			/* Value corresponding to this label */
};

/* Possible labels.  Must correspond exactly to labdescr array defined */
/* in manip.c */
#define COST	0
/* Cost in "dollars" for one item */
#define TYPE	1
/* Type of item.  See values below */
#define BULK	2
/* Generic bulk of item */
#define HARD	3
/* Hardness.  Number of points of damage that can be taken without */
/* serious effect. */
#define RANGE	4
/* Weapon range in meters */
#define HITS	5
/* Hit points */
#define HITPROB	6
/* Base chance in percent of hitting at maximum range. */
#define DAMAG	8
/* Average weapon damage */
#define SPEED	9
/* Meters travelled at normal speed in 10 seconds when unencumbered */
#define SPTYPE	10
/* Special type.  See values below */
#define SPBON	11
/* Special bonus.  For armor this means special defense against */
/* certain kinds of attack. */ 
#define CHARGE	13
/* Charges.  Number of attacks until out of ammunition */
#define CAPAC	14
/* Total carrying capacity of platform. */
#define EVAS	15
/* Evasiveness bonus */
#define ATTACKS 16
/* Number of attacks per 10 second turn */
#define TECH	17
/* Technological level */
#define NUMFIELD 18
/* Total number of fields */

/* Flag for last label in a list */
#define LASTLAB -1

/* Values for type field */
#define PLATFORM 0
#define WEAPON 1
#define ARMOR  2

/* Values for special type field */
#define FIRE     1
#define COLD     2
#define ELECTRIC 3

typedef struct labval_ labval;

/* Big array of parameters for each item layed out sequentially.  Each */
/* item is terminate with a LASTLAB.  Beginnings of each item are */
/* listed in the itemlist array. */
labval *itemdata;

/* Description for a general item */
struct genitem_ {
  long datapos;		/* Offset with itemdata array for information */
  long namepos;		/* Offset with names array to find name */
};

typedef struct genitem_ genitem;

/* Array of items with descriptions of how to get information about */
/* them. */
genitem *itemlist;

char *names;		/* Block of string names */

long numvals;		/* Number of labval fields in itemdata */
int numitem;		/* Number of general items */
long nameslen;		/* Length of names data block */

/* Description of a combat unit */
struct armyunit_ {
  short platf;			/* Item number of platform type */
  short weapon;			/* Item number of weapon type */
  short armor;			/* Item number of armor type */
  short count;			/* Number of elements in this unit */
  long tothits;			/* Cumulative hit points of unit */
  short moral;			/* Current moral (between -10 and +10) */
  short charges;		/* Number of charges left on weapon */
  long xpos,ypos;		/* Position of unit */
  short division;		/* Division number of unit */
  char movmode,targmode,attmode;	/* Description of current order */
  short targunit;		/* Target unit for use when targmode == FOLLOW */
  long targx,targy;		/* Target position when targmode == POSIT */
};

/* Possible values for movement, targeting, and attack mode */
/* c - run forward towards goal at 200% normal speed;
       decreases defense by 50%
   f - move forward at normal speed
   n - move forward
   s - stand in place; increases defense by 50%
   r - make a careful retreat at normal speed
   ! - run away at 150% normal speed; attmode must by NONE */
#define CHASE	'c'
#define FORWARD	'f'
#define STAND	's'
#define RETREAT	'r'
#define RUNAWAY	'!'

/* n - go to/retreat from nearest hostile unit
   f - follow a unit in the same army
   p - go to/retreat from a specific coordinate (targx,targy)
   c - go to/retreat from average position of hostile forces */
#define NEAREST	'n'
#define FOLLOW  'f'
#define POSIT	'p'
#define CENTER	'c'

/* a - attack nearest hostile unit
   d - use careful defensive tactics; increases defense by 50%
   n - do not attack and no special defense */
#define ATTACK	'a'
#define DEFEND	'd'
#define NONE	'n'

typedef struct armyunit_ armyunit;

/* Structure for holding an army for one player */
struct army_ {
  short    size;		/* Number of units */
  armyunit *units;		/* Pointer to array of units */
};

typedef struct army_ army;

/* Unit update description structure */
struct update_ {
  char type;		/* Type of update, defined below */
  short index;		/* Index of army for update */
  short unit;		/* Unit number to be updated */
  union {			/* Union of new values */
    struct {		/* New position */
      long x,y;
    } pos;
    short count;	/* New number of troops */
    struct {
      long avdam;	/* Average damage per attack */
      short sptype;	/* Special type of attack */
	  short numb;	/* Number of attacks */
    } hit;
  } new;
};

typedef struct update_ update;

/* Update types: position = p,count = c,hits = h */
#define POS_UPD	'p'
#define CNT_UPD 'c'
#define HIT_UPD 'h'

/* Generic macro for getting maximum of two values */
#define max(x,y) ((x) > (y) ? (x) : (y))
