/* Written by Alex Siegel at Cornell University 9/88 */
/* This module is called by simul.c and it handles the user commands */
#include "gdefs.h"
#include "config.h"
#include "isis/isis.h"

/* This is the isis entry for the routine which handles messages for players */
#define GET_TALK_ENTRY	3

extern army *myarmy,battle[MAXPLAYER];
extern int numarmy,myindex;
extern long mytime;
extern int quitflag,verbflag;
extern int get_talk();
extern int gamespeed;
extern address gaddr;

char curmode='a';
/* curmode - current selection mode, a=all d=division u=unit */
int curselect=0;
/* curselect - current selection value */

/* This routine returns true if the argument is a unit which is currently selected */
int isselected(unum)
int unum;
/* unum - unit number to be tested */
{
  /* If the unit is dead, then it can not be selected */
  if(battle[myindex].units[unum].count == 0)
	return(0);
  /* If curmode is all, everything is selected */
  if(curmode == 'a')
	return(1);
  /* If curmode is unit, make sure it has the right unit number */
  if((curmode == 'u') && (unum == curselect))
	return(1);
  /* If curmode is division, make sure it has the right division */
  if((curmode == 'd') && (battle[myindex].units[unum].division == curselect))
	return(1);
  /* Otherwise return false */
  return(0);
}

/* This routine handles terminal input, it is called by isis */
keyhandler(arg)
int arg;
/* arg - isis argument */
{
  char buf[100];
  /* buf - input line buffer */
  int i,flag,temp;
  /* i - loop variable
	 flag - temporary flag
	 temp - temporary input value storage */
  armyunit *curunit;
  /* curunit - current army unit */

  /* Check for end of file */
  if(feof(stdin))
	confquit(0);

  /* Read in one line of input */
  gets(buf);

  /* Switch on the first command character */
  switch(buf[0]) {
	/* Quit the game */
  case 'q': case 'Q': case EOF:
	confquit(0);
	break;

	/* Change which units are selected */
  case 's': case 'S':
	/* Switch on second character */
	switch(buf[1]) {
	  /* If there is a number, assume it is a unit selection */
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
	  curmode = 'u';
	  sscanf(buf+1,"%d",&curselect);
	  break;
	  /* Individual unit selection */
	case 'u': case 'U':
	  curmode = 'u';
	  sscanf(buf+2,"%d",&curselect);
	  break;

	  /* Select all units */
	case 'a': case 'A':
	  curmode = 'a';
	  break;

	  /* Select a division */
	case 'd': case 'D':
	  curmode = 'd';
	  sscanf(buf+2,"%d",&curselect);
	  break;

	  /* Print out list of options */
	case '?':
	  puts("sa - select all units");
	  puts("sd<division number> - select a division of units");
	  puts("su<unit number> -or- s<unit number> - select a specific unit");
	  break;

	  /* Catch funny commands */
	default:
	  puts("Enter s? for a list of possible selections.");
	  return;
	}
	/* Echo a list of selected units for verification */
	printf("Units selected:\n");
	flag = 0;
	for(i=0;i<battle[myindex].size;++i)
	  if(isselected(i)) {
		printf("%d ",i);
		flag = 1;
	  }
	/* If no units are selected, say so */
	if(flag == 0)
	  printf("(none)");
	putchar('\n');
	break;

	/* Inquire about the status of currently selected units */
  case 'i': case 'I':
	/* Keep flag to check to see if any units were displayed */
	flag = 0;
	/* Go through all selected units */
	for(i=0;i<battle[myindex].size;++i)
	  if(isselected(i)) {
		/* List numeric size,hits,ammo, and moral */
		curunit = (battle[myindex].units) + i;
		printf("#%d : Strength = %d  Total hits = %d",
			   i,curunit->count,curunit->tothits);
		if(curunit->charges >= 0)
		  printf("  Ammo = %d",curunit->charges);
		printf("  Moral = %d ",curunit->moral);
		/* Print English version of moral for effect */
		if(curunit->moral <= -9)
		  printf("(defeated)\n");
		else if(curunit->moral <= -5)
		  printf("(very poor)\n");
		else if(curunit->moral <= -2)
		  printf("(poor)\n");
		else if(curunit->moral <= 1)
		  printf("(normal)\n");
		else if(curunit->moral <= 4)
		  printf("(good)\n");
		else if(curunit->moral <= 8)
		  printf("(very good)\n");
		else
		  printf("(victorious)\n");
		/* Print current standing orders in English */
		printf("Orders: ");
		/* Print movement mode */
		switch(curunit->movmode) {
		case CHASE:
		  printf("chase target; ");
		  break;
		case FORWARD:
		  printf("move to target; ");
		  break;
		case STAND:
		  printf("stand in place; ");
		  break;
		case RETREAT:
		  printf("retreat from target; ");
		  break;
		case RUNAWAY:
		  printf("run from target; ");
		  break;
		}
		/* Print target selection mode */
		switch(curunit->targmode) {
		case NEAREST:
		  printf("target is nearest hostile unit; ");
		  break;
		case FOLLOW:
		  printf("follow unit %d; ",curunit->targunit);
		  break;
		case POSIT:
		  printf("target is coordinate %d,%d; ",curunit->targx,curunit->targy);
		  break;
		case CENTER:
		  printf("target is center of enemy; ");
		  break;
		}
		/* Print current attack mode */
		switch(curunit->attmode) {
		case ATTACK:
		  printf("attack nearest unit");
		  break;
		case DEFEND:
		  printf("emphasize pure defense");
		  break;
		case NONE:
		  printf("no attack or defense");
		  break;
		}
		printf("\n\n");
		/* Set flag to indicate that a unit was printed */
		flag = 1;
	  }
	/* Print consolation message is no unit was selected */
	if(flag == 0)
	  printf("No units selected.\n");
	break;

	/* Change the orders of currently selected units */
  case 'o':
	/* List possible orders */
	if(buf[1] == '?') {
	  puts("oa - attack nearest target");
	  puts("oc - chase target");
	  puts("od - emphasize defense");
	  puts("of - move forward towards target");
	  puts("om - move towards center (middle) of enemy formation");
	  puts("on - move towards nearest enemy unit");
	  puts("op <x position> <y position> - target position x,y");
	  puts("or - orderly retreat");
	  puts("os - stand in place");
	  puts("ot <unit number> - follow (tail) another friendly unit");
	  puts("o! - run away!");
	}
	/* Go through each selected unit and change its orders */
	else
	  for(i=0;i<battle[myindex].size;++i)
		if(isselected(i)) {
		  /* Get a pointer to the current unit */
		  curunit = (battle[myindex].units) + i;
		  /* Switch on the new order.  The description of each order is in gdefs.h. */
		  switch(buf[1]) {
		  case 'a': case 'A':
			if(curunit->movmode == CHASE) {
			  printf("Unit %d can not attack while chasing.\n",i);
			  break;
			}
			curunit->attmode = ATTACK;
			break;
		  case 'c': case 'C':
			curunit->movmode = CHASE;
			curunit->attmode = ATTACK;
			break;
		  case 'd': case 'D':
			if((curunit->movmode == CHASE) || (curunit->movmode == RUNAWAY)) {
			  printf("Unit %d can not defend while chasing or running away.\n",i);
			  break;
			}
			curunit->attmode = DEFEND;
			break;
		  case 'f': case 'F': curunit->movmode = FORWARD; break;
		  case 'm': case 'M': curunit->targmode = CENTER; break;
		  case 'n': case 'N': curunit->targmode = NEAREST; break;
		  case 'p': case 'P':
			curunit->targmode = POSIT;
			sscanf(buf+2,"%d %d",&(curunit->targx),&(curunit->targy));
			break;
		  case 'r': case 'R': curunit->movmode = RETREAT; break;
		  case 's': case 'S': curunit->movmode = STAND; break;
		  case 't': case 'T':
			curunit->targmode = FOLLOW;
			sscanf(buf+2,"%d",&temp);
			if((temp < 0) || (temp >= battle[myindex].size))
			  printf("That is not one of your units.\n");
			else
			  curunit->targunit = temp;
			break;
		  case '!':
			curunit->movmode = RUNAWAY;
			curunit->attmode = NONE;
			break;
		  default:
			puts("Enter o? for a list of possible orders.");
			return;
		  }
		}
	/* Verify that the orders were received */
	printf("Order noted and dispatched sir.\n");
	break;

	/* Toggle the verbosity flag which controls the bulk of output */
  case 'v': case 'V':
	if(verbflag)
	  verbflag = 0;
	else
	  verbflag = 1;
	break;

	/* Change the turn delay */
  case 'd': case 'D':
	sscanf(buf+1," %d",&gamespeed);
	/* Limit game speed to reasonable values */
	if(gamespeed < 1)
	  gamespeed = 1;
	if(gamespeed > 5)
	  gamespeed = 5;
	/* Print warning message */
	printf("Note: game will run as fast as slowest player.\n");
	break;

	/* Send a message to all the other players */
  case 'm': case 'M':
	for(i=1;buf[i] == ' ';++i) ;
	cbcast(gaddr,GET_TALK_ENTRY,"%C",buf+i,strlen(buf+i),NONE,"");
	break;

	/* List the possible main commands */
  case '?': case 'h': case 'H':
	puts("d <delay> - change game turn delay (1 = fast ... 5 = slow)");
	puts("i - inquire about current units");
	puts("m <message> - send message to all other generals");
	puts("o... - change orders of current units");
	puts("s... - select new units");
	puts("q - quit");
	puts("v - toggle verbose mode");
	puts("You may hit ? as part of a command string to get further options.");
	puts("Only one command per line.");
	puts("If you are very confused, read the file \"howtoplay\"");
	puts("in the main game directory to find out how to play.");
	break;

	/* Ignore empty lines */
  case '\0': case ' ':
	break;

	/* Catch weird commands */
  default:
	puts("Enter ? for a list of commands.");
	break;
  }
}
