/* Written by Alex Siegel at Cornell University 9/88 */
/* The purpose of this module is to allow users to create new armies. */

#include <stdio.h>
#include "config.h"
#include "gdefs.h"

extern long unitcost();
extern army *loadarmy();
extern int substr();
extern int numitem;
extern long getval();
extern long unittech();
extern long random();

main(argc,argv)
int argc;
char **argv;
{
  FILE *fid;	 		/* Input file */
  char com,buf[50];
  /* com - command character
	 buf - line buffer */
  army *curarm;
  /* curarm - current army */
  armyunit *curunit;
  /* curunit - current unit in current army */
  register int i;
  /* i - loop variable */
  int unum,repet,divis,fact,maxsize;
  /* unum - nuit number
	 repet - repetition factor
	 divis - division number
	 fact - position scaling factor
	 maxsize - maximum unit size */
  long cost,tech,ntech;
  /* cost - unit cost
	 ntech,tech - technological level */

  /* Load in data describing each item */
  loaddata();

  /* Check the number of command line arguments */
  if(argc < 2) {
	fprintf(stderr,"usage: %s <army name>\n",argv[0]);
	exit(-1);
  }

  /* Load in the old description for the army to be manipulated if one is present */
  fid = fopen(argv[1],"r");
  if(fid != NULL)
	curarm = loadarmy(fid);
  else {
	/* Create a new empty army */
	curarm = (army *) malloc(sizeof(army));
	curarm->size = 0;
	curarm->units = (armyunit *) malloc(0);
  }
  fclose(fid);

  /* This is the main command loop */
  do {
	/* Load in a command */
	printf("Command - ");
	scanf(" %c",&com);

	/* Switch on the new command */
	switch(com) {
	  /* Add a new unit */
	case 'a':
	  /* Clear rest of command line */
	  gets(buf);
	  /* Create space for a new unit */
	  curarm->size ++;
	  curarm->units = (armyunit *) realloc(curarm->units,curarm->size * sizeof(armyunit));
	  /* Get a convenient pointer to the new unit */
	  curunit = (curarm->units) + (curarm->size - 1);

	  /* Read in name of platform */
	  printf("Enter name of creature/platform - ");
	  gets(buf);
	  /* Pattern match it to find the actual platform */
	  for(i=0;i<numitem;++i)
		if(substr(buf,names+(itemlist[i].namepos)) && (getval(i,TYPE) == PLATFORM))
		  break;
	  if(i == numitem) {
		printf("Unknown name.\n");
		i = 0;
	  }
	  curunit->platf = i;
	  printf("Platform is %s.\n",names+(itemlist[i].namepos));

	  /* Read in name of weapon */
	  printf("Enter name of weapon - ");
	  gets(buf);
	  if(buf[0] == '\0')
		i = -1;
	  else {
		for(i=0;i<numitem;++i)
		  if(substr(buf,names+(itemlist[i].namepos)) && (getval(i,TYPE) == WEAPON))
			break;
		if(i == numitem) {
		  printf("Unknown name.\n");
		  i = -1;
		}
	  }
	  curunit->weapon = i;
	  if(i == -1)
		printf("No weapon.\n");
	  else
		printf("Weapon is %s.\n",names+(itemlist[i].namepos));

	  /* Read in name of armor */
	  printf("Enter name of armor - ");
	  gets(buf);
	  if(buf[0] == '\0')
		i = -1;
	  else {
		for(i=0;i<numitem;++i)
		  if(substr(buf,names+(itemlist[i].namepos)) && (getval(i,TYPE) == ARMOR))
			break;
		if(i == numitem) {
		  printf("Unknown name.\n");
		  i = -1;
		}
	  }
	  curunit->armor = i;
	  if(i == -1)
		printf("No armor.\n");
	  else
		printf("Armor is %s.\n",names+(itemlist[i].namepos));

	  /* Check to make sure the the unit is not overloaded */
	  if(getval(curunit->platf,CAPAC) <
		 getval(curunit->platf,BULK) + getval(curunit->weapon,BULK) +
		 getval(curunit->armor,BULK)) {
		printf("That unit is carrying too much.\n");
		/* If it is, remove it */
		curarm->size --;
		break;
	  }

	  /* Compute the maximum size of the unit */
	  maxsize = 3000/(getval(curunit->platf,BULK) + getval(curunit->weapon,BULK) +
					  getval(curunit->armor,BULK));
	  if(maxsize < 1)
		maxsize = 1;
	  /* Set the size of the unit */
	  if(maxsize == 1) {
		printf("Unit size is limited to 1.\n");
		curunit->count = 1;
	  }
	  else {
		/* User has a range of sizes to choose from */
		printf("Enter size of unit (between 1 and %d) - ",maxsize);
		scanf(" %d",&unum);
		if(unum > maxsize)
		  unum = maxsize;
		if(unum < 1)
		  unum = 1;
		curunit->count = unum;
	  }
	  printf("Size is %d.\n",curunit->count);

	  /* Assign the rest of the fields with default startup values */
	  curunit->xpos = (random() % 50) - 25;
	  curunit->ypos = (random() % 50) - 25;
	  /* Set hit points to maximum */
	  curunit->tothits = curunit->count * getval(curunit->platf,HITS);
	  curunit->moral = 0;
	  curunit->movmode = FORWARD;
	  curunit->targmode = NEAREST;
	  curunit->attmode = ATTACK;
	  curunit->division = 1;
	  /* Set the number of charges available */
	  if(getval(curunit->weapon,CHARGE) == 0)
		curunit->charges = -1;
	  else
		curunit->charges = curunit->count * getval(curunit->weapon,CHARGE);

	  break;

	  /* Replicate an existing unit */
	case 'r':
	  /* Get replication parameters */
	  printf("Enter unit number and number of replications - ");
	  scanf(" %d %d",&unum,&repet);
	  /* Allocate new space for new units */
	  curarm->size += repet;
	  curarm->units = (armyunit *) realloc(curarm->units,curarm->size * sizeof(armyunit));
	  /* Make replications */
	  for(i=0;i<repet;++i) {
		/* Get pointer to unit */
		curunit = (curarm->units) + (curarm->size - i - 1);
		/* Copy unit parameters */
		*curunit = (curarm->units)[unum];
		/* Put unit in a new random place */
		curunit->xpos = (random() % 50) - 25;
		curunit->ypos = (random() % 50) - 25;
	  }
	  break;

	  /* Delete a set of units */
	case 'd':
	  /* Get delete parameters */
	  printf("Enter first and last unit number - ");
	  scanf(" %d %d",&unum,&repet);
	  repet -= unum - 1;
	  /* Pack units down */
	  for(i=unum;i+repet<curarm->size;++i)
		(curarm->units)[i] = (curarm->units)[i+repet];
	  /* Decrement the total number of units */
	  curarm->size -= repet;
	  break;

	  /* Print a description of all the units */
	case 'p':  case 'l':
	  printf("# : platform / weapon / armor / number / position / hit points / division\n");
	  for(i=0;i<curarm->size;++i) {
		/* Get pointer to current unit */
		curunit = (curarm->units) + i;
		/* Print unit name */
		printf("%d : %s / ",i,names + (itemlist[curunit->platf].namepos));
		/* Print unit weapon */
		if(curunit->weapon == -1)
		  printf("(none) / ");
		else
		  printf("%s / ",names + (itemlist[curunit->weapon].namepos));
		/* Print unit armor */
		if(curunit->armor == -1)
		  printf("(none) / ");
		else
		  printf("%s / ",names + (itemlist[curunit->armor].namepos));
		/* Print unit size, position, hit points, and division */
		printf("%d / %d,%d / %d / %d\n",curunit->count,curunit->xpos,
			   curunit->ypos,curunit->tothits,curunit->division);
	  }
	  break;

	  /* Change the division number of a range of units */
	case 'o':
	  /* Get parameters */
	  printf("Enter division number - ");
	  scanf(" %d",&divis);
	  printf("Enter first and last unit number - ");
	  scanf(" %d %d",&unum,&repet);
	  /* Set the division number of all the units in the range */
	  for(i=unum;i<=repet;++i)
		(curarm->units)[i].division = divis;
	  break;

	  /* Calculate total army cost and tech level */
	case 'c':
	  cost = 0;
	  tech = 0;
	  for(i=0;i<curarm->size;++i) {
		/* Keep running sum of cost */
		cost += unitcost((curarm->units) + i);
		/* Keep maximum technological level of all items */
		ntech = unittech((curarm->units) + i);
		tech = max(tech,ntech);
	  }
	  /* Print results */
	  printf("Total cost is %d.  Technology level is %d.\n",cost,tech);
	  break;

	  /* List all the names and types of items available */
	case 'n':
	  for(i=0;i<numitem;++i) {
		printf("%35s ",names+(itemlist[i].namepos));
		/* Print an English name for the different types */
		switch(getval(i,TYPE)) {
		case PLATFORM:
		  printf("(PLATFORM) ");
		  break;
		case WEAPON:
		  printf("(WEAPON)   ");
		  break;
		case ARMOR:
		  printf("(ARMOR)    ");
		  break;
		}
		printf("cost = %7d  technology = %2d\n",getval(i,COST),getval(i,TECH));
	  }
	  putchar('\n');
	  break;

	  /* Set positions of units */
	case 'm':
	  printf("Assume enemy is just out of range north.\n");
	  movepos(curarm);
	  break;

	  /* Scale position of units linearly */
	case 's':
	  printf("What scaling factor (between 1 and 5) - ");
	  scanf(" %d",&fact);
	  if((fact < 1) || (fact > 5)) {
		printf("Illegal scaling factor.\n");
		break;
	  }
	  for(i=0;i<curarm->size;++i) {
		curunit = (curarm->units) + i;
		curunit->xpos *= fact;
		curunit->ypos *= fact;
	  }
	  break;

	  /* List possible commands */
	case '?':  case 'h':
	  puts("Here is a list of commands:\n");
	  puts("? , h - get this list");
	  puts("a - add a new unit");
	  puts("c - get cost and technology level of current army");
	  puts("d - delete units");
	  puts("m - move pieces around to set initial position");
	  puts("n - list all names and types");
	  puts("o - organize units into a division");
	  puts("p , l - print out a listing describing current army");
	  puts("q - quit and save current army");
	  puts("r - replicate an existing unit");
	  puts("s - scale up the relative positions of the units\n");
	  break;

	case 'q':
	  break;

	default:
	  printf("Unknown command.  Type ? for a list of commands.\n");
	  break;
	}
  } while(com!= 'q');

  /* Save army */
  fid = fopen(argv[1],"w");
  savearmy(fid,curarm);
  fclose(fid);
}
