/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Toolkit interface to rexec facility */

#include "isis.h"
#include "rexec.h"


static joined(gaddr, addr, event, cond)
  address gaddr, addr;
  condition *cond;
  {
        t_sig(cond, (event == W_FAIL)? -1: 0);
  }

isis_rexec(nwanted, gid, sites, prog, args, env, user, passwd, addrs)
  address gid, *addrs;
  register site_id *sites;
  char *prog, **args, **env, *user, *passwd;   
  {
        register message *mp = msg_newmsg();
        register nrep;
        register address *ap;
        static firsttime;

        if(firsttime++ == 0)
            isis_task(joined, "isis_rexec:joined");

        msg_addfield(mp, RE_PROG, prog, FTYPE_CHAR, strlen(prog)+1);
        while(args && *args)
        {
            msg_addfield(mp, RE_ARGS, *args, FTYPE_CHAR, strlen(*args)+1);
            ++args;
        }
        while(env && *env)
        {
            msg_addfield(mp, RE_ENV, *env, FTYPE_CHAR, strlen(*env)+1);
            ++env;
        }
        msg_addfield(mp, RE_USER, user, FTYPE_CHAR, strlen(user)+1);
        msg_addfield(mp, RE_PASSWD, passwd, FTYPE_CHAR, strlen(passwd)+1);
        nrep = 0;
        while(nrep < nwanted && *sites)
        {
            address where, addr;
            where = ADDRESS(SITE_NO(*sites), SITE_INCARN(*sites), REXEC, 0);
            if(cbcast_l("s", where, REXEC_REQ, mp, ALL, "%a", &addr) > 0)
                if(!addr_isnull(addr))
                {
                    if(!addr_isnull(gid))
                    {
                        switch(pg_watch(gid, addr, W_JOIN, joined, &isis_ctp->task_cond))
                        {
                          case -1:
                          case 0:
                                break;
                          default:
                                if(t_wait_l(&isis_ctp->task_cond, "isis system: waiting for join or failure of rexec-ed process") == -1) 
                                    continue; 
                        }
                    }
                    addrs[nrep++] = addr;
                }
            ++sites;
        }
        addrs[nrep] = NULLADDRESS;
        return(nrep);
  }

r_exec()
  {
        panic("please use isis_rexec instead of r_exec\n");
  }

r_exec_cc()
  {
        panic("please use isis_rexec instead of r_exec_cc\n");
  }
