/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
#include "isis.h"

static  queue *au_queue;
static  ifunc *authenticator, *old_filter;

au_request_verify(routine)
  ifunc *routine;
  {
        int au_filter();
        ifunc *isis_setfilter();
        authenticator = routine;
        old_filter = isis_setfilter(au_filter);
  }

au_filter(mp)
  register message *mp;
  {
        switch((*authenticator)(mp))
        {
          case -1:
            nullreply(mp);
            return;

          case 0:
            (*old_filter)(mp);
            return;

          default:
            return;
        }
  }

au_permit(who)
  address who;
  {
        if(au_queue == NULLQP)
            au_queue = qu_null();
        if(pg_find(au_queue, who) == NULLQP)
            pg_add(au_queue, who, NULLARG, NULLROUTINE);
  }

au_revoke_perm(who)
  address who;
  {
        register queue *qp;
        if(au_queue && (qp = pg_find(au_queue, who)))
            qu_free(qp);
  }
