/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Generic include file for client code */

#include <errno.h>
#include <stdio.h>

/* UNIX_DOM must match with pr.h! */
#ifdef  SUN3
# define SUN                1
# define UNIX_DOM           1 
#endif
#ifdef  NEXT
# define UNIX_DOM           1 
#endif
#ifdef  SUN4
# define SUN                1 
# define UNIX_DOM           1 
#endif   
#ifdef  VAX
# define UNIX_DOM           1 
#endif   
#ifdef  hpux   
# define HPUX               1
#endif 
 
#ifdef HPUX
#include <memory.h>
#define bcopy(a,b,c) memcpy(b,a,c)
#define bzero(a,b)   memset(a,0,b)
#endif HPUX

#define MAX_PROCS       64
#define MAX_SITES       127             /* Also change in pr.h! */

#include "cl_typedefs.h"
#include "msg.h"
#include "isis_alloc.h"
#include "bits.h"
#include "pr_fdect.h"
#include "pr_msgfields.h"
#include "pr_address.h"
#include "cl_xaction.h"
#include "cl_queues.h"
#include "guards.h"
#include "cl_task.h"
#include "pr_client.h"
#include "pr_pgroups.h"
#include "cl_groupview.h"
#include "pr_errors.h"
#include "cl_news.h"
#include "cl_rmgr.h"
#include "cl_cmd.h"
#include "cl_lmgr.h"
#include "cl_inter.h"
#include "cl_bypass.h"

#ifndef GLOBAL
#define GLOBAL
/* Client's version of various global definitions */

#       define  begin
#       define  forever         for(;;)

#define DUMP_ALL        -1
#define DUMP_MEM        0x1

/* Argument types */
#define PG_INIT         1               /* Init routine to call on creates */
#define PG_XFER         2               /* Xfer routines, can specify several */
#define PG_JOIN_AUTHEN  3               /* Routine to authenticate join requests */
#define PG_MONITOR      4               /* Routine that monitors this group */
#define PG_CREDENTIALS  5               /* Credentials for this join */
#define PG_LOGGED       6               /* Log this group on stable storage */
#define PG_DONTCREATE   7               /* Don't create if it doesn't exist */
#define PG_BIGXFER      8               /* Expect a big state */
#define PG_INCARN       9               /* Specify incarnation number */
#define PG_CLIENT_AUTHEN 10             /* Client authentication */
#define PG_WAITDELAY    11              /* How long to wait for a recovery */

# define        NULLROUTINE     (ifunc*)        0
# define        NULLARG         (char*)         0
# define        NULLTASK        (task*)         0
# define        NULLIARG        (int*)          0
# define        NULLQP          (queue*)        0
# define        NULLMP          (message*)      0
# define        NULLSID         (site_id)       0

int     my_site_no;                     /* Info about this site */
int     my_site_incarn;                 /* Info about this site */
site_id my_site_id;                     /* This process's id */
int     my_process_id;                  /* Info about this site */
int     my_port_no;                     /* UDP port to talk to me directly */
int     my_genid;                       /* Used to generate bcast id's */
address my_address;                     /* Info about this site */
char    my_host[64];                    /* My host name */
bitvec  my_bcastscope;                  /* Scope, for piggybacking */
char    site_names[MAX_SITES][64];      /* All known host names */
address ADDRESS(), PRO();
event_id bc_getevent();
message *isis_rpc(), *msg_read();
extern  address NULLADDRESS;
int     errno;                          /* System version */
char    isis_dir[128];                  /* isis working directory */
int     isis_errno;                     /* See pr_errors.h */
int     isis_nsent;                     /* number of destinations sent to */
int     isis_nreplies;                  /* number of replies received */
int     isis_mutex;                     /* When tasks are blocked, this says who did it */
int     isis_forkcnt;                   /* Counts tasks forked off */
int     isis_socket;                    /* Socket (fdes) for talking to isis */
int     intercl_socket;                 /* Socket (fdes) for receiving directly client-client */
int     isis_state;                     /* State flags */
int     isis_created;                   /* Tasks created */
int     isis_switched;                  /* Task switches done */
extern  ISIS_TIME;                      /* relative timer in ms */

#define ISIS_INIT       0x001           /* Initialization complete */
#define ISIS_ISUP       0x002           /* Connected to a live protos */
#define ISIS_CONGESTED  0x004           /* System congested */
#define ISIS_STARTUP    0x008           /* Doing startup  */
#define ISIS_XJOINS     0x010           /* Joins inhibited  */
#define ISIS_TRACE      0x020           /* Trace enabled */
#define ISIS_WJOIN      0x040           /* Someone wants to join */
#define ISIS_BINHIBIT   0x080           /* Bypass inhibited */
#define ISIS_RECEIVING  0x100           /* Used from isis_gotmsg() only */

sview   isis_sv;                        /* Site-views */
sview   isis_svmutex;                   /* Site-views */
queue   *isis_wlist;                    /* Process group member watch list */
queue   *isis_swlist;                   /* Site watch list */
queue   *isis_pwlist;                   /* Process watch list */
queue   *isis_pgmon;                    /* Pgroup monitor list */
char    *isis_joining;                  /* Group this client is joining, if any */
int     isis_enum;                      /* Used when isis_gotmsg() is delivery message */
ginfo   *isis_gip;                      /*   "     "  */
event_id*isis_eid;                      /*   "     "  */
extern  task isis_scheduler;            /* Task for scheduling tasks */
groupview *pg_getview();                /* Gets a view */
groupview *pg_getlocalview();           /* Gets a view that should already be known */
sview     *site_getview();              /* Gets a site-view */
address pg_lookup();
address pg_join();
address pg_create();
task    *isis_fork();
bitvec  inhibit_entries;                /* Entries for which joinsd should be inhibited */

#define XD_MAX          10              /* Upper limit */

struct  ginfo
{
        address gi_gaddr;               /* Group address */
        ginfo   *gi_next;               /* Forward link */
        char    gi_gname[PG_GLEN];      /* Printable name */
        ifunc   *gi_xfer_rcv[XD_MAX];   /* For state xfer */
        ifunc   *gi_xfer_gen[XD_MAX];   /* For state xfer */
        ifunc   *gi_join_verifier;      /* For verifying joins */
        ifunc   *gi_client_verifier;    /* For verifying client */
        queue   *gi_guarded;            /* Current guarded bcasts */
        queue   *gi_pats;               /* Current pattern nodes */
        queue   *gi_events;             /* Completed events for live processes */
        groupview gi_view;              /* Current view */
        groupview gi_mutexview;         /* Current view when isis_mutex set */
        log_nod *gi_lnode;              /* Logging information for this group, if any */
        bitvec  gi_lentries;            /* Logged entries */
        int     gi_bseqns[PG_ALEN];     /* seqn for direct communication */
        queue   *gi_bypassq;            /* Bypass queue */
        queue   *gi_clwatchq;           /* Join watch queue */
};

ginfo   *map_gname(), *map_gaddr(), *add_gname(), *add_group();
ginfo   *isis_groups;
ifunc   *def_xfer_rcv[XD_MAX];          /* Default */
ifunc   *def_xfer_gen[XD_MAX];          /* Default */

/* For coordinator-cohort computations */
#define ORIGINAL        0               /* You are the original coordinator */
#define TAKEOVER        1               /* You are a cohort taking over */

#define XD_GUARDS       0               /* For pending guarded bcasts */
#define XD_TOKEN        1               /* For future use by systemsystem */
#define XD_RESERV2      2               /* For future use by systemsystem */
#define XD_RESERV3      3               /* For future use by systemsystem */
#define XD_USER         4               /* User ``domain'' */

#define W_FAIL          0               /* Watch for failure */
#define W_RECOVER       1               /* Watch for recovery */
#define W_JOIN          2               /* Process joins */
#define W_LEAVE         3               /* Process leaves */
#define W_MONITOR       -1              /* Monitor */

#define ACT_MSG         1               /* One more or fewer messages */
#define ACT_WATCH       2               /* One more or fewer watch/monitor */

#define BYP_DONTCHECK   0               /* Don't check for bypass info */
#define BYP_CHECK       1               /* Check for bypass info */

extern  act_bits;                       /* Activities currently in use (initially 1 in cl_isis) */

#define ACT_VALID(act)  (act_bits & (1<<act))

#define ACT_WILDCARD    0x8000000
#define ACT_BITS        ((1<<MAX_ACT)-1)
#define MAX_ACT         32              /* Limited by bits in integer */

struct
{
        address act_id;
        int     act_evcount;
        int     act_gotres[2];
} act_map[MAX_ACT];

#define map_act(act)    (act_map[act].act_id)
 
#define sleep(n)       isis_sleep(n)    /* Sleep special in ISIS tasks */
#define isis_inhibit_joins(entry)    bis(inhibit_entries, entry)
#define t_wait(cond)   t_wait_l(cond, (char*)0)
#endif
