/*
 * ISIS System V1.1 (Dec. 1988).   Export restrictions apply.
 */
/*
 *      Yacc grammar for guard parser
 */
%{
#include "isis.h"

#define yyerrflag       isis_g_yyerrflag
#define yydef           isis_g_yydef
#define yynerrs         isis_g_yynerrs
#define yyr1            isis_g_yyr1
#define yyr2            isis_g_yyr2
#define yychar          isis_g_yychar
#define yyexca          isis_g_yyexca
#define yypact          isis_g_yypact
#define yyparse         isis_g_yyparse
#define yychk           isis_g_yychk
#define yypgo           isis_g_yypgo
#define yyact           isis_g_yyact
#define yyerror         isis_g_yyerror
#define yylex           isis_g_yylex
#define yylval          isis_g_yylval
#define yyval           isis_g_yyval
#define yyv             isis_g_yyv

%}

%token  T_AFTER T_PID T_OP T_STRING T_TIMEOUT T_INTEGER T_FMTE T_FMTA T_FMTD
%left   '(' ')'
%left   T_AND T_OR

%%

guard_expr:     '{' guard '}'                   { if(!pre_parsing) g_etree->et_expr = (gnode*)$2; }
        |       guard                           { if(!pre_parsing) g_etree->et_expr = (gnode*)$1; };

guard:          after ')' guard                 { $$ = isis_enode(G_AFTER, $1, $2); }
        |       guard T_AND guard               { $$ = isis_enode(G_AND, $1, $2); }
        |       guard T_OR guard                { $$ = isis_enode(G_OR, $1, $2); }
        |       '(' guard ')'                   { $$ = $2; }
        |       T_TIMEOUT '(' T_INTEGER ')'     { if(!pre_parsing) { $$ = isis_tnode($3); }}
        |       T_TIMEOUT '(' T_FMTD ')'        { if(!pre_parsing) {
                                                  int delay;
                                                  g_getev($3, &delay);
                                                  $$ = isis_tnode(delay); }}
        |       pattern                         { $$ = $1; }
        |                                       { $$ = isis_enode(G_TRUE, 0, 0); };

after:          T_AFTER '(' T_FMTE              { if(!pre_parsing) $$ = g_alloc_eid($3); };

pattern:        '[' T_FMTA ',' opname ']'       { if(!pre_parsing) {
                                                  event_id eid;
                                                  g_getev($2, &eid);
                                                  $$ = isis_pnode(eid.e_pname, $4, 0); }}
        |       '[' T_FMTA ',' '*' ']'          { if(!pre_parsing) {
                                                  event_id eid;
                                                  g_getev($2, &eid);
                                                  $$ = isis_pnode(eid.e_pname, -1, 0); }}
        |       '[' '*' ',' opname ']'          { $$ = isis_pnode(NULLADDRESS, $4, 0); }
        |       T_FMTE                          { if(!pre_parsing) {
                                                  event_id eid;
                                                  g_getev($1, &eid);
                                                  $$ = isis_pnode(eid.e_pname, eid.e_op, eid.e_msgid); }};


opname:         T_FMTD                          { if(!pre_parsing) { int op; g_getev($1, &op); $$ = op; }}
        |       T_STRING                        { if(!pre_parsing) { $$ = gop_lookup($1); } free($1); };
%%

#include <ctype.h>

char    *keywords[] ={
        "after", "pid", "op", "timeout", "and", "or", "&&", "||", 0
};

int     keyvals[] ={
        T_AFTER, T_PID, T_OP, T_TIMEOUT, T_AND, T_OR, T_AND, T_OR, 0
};

char    *string, *str;

g_preparse(what)
  char *what;
  {
        string = str = what;
        parse_error = 0;
        inv_level = 0;
        pre_parsing = 1;
        if(yyparse() || parse_error)
            return(-1);
        return(inv_level);
  }

g_parse(what)
  char *what;
  {
        string = str = what;
        parse_error = 0;
        pre_parsing = 0;
        if(yyparse() || parse_error)
            panic("parse error detected in guard parse");
  }

static yyerror()
  {
        parse_error++;
        isis_errno = IE_GPARSE;
  }

static yylex()
  {
        register char c;

        while(isspace(c = *str))
            ++str;
        if(c == 0)
            return(0);
        if(isdigit(c))
        {
            register n = c - '0';
            while(isdigit(c = *++str))
                n = n*10 + c-'0';
            yylval = n;
            return(T_INTEGER);
        }
        if(c == '%')
        {
            yylval = (int)str;
            switch(c = *++str)
            {
              case 'a':
                ++str;
                return(T_FMTA);
              case 'd':
                ++str;
                return(T_FMTD);
              case 'e':
                ++str;
                return(T_FMTE);
            }
            isis_errno = IE_GPARSE;
            parse_error++;
            return(0);
        }
        switch(c)
        {
           case '*':
           case '(': case ')':
           case '{': case '}':
           case '[': case ']':
           case ',': case '.':
               ++str;
               return(c);
        }
        if(!isalpha(c) && c != '$')
        {
            print("preparse: unexpected char %c (0%o)", c, c);
            parse_error++;
            return(0);
        }
        else
        {
            register char **kp, *ksp, *sp;
            char *malloc();
            for(kp = keywords; ksp = *kp; kp++)
            {
                sp = str;
                while(*sp && *ksp)
                {
                    c = *sp;
                    if(isupper(c))
                        c = tolower(c);
                    if(c != *ksp)
                        break;
                    ++sp;
                    ++ksp;
                }
                if(*ksp == 0)
                {
                    str = sp;
                    return(keyvals[kp-keywords]);
                }
            }
            sp = str;
            if(*str == '$')
                ++str;
            while(isalnum(*++str))
                continue;
            ksp = malloc((str-sp+4) & ~3);
            yylval = (int)ksp;
            while(sp != str)
                *ksp++ = *sp++;
            *ksp = 0;
            return(T_STRING);
        }
  }

static adesc g_ad
={
        sizeof(gnode),  sizeof(gnode),   16
};

#define n_alloc()       ((gnode*)mallocate(&g_ad));

n_free(bn)
  gnode *bn;
  {
        mdeallocate((char*)bn, &g_ad);
  }

/* Create a new gnode */
isis_enode(name, left, right)
  gnode *left, *right;
  {
        register gnode *np;
        if(pre_parsing)
            return(0);
        np = n_alloc();
        np->n_type = name;
        np->n_left = left;
        np->n_right = right;
        np->n_etree = g_etree;
        np->n_chain = g_etree->et_nodes;
        g_etree->et_nodes = np;
        return((int)np);
  }

isis_pnode(pn, op, msgid)
  address pn;
  {
        register gnode *np;
        if(pre_parsing)
            return(0);
        np = n_alloc();
        np->n_type = G_PATTERN;
        np->n_pat.e_msgid = msgid;
        np->n_pat.e_op = op;
        np->n_pat.e_pname = pn;
        np->n_etree = g_etree;
        np->n_chain = g_etree->et_nodes;
        g_etree->et_nodes = np;
        if(edb_lookup(g_etree->et_gp, &np->n_pat) == 0)
             qu_add_nd(g_etree->et_gp->gi_pats, 1, (char*)np);
        else
            np->n_flag |= G_EVAL_TRUE;
        return((int)np);
  }
