/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      ISIS guard implementation.
 */

#include "isis.h"
 
#ifdef  GOULD 
# undef gould           /* Correct bizarre problem with va_arg on struct passed by value */  
#endif 
#include <varargs.h>

static  event_trace, g_null(), g_eval(), g_cancel(), g_do_eval(), eval();
static  et_free(), cmp_edb(), dump_etree(), dump_expr(), dump_pnode(), dump_pat();

gd_init()
  {
        static firsttime;
        if(firsttime++ == 0)
        {
            static g_eval(), g_cancel(), g_null(), g_send(), g_rcv();
            isis_entry(GENERIC_G_EVAL, g_eval, "isis-guards:g_eval");
            isis_entry(GENERIC_G_CANCEL, g_cancel, "isis-guards:g_cancel");
            isis_entry(GENERIC_G_NULL, g_null, "isis-guards:g_null");
            allow_xfers_xd(NULLARG, XD_TOKEN, g_send, g_rcv);
        }
  }

guard_init()
  {
        ++event_trace;
  }

adesc   et_ad ={ sizeof(etree), sizeof(etree), 4 };

#define e_alloc()      ((etree*)mallocate(&et_ad))
#define e_free(et)     mdeallocate((char*)et,&et_ad)

adesc   ei_ad ={ sizeof(event_id), sizeof(event_id), 4 };

#define ei_alloc()      ((event_id*)mallocate(&ei_ad))

static
ei_free(ei)
  event_id *ei;
  {
        mdeallocate((char*)ei, &ei_ad);
  }

/*  Event id database */

static message *g_msg;
static evnum;

/* Generate a message as for a normal guarded broadcast, use existing mechanism */
guard(va_alist)
  va_dcl
  {
        extern ISIS_MSGID, pushes_by_ref;
        static g_eval();
        char *gformat;
        message *mp, *gmsg;
        event_id eid;
        address gid, addr;
        va_list ap;
        va_start(ap);
        if(pushes_by_ref == -1)
            check_varargs();
        if(pushes_by_ref == 1)
            gid = *va_arg(ap, address*);
        else
            gid = va_arg(ap, address);
        gformat = *(char**)ap;
        if(g_preparse(gformat) == -1)
            return(-1);
        /* Generate message containing guard and args */
        gmsg = msg_newmsg();
        if(msg_doputf(gmsg, SYSFLD_SCAN, &ap) == -1)
        {
            msg_delete(gmsg);
            return(-1);
        }
        /* Now generate "true" message to g_null */
        gid.entry = GENERIC_G_NULL;
        eid.e_op = GENERIC_G_NULL;
        eid.e_pname = my_address;
        eid.e_msgid = (ISIS_MSGID += 2);

        mp = msg_gen("%d", &isis_ctp->task_cond);
        /* Insert guard and EID information */
        msg_putfld(mp, SYSFLD_GUARD, "%s,%m,%a", gformat, gmsg, gid);
        msg_insertfield(mp, SYSFLD_EID, &eid, FTYPE_EVENT, sizeof(event_id));
        msg_delete(gmsg);

        msg_setsender(mp, my_address);

        addr = my_address;
        addr.entry = GENERIC_G_EVAL;
        msg_setdest(mp, addr);
        t_fork_msg(g_eval, mp);

        t_wait_l(&isis_ctp->task_cond, "isis system: waiting for guard eval to succeed");

        va_end(ap);
        return(1);
  }

static
g_null(mp)
  message *mp;
  {
        condition *cond;
        msg_get(mp, "%d", &cond);
        t_sig(cond, 0);
  }

/* Receive guard invocation, evaluate guard, then dispatch operation for execution */
static
g_eval(mp)
  register message *mp;
  {
        int nargs;
        register ginfo *gip;
        char *guard;
        event_id eid;
        register event_id *ep;
        message *gmsg;
        address gdest;

        if(event_trace == 0)
        {
            print("Warning: Process %d got a guarded request, but guard_init hadn't been called\n", my_process_id);
            guard_init();
        }
        if(msg_getfld(mp, SYSFLD_GUARD, 0, "%-s,%m,%a", &guard, &gmsg, &gdest) != 3)
            panic("g_eval");
        if((gip = map_gaddr(gdest)) == 0)
            panic("g_eval: group lookup failed");

        if(ep = (event_id*)msg_getfield(mp, SYSFLD_EID, 1, NULLIARG))
            eid = *ep;
        else
            panic("g_eval: no EID in this message");

        g_etree = e_alloc();
        g_etree->et_flag = ET_NEED_EVAL;
        g_etree->et_nodes = 0;
        g_etree->et_eid = eid;
        g_etree->et_gp = gip;
        g_etree->et_entry = gdest.entry;
        g_msg = g_etree->et_msg = mp;
        msg_increfcount(mp);
        evnum = 0;

        /* Scan format string and message */
        g_scan_fmt(guard, gmsg);

        /* Parse guard, evaluating pattern nodes as they are generated */
        g_parse(guard);

        /* Now try to evaluate expression, waiting until it is satisfied */
        if(eval(g_etree) == 0)
        {
            int et_free();
            /* Enqueue this request */
            if(isis_ctp->task_flag&TASK_INHIBIT)
            {
                g_etree->et_flag |= ET_INHIBIT;
                pg_join_inhibit(1);
            }
            qu_add_et(gip->gi_guarded, eid.e_msgid, g_etree, et_free);
        }
        else
        {
            register queue *qp;
            int again = 1;
            /* May have made others valid */
            et_free(g_etree);
            g_etree = 0;
            while(again)
            {
                again = 0;
                /* Now we re-evaluate the trees, if any, that this affected */
                for(qp = gip->gi_guarded->qu_next; qp != gip->gi_guarded; qp = qp->qu_next)
                {
                    register etree *et = qp->qu_et;
                    if(eval(et))
                    {
                        qu_free(qp);
                        ++again;
                        break;
                    }
                }
            }
        }
  }

static
g_cancel(mp)
  message *mp;
  {
        int outcome = -1;
        event_id eid;
        register ginfo *gip;
        msg_get(mp, "%e", &eid);
        for(gip = isis_groups; gip; gip = gip->gi_next)
        {
            register queue *qp;
            if(qp = qu_find(gip->gi_guarded, eid.e_msgid))
            {
                qu_free(qp);
                outcome = 1;
                break;
            }
        }
        reply(mp, "%d", outcome);
  }

/* Send event list and guarded messages (but not stuff from guard() statements) */
g_send(locator, gaddr)
  {
        register ginfo *gip = map_gaddr(gaddr);
        register queue *qp;
        if(gip == (ginfo*)0 || !event_trace)
            return;
        xfer_out(-1, "%a", gaddr);
        for(qp = gip->gi_events->qu_next; qp != gip->gi_events; qp = qp->qu_next)
            if(qp->qu_eid->e_op != GENERIC_G_NULL)
                xfer_out(1, "%e", *qp->qu_eid);
        for(qp = gip->gi_guarded->qu_next; qp != gip->gi_guarded; qp = qp->qu_next)
            if(qp->qu_et->et_eid.e_op != GENERIC_G_NULL)
                xfer_out(2, "%m", qp->qu_et->et_msg);
  }

g_rcv(locator, mp)
  {
        static ginfo *gip;
        if(event_trace == 0)
            guard_init();
        switch(locator)
        {
                register ginfo *gip;
                register queue *qp;
                address gaddr;
                event_id eid;
                message *gmsg;
          case -1:
                msg_get(mp, "%a", &gaddr);
                gip = map_gaddr(gaddr);
                while(qp = qu_head(gip->gi_events))
                    qu_free(qp);
                while(qp = qu_head(gip->gi_guarded))
                    qu_free(qp);
                break;
          case 1:
                msg_get(mp, "%e", &eid);
                edb_add(eid.e_pname, eid.e_op, eid.e_msgid);
                break;
          case 2:
                msg_get(mp, "%m", &gmsg);
                g_eval(gmsg);
                msg_delete(gmsg);
                break;
        }
  }

typedef struct
{
        char            *i_where;
        union
        {
            address     i_addr;
            event_id    i_event;
            int         i_int;
        } i_un;
} item;

static item     items[32], *last;

g_scan_fmt(fmt, mp)
  register char *fmt;
  register message *mp;
  {
        register item *ip = items;
        while(*fmt)
            if(*fmt++ == '%')
            {
                switch(*fmt)
                {
                  case 'a':     if(msg_get(mp, "%a", &ip->i_un.i_addr) != 1) goto err; break;
                  case 'd':     if(msg_get(mp, "%d", &ip->i_un.i_int) != 1) goto err; break;
                  case 'e':     if(msg_get(mp, "%e", &ip->i_un.i_event) != 1) goto err; break;
                } 
if(*fmt == 'e') { print("G_SCAN at %x: ", fmt-1); peid(ip->i_un.i_event); print("\n"); }
                ip->i_where = fmt-1;
                ++ip;
            }
        last = ip;
        return;
  err:
        perror("g_scan_fmt");
        panic("g_scan_fmt"); 
  }

/* Get an event id */
g_getev(fmt, where)
  char *fmt; int *where;
  {
        int rv;
        register item *ip;
        for(ip = items; ip != last; ip++)
            if(ip->i_where == fmt)
                switch(*++fmt)
                {
                  case 'a':     *(address*)where = ip->i_un.i_addr; return;
                  case 'd':     *(int*)where = ip->i_un.i_int; return;
                  case 'e':     *(event_id*)where = ip->i_un.i_event; return;
                } 
        panic("g_getev: %x NOT FOUND!\n", fmt);
  }

event_id *
g_alloc_eid(fmt)
  char *fmt;
  {
        register event_id *eid = ei_alloc();
        g_getev(fmt, eid);
        return(eid);
  }

static
eval(et)
  register etree *et;
  {
        char *res;
        int rtype, rlen;
        if((et->et_flag&ET_NEED_EVAL) == 0)
            return(0);
        et->et_flag &= ~ET_NEED_EVAL;
        et->et_flag |= ET_DOING_INVOKE;
        if(g_do_eval(et->et_gp, et->et_expr) == 0)
            return(0);
        /* Invoke operation */
        isis_invoke(et->et_entry, et->et_msg);
        return(1);
  }

/*
 *  Caution: this approach forks off all runable bcasts at once, then
 *  as they terminate, evaluates the queue repeatedly.  Thus, if
 *  the queue contains a -> b -> c and b is waiting on a, the code
 *  could wake up a, c and then b after a runs -- as opposed to a, then b,
 *  then c.
 */
static
re_eval(gip, who)
  register ginfo *gip;
  address who;
  {
        register queue *qp;
        register again = 1;
        while(again)
        {
            again = 0;
            for(qp = gip->gi_guarded->qu_next; qp != gip->gi_guarded; qp = qp->qu_next)
            {
                register etree *et = qp->qu_et;
                if((addr_isnull(who) || addr_isequal(et->et_eid.e_pname, who)) && eval(et))
                {
                    ++again;
                    qu_free(qp);
                    break;
                }
            }
        }
  }

static
g_do_eval(gip, ex)
  ginfo *gip;
  register gnode *ex;
  {
        forever
        {
            if(ex->n_flag&G_EVAL_T)
                return(1);
            switch(ex->n_type)
            {
              case G_AFTER:  /* after(e) g */
                    if((ex->n_left->n_flag&G_EVAL_T) || edb_lookup(gip, ex->n_left))
                    {
                        ex->n_left->n_flag |= G_EVAL_T;
                        if(g_do_eval(gip, ex->n_right))
                            break;
                    }
                    return(0);

              case G_AND:        /* g and g' */
                    if(g_do_eval(gip, ex->n_left) && g_do_eval(gip, ex->n_right))
                        break;
                    return(0);

              case G_OR:         /* g or g' */
                    if(g_do_eval(gip, ex->n_left) || g_do_eval(gip, ex->n_right))
                        break;
                    return(0);

              case G_TRUE:       /*True always */
                    break;

              case G_PATTERN:
              case G_TIMEOUT:
                    return(0);
            }
            break;
        }
        ex->n_flag |= G_EVAL_T;
        return(1);
  }

static
et_free(et)
  register etree *et;
  {
        register gnode *np, *nnp;
        register ginfo *gip = et->et_gp;
        for(np = et->et_nodes; np; np = nnp)
        {
            nnp = np->n_chain;
            if(np->n_type == G_PATTERN && (np->n_flag&G_EVAL_T) == 0)
            {
                register queue *qp;
                for(qp = gip->gi_pats->qu_next; qp != gip->gi_pats; qp = qp->qu_next)
                {
                    if(qp->qu_nd == np)
                    {
                        qu_free(qp);
                        break;
                    }
                }
            }
            if(np->n_type == G_AFTER)
                ei_free(np->n_left);
            else if(np->n_type == G_TIMEOUT && np->n_right)
                ((timenode*)np->n_right)->to_flag = 0;
            n_free(np);
        }
        msg_delete(et->et_msg);
        if(et->et_flag&ET_INHIBIT)
            pg_join_inhibit(0);
        e_free(et);
  }

edb_add(pname, op, msgid)
  address pname;
  {
        register queue *qp, *nqp;
        register ginfo *gip;
        register event_id *eid;

        if(event_trace == 0)
            return;

        for(gip = isis_groups; gip; gip = gip->gi_next)
        {
            register address *ap;
            int need_eval = 0;

            for(ap = gip->gi_view.gv_members; !addr_isnull(*ap); ap++)
                if(addr_isequal(*ap, pname))
                    break;
            if(addr_isnull(*ap))
                continue;

            /* Named process is a member of this group */
            eid = ei_alloc();
            eid->e_pname = pname;
            eid->e_op = op;
            eid->e_msgid = msgid;
            qu_add_eid(gip->gi_events, eid->e_msgid, eid, ei_free);
    
            for(qp = gip->gi_pats->qu_next; qp != gip->gi_pats; qp = nqp)
            {
                register gnode *np = qp->qu_nd;
                nqp = qp->qu_next;
                if(cmp_edb(&np->n_pat, eid) != 0)
                    continue;
                np->n_flag |= G_EVAL_T;
                np->n_etree->et_flag |= ET_NEED_EVAL;
                qu_free(qp);
                ++need_eval;
            }
            if(need_eval)
                re_eval(gip, NULLADDRESS);
        }
  }

static
cmp_edb(pp, ep)
  register event_id *pp, *ep;
  {
        if(!addr_isnull(pp->e_pname) && !addr_isequal(pp->e_pname, ep->e_pname))
            return(-1);
        if(pp->e_op != -1 && pp->e_op != ep->e_op)
            return(-1);
        if(pp->e_msgid && pp->e_msgid != ep->e_msgid)
            return(-1);
        return(0);
  }

/* Called from pnode() during parse */
edb_lookup(gip, ei)
  register ginfo *gip;
  register event_id *ei;
  {
        register queue *eqp;
        register address *ap;
        if(!addr_isnull(ei->e_pname))
        {
            for(ap = gip->gi_view.gv_members; !addr_isnull(*ap); ap++)
                if(addr_isequal(*ap, ei->e_pname))
                    break;
            if(addr_isnull(*ap))
                /* Must have failed */
                return(1);
        }
        for(eqp = gip->gi_events->qu_next; eqp != gip->gi_events; eqp = eqp->qu_next)
            if(cmp_edb(ei, eqp->qu_eid))
                return(1);
        if(addr_isnull(ei->e_pname) && ei->e_msgid == 0 && ei->e_op == -1)
            return(-1);
        return(0);
  }

g_new_view(gip)
  register ginfo *gip;
  {
        register queue *qp, *nqp;
        register groupview *gv = &gip->gi_view;
        int need_eval = 0;

        /* Not supported during mutex */
        if(isis_mutex || event_trace == 0)
            return;

        /* Not of interest unless guards are in use and some process failed */
        if(qu_head(gip->gi_guarded) == 0 && qu_head(gip->gi_events) == 0)
            return;
        if(addr_isnull(gv->gv_departed))
            return;

        for(qp = gip->gi_events->qu_next; qp != gip->gi_events; qp = nqp)
        {
            nqp = qp->qu_next;
            if(addr_isequal(qp->qu_eid->e_pname, gv->gv_departed))
                qu_free(qp);
        }
        for(qp = gip->gi_pats->qu_next; qp != gip->gi_pats; qp = nqp)
        {
            register gnode *np = qp->qu_nd;
            nqp = qp->qu_next;
            if(addr_isequal(np->n_pat.e_pname, gv->gv_departed))
            {
                np->n_flag |= G_EVAL_T;
                np->n_etree->et_flag |= ET_NEED_EVAL;
                qu_free(qp);
                ++need_eval;
            }
        }
        if(need_eval == 0)
            return;
        re_eval(gip, gv->gv_departed);
        /* Let them run, which may fork off other cleanup operations */
        (void)t_wait_l(&isis_runqueue, "isis system: pausing in guard evaluation");
        re_eval(gip, NULLADDRESS);
  }


adesc   to_ad ={ sizeof(timenode), sizeof(timenode), 2 };

#define to_alloc()      ((timenode*)mallocate(&to_ad))
#define to_free(to)     mdeallocate((char*)to,&to_ad)

to_eval(gip)
  ginfo *gip;
  {
        re_eval(gip, NULLADDRESS);
  }

to_alarm(to)
  register timenode *to;
  {
        if(to->to_flag)
        {
            to->to_nd->n_flag |= G_EVAL_T;
            to->to_nd->n_right = 0;
            to->to_etree->et_flag |= ET_NEED_EVAL;
            t_fork(to_eval, to->to_etree->et_gp);
        }
        to_free(to);
  }

isis_tnode(delay)
  register delay;
  {
        register timenode *to = to_alloc();
        register gnode *np = (gnode*)isis_enode(G_TIMEOUT, delay, (int)to);
        to->to_etree = g_etree;
        to->to_nd = np;
        to->to_flag = 1;
        isis_timeout(delay*1000, to_alarm, to, 0);
        return((int)np);
  }

/* Stuff for dumping etrees */
g_dump()
  {
        register ginfo *gip;
        register queue *qp;
        print("\nGuarded expression dump...\n");
        for(gip = isis_groups; gip; gip = gip->gi_next)
        {
            for(qp = gip->gi_guarded->qu_next; qp != gip->gi_guarded; qp = qp->qu_next)
            {
                register etree *et = qp->qu_et;
                print("Group %s: guarded message has ", gip->gi_gname);
                peid(et->et_eid);
                print("\n");
                dump_etree(et);
            }
        }
  }

static  node_num;

static
dump_etree(et)
  register etree *et;
  {
        print("  ... guard expr %x ", et);
        if(et->et_flag&ET_NEED_EVAL)
            print("need eval, ");
        if(et->et_flag&ET_INHIBIT)
            print("** inhibiting joins **. ");
        print("\n");
        node_num = 1;
        dump_expr(et->et_gp, 1, et->et_expr);
  }

static
dump_expr(gip, n, ex)
  register ginfo *gip;
  register gnode *ex;
  {
        register n1, n2;
        for(n1 = 0; n1 < n; n1++)
            print("  ");
        print("[%2d] = ", n);
        if(ex->n_flag&G_EVAL_T)
            print(" (evaluated,true) ");
        switch(ex->n_type)
        {
          case G_AFTER:
            n1 = ++node_num; n2 = ++node_num;
            print("AFTER([%2d]) [%2d]\n", n1, n2);
            dump_pnode(gip, n1, ex->n_left);
            dump_expr(gip, n2, ex->n_right);
            break;
          case G_AND:
            n1 = ++node_num; n2 = ++node_num;
            print("[%2d] AND [%2d]\n", n1, n2);
            dump_expr(gip, n1, ex->n_left);
            dump_expr(gip, n2, ex->n_right);
            break;
          case G_OR:
            n1 = ++node_num; n2 = ++node_num;
            print("[%2d] OR [%2d]\n", n1, n2);
            dump_expr(gip, n1, ex->n_left);
            dump_expr(gip, n2, ex->n_right);
            break;
          case G_TRUE:
            print("true\n");
            break;
          case G_PATTERN:
            peid(ex->n_pat);
            print("\n");
            break;
          case G_TIMEOUT:
            print("timeout(%d)\n", ex->n_left);
            break;
        }
  }

static
dump_pnode(gip, n, nd)
  register gnode *nd;
  register ginfo *gip;
  {
        print("[%2d] = ", n);
        dump_pat(gip, nd);
  }

static
dump_pat(gip, nd)
  register ginfo *gip;
  register gnode *nd;
  {
        register event_id *ei = &nd->n_pat;
        print("EVENT[addr = ");
        if(!addr_isnull(ei->e_pname))
            paddr(ei->e_pname);
        else
            print("*,");
        if(ei->e_op != -1)
            print("op = %s,", cl_getrname(ei->e_op));
        else
            print("op = *,");
        if(ei->e_msgid != -1)
            print("msgid = %x]", ei->e_msgid);
        else
            print("msgid = *] ");
  }
