/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      ISIS distributed systems toolkit: watch for process joins and failure
 */

#include "isis.h"

struct  wnode
  {
        ifunc   *w_proc;
        address w_gaddr;
        address w_paddr;
        char    *w_arg;
        int     w_act;
        int     w_id;
        int     w_jid;
        int     w_mode;
  };

static adesc   wadesc ={ sizeof(wnode),  0,  8, };

#define w_alloc()       (wnode*)mallocate(&wadesc)

w_free(wp)
  register wnode *wp;
  {
        act_ev(-1, wp->w_act, ACT_WATCH);
        mdeallocate((char*)wp, &wadesc);
  }

static WID = 1<<30, PWID = 2<<30;
static w_new_sl(), pwatch_call(), watch_call();

w_init()
  {
        static pwatch_call(), watch_call(), cl_proc_failed(), pg_failed_first(), do_pmonitor();
        register act = isis_ctp->task_act;
        isis_task(pwatch_call, "pg_watch:pwatch_call");
        isis_task(pg_failed_first, "pg_watch:pg_failed_first");
        isis_task(watch_call, "pg_watch:watch_call");
        isis_task(w_new_sl, "pg_watch:w_new_sl");
        isis_task(do_pmonitor, "pg_watch:call_pmonitor");
        isis_entry(GENERIC_PROC_FAILED, cl_proc_failed, "pg_watch:cl_proc_failed");
        isis_ctp->task_act = 0;
        sv_monitor(w_new_sl, NULLARG);
        isis_ctp->task_act = act;
  }

pg_watch(gaddr, who, event, routine, arg)
  address who, gaddr;
  ifunc *routine;
  char *arg;
  {
        register wnode *wp;
        register queue *qp;
        register address *vp;
        groupview *gv;
        int w_event();

        who.entry = gaddr.entry = 0;
        if((gv = pg_getview(gaddr)) == 0)
            return(-1);
        if(!addr_isnull(who))
        {
            for(vp = gv->gv_members; !addr_isnull(*vp); vp++)
                if(addr_cmp(*vp, who) == 0)
                    break;
            if(event == W_LEAVE && addr_isnull(*vp))
                return(0);
            else if(event == W_JOIN && !addr_isnull(*vp))
                return(0);
        }
        if((qp = pg_find(isis_wlist, gaddr)) == 0)
            qp = pg_add_qu(isis_wlist, gaddr, qu_null());
        wp = w_alloc();
        wp->w_gaddr = gaddr;
        wp->w_paddr = who;
        wp->w_proc = routine;
        wp->w_arg = arg;
        wp->w_id = ++WID;
        wp->w_act = isis_ctp->task_act;
        act_ev(1, wp->w_act, ACT_WATCH);
        wp->w_mode = event;
        (void)pg_add_wp(qp->qu_queue, who, wp, w_free);
        if(event == W_JOIN)
        {
            int pg_failed_first();
            wp->w_jid = proc_watch(who, pg_failed_first, (char*)wp);
        }
        else
            wp->w_jid = 0;
        return(wp->w_id);
  }

pg_failed_first(paddr, event, wp)
  address paddr;
  register wnode *wp;
  {
        isis_ctp->task_routine = wp->w_proc;
        isis_ctp->task_arg0 = wp->w_arg;
        isis_ctp->task_act = wp->w_act;
        wp->w_jid = 0;
        if(wp->w_proc == pg_failed_first)
            panic("pg_failed_first recursion bug");
        (*wp->w_proc)(wp->w_gaddr, wp->w_paddr, W_FAIL, wp->w_arg);
        pg_watch_cancel(wp->w_id);
  }

static  address g_paddr;

do_pmonitor()
  {
        address paddrs[2];
        /* This blocks */
        paddrs[0] = g_paddr;
        paddrs[1] = NULLADDRESS;
        if(cl_pmonitor(g_paddr) != -1)
            return;
        do_cl_proc_failed(paddrs);
  }

proc_watch(paddr, routine, arg)
  address paddr;
  ifunc *routine;
  char *arg;
  {
        register wnode *wp;
        register queue *qp;
        register address *vp;
        groupview *gv;
        int w_event();

        /* Monitor a process that isn't a member of any group */
        paddr.entry = 0;
        g_paddr = paddr;
        t_fork_urgent(do_pmonitor, 0);
        wp = w_alloc();
        wp->w_proc = routine;
        wp->w_arg = arg;
        wp->w_id = ++PWID;
        wp->w_act = isis_ctp->task_act;
        act_ev(1, wp->w_act, ACT_WATCH);
        wp->w_mode = W_FAIL;
        (void)pg_add_wp(isis_pwlist, paddr, wp, w_free);
        return(wp->w_id);
  }

static pwatch_call(qp)
  register queue *qp;
  {
        register wnode *wp = qp->qu_wnode;
        isis_ctp->task_routine = wp->w_proc;
        isis_ctp->task_arg0 = wp->w_arg;
        isis_ctp->task_act = wp->w_act;
        (*wp->w_proc)(qp->qu_pname, W_FAIL, wp->w_arg);
        qu_free(qp);
  }

/* If a site crashes, check to see if we were monitoring any processes there */
static w_new_sl(sv)
  register sview *sv;
  {
        register queue *qp, *nqp;
        for(qp = isis_pwlist->qu_next; qp != isis_pwlist; qp = nqp)
        {
            nqp = qp->qu_next;
            if(isis_mutex && qp->qu_wnode->w_act != isis_mutex)
                continue;
            if(sv->sv_incarn[qp->qu_pname.site] != qp->qu_pname.incarn)
            {   
                qu_remove(qp);
                t_fork(pwatch_call, qp);
            }
        }
  }


pg_watch_cancel(wid)
  {
        register queue *gp, *qp;
        for(gp = isis_wlist->qu_next; gp != isis_wlist; gp = gp->qu_next)
            for(qp = gp->qu_queue->qu_next; qp != gp->qu_queue; qp = qp->qu_next)
                if(qp->qu_wnode->w_id == wid)
                {
                    register jid = qp->qu_wnode->w_jid;
                    qu_free(qp);
                    if(jid && jid != -1)
                        proc_watch_cancel(jid);
                    if(qu_head(gp->qu_queue) == 0)
                        qu_free(gp);
                    return(0);
                }
        return(-1);
  }

proc_watch_cancel(wid)
  {
        register queue *gp, *qp;
        for(qp = isis_pwlist->qu_next; qp != isis_pwlist; qp = qp->qu_next)
            if(qp->qu_wnode->w_id == wid)
            {
                qu_free(qp);
                return(0);
            }
        return(-1);
  }

static watch_call(qp)
  register queue *qp;
  {
        register wnode *wp = qp->qu_wnode;
        register jid;
        isis_ctp->task_routine = wp->w_proc;
        isis_ctp->task_arg0 = wp->w_arg;
        isis_ctp->task_act = wp->w_act;
        (*wp->w_proc)(wp->w_gaddr, qp->qu_pname, wp->w_mode, wp->w_arg);
        jid = wp->w_jid;
        qu_free(qp);
        if(jid)
            proc_watch_cancel(jid);
  }

w_new_view(gv)
  register groupview *gv;
  {
        register queue *wq, *qp, *nqp, *wroot;
        register count;
        if((wroot = pg_find(isis_wlist, gv->gv_gaddr)) == 0)
            return;
        wq = wroot->qu_queue;
        for(qp = wq->qu_next; qp != wq; qp = nqp)
        {
            register address *ap;
            register wnode *wp = qp->qu_wnode;

            nqp = qp->qu_next;

            if(isis_mutex && qp->qu_wnode->w_act != isis_mutex)
                continue;
            if(wp->w_mode == W_LEAVE)
            {
                if(!addr_isnull(qp->qu_pname))
                {
                    for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
                        if(addr_cmp(*ap, qp->qu_pname) == 0)
                            break;
                    if(!addr_isnull(*ap))
                        continue;
                }
                else
                {
                    if(addr_isnull(gv->gv_departed))
                        continue;
                    qp->qu_pname = gv->gv_departed;
                }
            }
            else
            {
                if(!addr_isnull(qp->qu_pname))
                {
                    for(ap = gv->gv_members; !addr_isnull(*ap); ap++)
                        if(addr_cmp(*ap, qp->qu_pname) == 0)
                            break;
                    if(addr_isnull(*ap))
                        continue;
                }
                else
                {
                    if(addr_isnull(gv->gv_joined))
                        continue;
                    qp->qu_pname = gv->gv_joined;
                }
            }
            qu_remove(qp);
            t_fork(watch_call, qp);
        }
        if(wq->qu_next == wq)
            qu_free(wroot);
  }

cl_pmonitor(addr)
  address addr;
  {
        register message *mp;
        int outcome;
        mp = msg_genmsg(CL_PNAME, &addr, FTYPE_ADDRESS, sizeof(address), 0);
        isis(CL_PMONITOR, mp, &outcome, sizeof(outcome));
        msg_delete(mp);
        return(outcome);
  }

cl_proc_failed(mp)
  register message *mp;
  {
        do_cl_proc_failed((address*)msg_getfield(mp, CL_PNAME, 1, NULLIARG));
  }

do_cl_proc_failed(ap)
  register address *ap;
  {
        register queue *qp, *nqp;
        extern condition wants_to_run_after_join;
        while(isis_joining)
            (void)t_wait_l(&wants_to_run_after_join, "isis system: proc_failed waiting for join to finish");
        for(qp = isis_pwlist->qu_next; qp != isis_pwlist; qp = nqp)
        {
            nqp = qp->qu_next;
            if(isis_mutex && qp->qu_wnode->w_act != isis_mutex)
                continue;
            if(addr_cmp(qp->qu_pname, *ap) == 0)
            {
                qu_remove(qp);
                t_fork(pwatch_call, qp);
            }
        }
  }

proc_monitor_dump()
  {
        register queue *gp, *qp;
        for(gp = isis_wlist->qu_next; gp != isis_wlist; gp = gp->qu_next)
            for(qp = gp->qu_queue->qu_next; qp != gp->qu_queue; qp = qp->qu_next)
            {
                register wnode *wp = qp->qu_wnode;
                print("  [act %d wid %x]: Watch addr ", wp->w_act, wp->w_id);
                paddr(qp->qu_pname);
                print(", ");
                paddr(gp->qu_pname);
                print(". Call ");
                cl_rname(wp->w_proc);
                print("(%x)\n", wp->w_arg);
            }
        for(qp = isis_pwlist->qu_next; qp != isis_pwlist; qp = qp->qu_next)
        {
            register wnode *wp = qp->qu_wnode;
            print("  [act %d wid %x]: Watch process ", wp->w_act, wp->w_id);
            paddr(qp->qu_pname);
            print(". Call ");
            cl_rname(wp->w_proc);
            print("(%x)\n", wp->w_arg);
        }
  }
