/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *  Task.c -- code related to task management
 */

# include <string.h>

# include "isis.h"

task    isis_scheduler;              /* Task descriptor for system task */      
task    *isis_ctp = &isis_scheduler;      /* Scheduler is running initially */

/* On some machine setjmp and longjmp work fine for ISIS */
#ifdef  GOULD
#    define    isis_setjmp      _setjmp
#    define    isis_longjmp     _longjmp
#endif
#ifdef  NEXT
#    define    isis_setjmp      _setjmp
#    define    isis_longjmp     _longjmp
#endif
#ifdef  APOLLO
#    define    isis_setjmp      _setjmp
#    define    isis_longjmp     _longjmp
#endif
#ifdef  HPUX
#ifdef    hp9000s800
#    define    isis_setjmp      _setjmp
#    define    isis_longjmp     _longjmp
#endif    hp9000s800
#endif
#ifdef  SUN4
#    include   "jmp_pragmas.h"
#endif

static  message *task_msg_arg;
int     STACKLEN, TASKLEN;
address NULLADDRESS;
static  entry_stacksize[128];
#define	esize(n)	(n >= 0 && n <= 127 && entry_stacksize[n])
         
static adesc   st_ad ={ 0, 0, 4};

# define        st_alloc()      ((task*)mallocate(&st_ad))
# define        st_free(x)      mdeallocate((char*)x, &st_ad)

t_init()
  {
        if(TASKLEN == 0)
            t_set_stacksize(DEF_TASKLEN); 
  }
 
#define task_enqueue(cp, tp, discipline)                        \
  {                                                             \
        if(tp)                                                  \
        {                                                       \
            register queue *qp;                                 \
            if((qp = *cp) == 0)                                 \
            {                                                   \
                qu_tnull(qp);                                   \
                *cp = qp;                                       \
            }                                                   \
            if(discipline == SU)                                \
                qu_add_tp(qp->qu_next, TA_ISTASK, tp);          \
            else                                                \
                qu_add_tp(qp, TA_ISTASK, tp);                   \
            tp->task_queue = cp;                                \
        }                                                       \
  }

task *
do_task_dequeue(cp)
  register condition *cp;
  {
        register queue *qp, *np;
        register task *tp;
        qp = *cp;
        np = qu_head(qp);
        tp = np->qu_task;
        tp->task_queue = 0;
        qu_free(np);
        if(qp->qu_next == qp)
        {
            qu_free(qp);
            *cp = 0;
        }
        return(tp);
  }

t_set_stacksize(size) 
  register size;
  { 
        if(TASKLEN)
            panic("t_set_stacksize: attempted to CHANGE the stack size after it was set!");
        size = (size + 1023) & ~1023;
# ifdef SUN4
        /* RISC machines tend to be big stack users */
        size <<= 2;
# endif
        TASKLEN = size; 
        st_ad.a_isize = size;
        STACKLEN = TASKLEN - ((int)(NULLTASK)->task_data)-(1 words); 
  }

isis_entry_stacksize(entry, size)
  {
        entry_stacksize[entry] = size+sizeof(task);
  }

t_scheck()
  {
        char stackp;
        if(&stackp <= isis_ctp->task_data && isis_ctp != &isis_scheduler)
            spanic();
  }

spanic()
  {
        int stackp;
        print("ISIS stack overflow for task ");
        cl_rname(isis_ctp->task_routine);
        print("(%x) (stackp %x bounds [%x-%x]\n", isis_ctp->task_arg0, &stackp, isis_ctp->task_data, &isis_ctp->task_data[STACKLEN]-(1 words));
        panic("ISIS stack overflow");
  }

#define T_scheck()                                                      \
  {                                                                     \
        char stackp;                                                    \
        if(&stackp <= isis_ctp->task_data && isis_ctp != &isis_scheduler)\
            spanic();                                                   \
  }

isis_fork_urgent(routine, arg0, mp)
  ifunc *routine;
  char *arg0;
  message *mp;
  {
        if(task_msg_arg = mp)
            msg_increfcount(mp);
        task_enqueue(&isis_runqueue, isis_ctp, SU);
        task_swtch(NULLTASK, routine, arg0);
  }

static  task *urgent_task, *new_task, *T_fork();

task *
isis_fork(routine, arg0, mp)
  ifunc *routine;
  char *arg0;
  message *mp;
  {
        if(task_msg_arg = mp)
            msg_increfcount(mp);
        urgent_task = isis_ctp;
        task_swtch(NULLTASK, routine, arg0);
        return(new_task);
  }

static delayedcall(routine, arg0)
  ifunc *routine;
  char *arg0;
  {
        register task *tp = urgent_task;
        urgent_task = 0;
        new_task = isis_ctp;
        task_enqueue(&isis_runqueue, isis_ctp, SD);
        task_swtch(tp, NULLROUTINE, NULLARG);
        (*routine)(arg0);
  }

static  char *stackp;
static  ifunc *call_on_sys_stack;
static  char *call_arg;
static  condition call_wait;

t_on_sys_stack(routine, arg)
  ifunc *routine;
  char *arg;
  {
        register res;
        if(isis_ctp == &isis_scheduler)
            return( (*routine)(arg) );
        call_on_sys_stack = routine;
        call_arg = arg;
        res = t_wait_l(&call_wait, "isis system: waiting for a call on sys stack to finish");
        return(res);
  }

task_swtch(tp, routine, arg0)
  register task *tp;
  register ifunc *routine;
  register char *arg0;
  {
        static task *free_tp = 0;
        if(call_on_sys_stack)
            panic("Illegal attempt to wait while running on system stack");
        T_scheck();
        /* Save entry information */
        while(isis_setjmp(isis_ctp->task_env))
        {
            if(free_tp)
            {
                if(free_tp->task_entry != -1 && esize(free_tp->task_entry))
                    free(free_tp);
                else
                    st_free(free_tp);
                free_tp = 0;
            }
            if(isis_ctp == &isis_scheduler && call_on_sys_stack)
            {
                register res = (*call_on_sys_stack)(call_arg);
                t_sig(&call_wait, res);
                call_on_sys_stack = 0;
            }
            return;
        }
        /* Allocate a stack for the new task if needed */
        if(tp == 0)
        {
            if((isis_state&ISIS_RECEIVING) && esize(isis_enum))
                tp = (task*)malloc(entry_stacksize[isis_enum]);
            else
                tp = st_alloc();
            ++isis_created;
            tp->task_queue = 0;
            tp->task_msgid = 0;
            tp->task_cond = 0;
            tp->task_waitingfor = 0;
            tp->task_mwant = 0;
            tp->task_msg = 0;
            tp->task_flag = 0;
            tp->task_act = isis_ctp->task_act;
            bclr(tp->task_watching);
            tp->task_msgs = qu_null();
            tp->task_active = qu_add_tp(isis_tasks, TA_ISTASK, tp);
            tp->task_routine = routine;
            tp->task_arg0 = arg0;
            tp->task_addr = my_address;
            tp->task_msg_arg = task_msg_arg;
            tp->task_cohorts = (address*)0;
            task_msg_arg = 0;
            isis_ctp = tp;
            /* Change stack pointers.  Alignment is important for many machines */ 
#           if(VAX)
            {
                stackp = &isis_ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movl  _stackp,sp");
            }   
#           endif
#           if(GOULD)
            {
                stackp = &isis_ctp->task_data[STACKLEN-(24 words)];
                stackp = (char*)((int)stackp & ~0x7);
                asm("movw  _stackp,b2");
            }   
#           endif
#           if(SUN3)
            {
                stackp = &isis_ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movl  _stackp,sp");
            }   
#           endif
#           if(NEXT)
            {
                stackp = &isis_ctp->task_data[STACKLEN-(16 words)];
                stackp = (char*)((int)stackp & ~0x3);
                asm("movel  _stackp,sp");
            }   
#           endif
#           if(SUN4)
            {
#               include <sun4/asm_linkage.h>
                stackp = &isis_ctp->task_data[STACKLEN-(32 words)];
                stackp = (char*)((int)stackp & ~(STACK_ALIGN-1));
                asm("sethi   %hi(_stackp),%o0");
                asm("ld      [%o0+%lo(_stackp)],%sp");
            }   
#           endif
#           if(HPUX)
            {
#ifdef          hp9000s300
                    stackp = &isis_ctp->task_data[STACKLEN-(2 words)];
                    stackp = (char*)((int)stackp & ~0x3);
                    asm("mov.l  _stackp,%sp");
#endif          hp9000s300
#ifdef          hp9000s800
                    stackp = &isis_ctp->task_data[0];
                    stackp = (char*)((((int)stackp+7) & ~0x7)+ 48);
                    set_sp(stackp);
#endif          hp9000s800

            }
#           endif
#           if(APOLLO)
            {
                jmp_buf tmp_buf;
                stackp = &isis_ctp->task_data[STACKLEN-(2 words)];
                stackp = (char*)((int)stackp & ~0x3);
                if(_setjmp(tmp_buf) == 0)
                {
                     /* Ghastly hack */
                     tmp_buf[sizeof(tmp_buf)/sizeof(long)-1] = (int)stackp;
                     _longjmp(tmp_buf);
                }
            }    
#           endif
            /* Initial invocation of a routine */
            if(isis_state&ISIS_RECEIVING)
            {
                isis_state &= ~ISIS_RECEIVING;
                tp->task_entry = isis_enum;
                tp->task_addr.entry = isis_enum;
                isis_enum = 0;
                if(isis_gip)
                    tp->task_flag |= TASK_LOGGED;
                if(bit(inhibit_entries, isis_enum))
                {
                    tp->task_flag |= TASK_INHIBIT;
                    pg_join_inhibit(1);
                }
                if(isis_eid)
                    tp->task_eid = *isis_eid;
            }
            else
                tp->task_entry = -1;
            if(urgent_task)
                delayedcall(routine, arg0);
            else
                (*routine)(arg0);
            /* Done, deallocate the stack */
            if((isis_state&ISIS_STARTUP) && (isis_ctp->task_flag&TASK_START))
                isis_start_done();
            tp = task_dequeue(&isis_runqueue);
            qu_free(isis_ctp->task_active);
            qu_freeall(isis_ctp->task_msgs);
            if(isis_ctp->task_flag&TASK_LOGGED)
                log_end_log_msg();
            if(isis_ctp->task_flag&TASK_INHIBIT)
                pg_join_inhibit(0);
            if(isis_ctp->task_msg_arg)
                msg_delete(isis_ctp->task_msg_arg);
            free_tp = isis_ctp;
        }
        ++isis_switched;
        isis_ctp = tp;
        isis_longjmp(tp->task_env, 1);
  }

/****************************************************************/
/*                                                              */
/*                 Basic monitor support                        */
/*                                                              */
/****************************************************************/
t_sig(cp, rval)
  register condition *cp;
  {
        register queue *qp;
        if(qp = qu_head(*cp))
        {
            register task *np = task_dequeue(cp);
            qp->qu_task->task_rval = rval;
            task_enqueue(&isis_runqueue, np, SD);
        }
  }

t_sig_all(cp, rval)
  register condition *cp;
  {
        while(*cp)
            t_sig(cp, rval);
  }

t_sig_urgent(cp, rval)
  register condition *cp;
  {
        register queue *qp;

        if(qp = qu_head(*cp))
        {
            qp->qu_task->task_rval = rval;
            task_enqueue(&isis_runqueue, isis_ctp, SU);
            task_swtch(task_dequeue(cp), NULLROUTINE, NULLARG);
        }
  }

#undef  t_wait
t_wait(cp)
  register condition *cp;
  {
        return(t_wait_l(cp, NULLARG));
  }


t_wait_l(cp, why)
  register condition *cp;
  char *why;
  {
        task *tp;
        if(cp != &isis_runqueue && isis_ctp == &isis_scheduler)
        {
            if(why)
                print("t_wait(%s) called from a non-task!", why);
            else
                print("t_wait(user-defined condition:%x) called from a non-task!", cp);
            return(-1);
        }
        isis_ctp->task_waitingfor = why;
        task_enqueue(cp, isis_ctp, SD);
        tp = task_dequeue(&isis_runqueue);
        task_swtch(tp, NULLROUTINE, NULLARG);
        return(isis_ctp->task_rval);
  }

t_suspend()
  {
        task *tp;
        if(isis_ctp != &isis_scheduler)
            return(t_wait_l(&isis_runqueue, "isis system: wants to let other tasks run first"));
        tp = task_dequeue(&isis_runqueue);
        task_swtch(tp, NULLROUTINE, NULLARG);
        return(isis_ctp->task_rval);
  }
